/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.exist.collections.Collection;
import org.exist.dom.NodeSet;
import org.exist.dom.QName;
import org.exist.storage.ElementIndex;
import org.exist.storage.QNameRangeIndexSpec;
import org.exist.xmldb.XmldbURI;
import org.exist.xquery.AnalyzeContextInfo;
import org.exist.xquery.AncestorSelector;
import org.exist.xquery.BasicExpressionVisitor;
import org.exist.xquery.Expression;
import org.exist.xquery.FilteredExpression;
import org.exist.xquery.Function;
import org.exist.xquery.GeneralComparison;
import org.exist.xquery.LocationStep;
import org.exist.xquery.NodeSelector;
import org.exist.xquery.Optimizable;
import org.exist.xquery.Option;
import org.exist.xquery.PathExpr;
import org.exist.xquery.Pragma;
import org.exist.xquery.Predicate;
import org.exist.xquery.SelfSelector;
import org.exist.xquery.VariableReference;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.functions.ExtFulltext;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;

public class Optimize
extends Pragma {
    public static final QName OPTIMIZE_PRAGMA = new QName("optimize", "http://exist.sourceforge.net/NS/exist", "exist");
    private static final Logger LOG = Logger.getLogger((Class)Optimize.class);
    private boolean enabled = true;
    private XQueryContext context;
    private Optimizable[] optimizables;
    private Expression innerExpr = null;
    private LocationStep contextStep = null;
    private VariableReference contextVar = null;
    private int contextId = -1;
    private NodeSet cachedContext = null;
    private int cachedTimestamp;
    private boolean cachedOptimize;

    public Optimize(XQueryContext context, QName pragmaName, String contents, boolean explicit) throws XPathException {
        super(pragmaName, contents);
        this.context = context;
        boolean bl = this.enabled = explicit || context.optimizationsEnabled();
        if (contents != null && contents.length() > 0) {
            String[] param = Option.parseKeyValuePair(contents);
            if (param == null) {
                throw new XPathException("Invalid content found for pragma exist:optimize: " + contents);
            }
            if ("enable".equals(param[0])) {
                this.enabled = "yes".equals(param[1]);
            }
        }
    }

    public void analyze(AnalyzeContextInfo contextInfo) throws XPathException {
        super.analyze(contextInfo);
        this.contextId = contextInfo.getContextId();
    }

    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        if (contextItem != null) {
            contextSequence = contextItem.toSequence();
        }
        boolean useCached = false;
        boolean optimize = false;
        NodeSet originalContext = null;
        if (contextSequence == null || contextSequence.isPersistentSet()) {
            NodeSet nodeSet = originalContext = contextSequence == null ? null : contextSequence.toNodeSet();
            if (this.cachedContext != null && this.cachedContext == originalContext) {
                boolean bl = useCached = !originalContext.hasChanged(this.cachedTimestamp);
            }
            if (this.contextVar != null) {
                contextSequence = this.contextVar.eval(contextSequence);
            }
            if (useCached) {
                optimize = this.cachedOptimize;
            } else if (this.optimizables != null && this.optimizables.length > 0) {
                for (int i = 0; i < this.optimizables.length; ++i) {
                    if (!this.optimizables[i].canOptimize(contextSequence)) {
                        optimize = false;
                        break;
                    }
                    optimize = true;
                }
            }
        }
        if (optimize) {
            this.cachedContext = originalContext;
            this.cachedTimestamp = originalContext == null ? 0 : originalContext.getState();
            this.cachedOptimize = true;
            NodeSet result = null;
            for (int current = 0; current < this.optimizables.length; ++current) {
                NodeSet ancestors;
                NodeSet selection = this.optimizables[current].preSelect(contextSequence, current > 0);
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("exist:optimize: pre-selection: " + selection.getLength()));
                }
                if (this.contextStep == null || current > 0) {
                    ancestors = selection.selectAncestorDescendant(contextSequence.toNodeSet(), 0, true, this.contextId);
                } else {
                    long start = System.currentTimeMillis();
                    NodeSelector selector = new AncestorSelector(selection, this.contextId, true);
                    ElementIndex index = this.context.getBroker().getElementIndex();
                    QName ancestorQN = this.contextStep.getTest().getName();
                    if (this.optimizables[current].optimizeOnSelf()) {
                        selector = new SelfSelector(selection, this.contextId);
                        ancestors = index.findElementsByTagName(ancestorQN.getNameType(), selection.getDocumentSet(), ancestorQN, selector);
                    } else {
                        ancestors = index.findElementsByTagName(ancestorQN.getNameType(), selection.getDocumentSet(), ancestorQN, selector);
                    }
                    if (LOG.isTraceEnabled()) {
                        LOG.trace((Object)("Ancestor selection took " + (System.currentTimeMillis() - start)));
                        LOG.trace((Object)("Found: " + ancestors.getLength()));
                    }
                }
                result = ancestors;
                contextSequence = result;
            }
            if (this.contextStep == null) {
                return this.innerExpr.eval(result);
            }
            this.contextStep.setPreloadNodeSets(true);
            this.contextStep.setPreloadedData(result.getDocumentSet(), result);
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("exist:optimize: context after optimize: " + result.getLength()));
            }
            long start = System.currentTimeMillis();
            contextSequence = originalContext != null ? originalContext.filterDocuments(result) : null;
            Sequence seq = this.innerExpr.eval(contextSequence);
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("exist:optimize: inner expr took " + (System.currentTimeMillis() - start)));
            }
            return seq;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)"exist:optimize: Cannot optimize expression.");
        }
        if (originalContext != null) {
            contextSequence = originalContext;
        }
        return this.innerExpr.eval(contextSequence, contextItem);
    }

    public void before(XQueryContext context, Expression expression) throws XPathException {
        if (this.innerExpr != null) {
            return;
        }
        this.innerExpr = expression;
        if (!this.enabled) {
            return;
        }
        this.innerExpr.accept(new BasicExpressionVisitor(){

            public void visitPathExpr(PathExpr expression) {
                for (int i = 0; i < expression.getLength(); ++i) {
                    Expression next = expression.getExpression(i);
                    next.accept(this);
                }
            }

            public void visitLocationStep(LocationStep locationStep) {
                List predicates = locationStep.getPredicates();
                for (int i = 0; i < predicates.size(); ++i) {
                    Predicate pred = (Predicate)predicates.get(i);
                    pred.accept(this);
                }
            }

            public void visitFilteredExpr(FilteredExpression filtered) {
                Expression filteredExpr = filtered.getExpression();
                if (filteredExpr instanceof VariableReference) {
                    Optimize.this.contextVar = (VariableReference)filteredExpr;
                }
                List predicates = filtered.getPredicates();
                for (int i = 0; i < predicates.size(); ++i) {
                    Predicate pred = (Predicate)predicates.get(i);
                    pred.accept(this);
                }
            }

            public void visit(Expression expression) {
                super.visit(expression);
            }

            public void visitFtExpression(ExtFulltext fulltext) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("exist:optimize: found optimizable: " + fulltext.getClass().getName()));
                }
                Optimize.this.addOptimizable(fulltext);
            }

            public void visitGeneralComparison(GeneralComparison comparison) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("exist:optimize: found optimizable: " + comparison.getClass().getName()));
                }
                Optimize.this.addOptimizable(comparison);
            }

            public void visitPredicate(Predicate predicate) {
                predicate.getExpression(0).accept(this);
            }

            public void visitBuiltinFunction(Function function) {
                if (function instanceof Optimizable) {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace((Object)("exist:optimize: found optimizable function: " + function.getClass().getName()));
                    }
                    Optimize.this.addOptimizable((Optimizable)((Object)function));
                }
            }
        });
        this.contextStep = BasicExpressionVisitor.findFirstStep(this.innerExpr);
        if (this.contextStep != null && this.contextStep.getTest().isWildcardTest()) {
            this.contextStep = null;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("exist:optimize: context step: " + this.contextStep));
            LOG.trace((Object)("exist:optimize: context var: " + this.contextVar));
        }
    }

    public void after(XQueryContext context, Expression expression) throws XPathException {
    }

    private void addOptimizable(Optimizable optimizable) {
        int axis = optimizable.getOptimizeAxis();
        if (axis != 5 && axis != 7 && axis != 8 && axis != 6 && axis != 13) {
            return;
        }
        if (this.optimizables == null) {
            this.optimizables = new Optimizable[1];
            this.optimizables[0] = optimizable;
        } else {
            Optimizable[] o = new Optimizable[this.optimizables.length + 1];
            System.arraycopy(this.optimizables, 0, o, 0, this.optimizables.length);
            o[this.optimizables.length] = optimizable;
            this.optimizables = o;
        }
    }

    public void resetState(boolean postOptimization) {
        super.resetState(postOptimization);
        this.cachedContext = null;
    }

    public static int getQNameIndexType(XQueryContext context, Sequence contextSequence, QName qname) {
        if (contextSequence == null || qname == null) {
            return 11;
        }
        int indexType = 11;
        Iterator i = contextSequence.getCollectionIterator();
        while (i.hasNext()) {
            Collection collection = (Collection)i.next();
            if (collection.getURI().startsWith(XmldbURI.SYSTEM_COLLECTION_URI)) continue;
            QNameRangeIndexSpec config = collection.getIndexByQNameConfiguration(context.getBroker(), qname);
            if (config == null) {
                return 11;
            }
            int type = config.getType();
            if (indexType == 11) {
                indexType = type;
                continue;
            }
            if (indexType == type) continue;
            return 11;
        }
        return indexType;
    }
}

