/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import org.exist.xquery.Dependency;
import org.exist.xquery.Expression;
import org.exist.xquery.PathExpr;
import org.exist.xquery.Profiler;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.util.ExpressionDumper;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.NumericValue;
import org.exist.xquery.value.Sequence;

public class UnaryExpr
extends PathExpr {
    private final int mode;

    public UnaryExpr(XQueryContext context, int mode) {
        super(context);
        this.mode = mode;
    }

    public int returnsType() {
        return 32;
    }

    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().start(this);
            this.context.getProfiler().message((Expression)this, Profiler.DEPENDENCIES, "DEPENDENCIES", Dependency.getDependenciesName(this.getDependencies()));
            if (contextSequence != null) {
                this.context.getProfiler().message((Expression)this, Profiler.START_SEQUENCES, "CONTEXT SEQUENCE", contextSequence);
            }
            if (contextItem != null) {
                this.context.getProfiler().message((Expression)this, Profiler.START_SEQUENCES, "CONTEXT ITEM", contextItem.toSequence());
            }
        }
        if (contextItem != null) {
            contextSequence = contextItem.toSequence();
        }
        if (this.getLength() == 0) {
            throw new XPathException(this.getASTNode(), "unary expression requires an operand");
        }
        NumericValue value = (NumericValue)this.getExpression(0).eval(contextSequence).convertTo(30);
        NumericValue result = this.mode == 9 ? value.negate() : value;
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().end(this, "", result);
        }
        return result;
    }

    public void dump(ExpressionDumper dumper) {
        if (this.mode == 9) {
            dumper.display("-");
        } else {
            dumper.display("to be implemented");
        }
    }

    public String toString() {
        if (this.mode == 9) {
            return "-";
        }
        return "to be implemented";
    }
}

