/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.exist.EXistException;
import org.exist.dom.ExtArrayNodeSet;
import org.exist.dom.NodeProxy;
import org.exist.dom.NodeSet;
import org.exist.dom.NodeSetIterator;
import org.exist.storage.NativeTextEngine;
import org.exist.storage.analysis.TextToken;
import org.exist.storage.analysis.Tokenizer;
import org.exist.util.GlobToRegex;
import org.exist.xquery.AnalyzeContextInfo;
import org.exist.xquery.Expression;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.functions.ExtFulltext;
import org.exist.xquery.util.ExpressionDumper;
import org.exist.xquery.value.IntegerValue;
import org.exist.xquery.value.Sequence;

public class ExtNear
extends ExtFulltext {
    private int min_distance = 1;
    private int max_distance = 1;
    private Expression minDistance = null;
    private Expression maxDistance = null;

    public ExtNear(XQueryContext context) {
        super(context, 1);
    }

    public void analyze(AnalyzeContextInfo contextInfo) throws XPathException {
        super.analyze(new AnalyzeContextInfo(contextInfo));
        if (this.maxDistance != null) {
            this.maxDistance.analyze(contextInfo);
        }
        if (this.minDistance != null) {
            this.minDistance.analyze(contextInfo);
        }
    }

    public NodeSet preSelect(Sequence contextSequence, boolean useContext) throws XPathException {
        String[] terms;
        this.preselectResult = null;
        if (this.maxDistance != null) {
            this.max_distance = ((IntegerValue)this.maxDistance.eval(contextSequence).convertTo(31)).getInt();
        }
        if (this.minDistance != null) {
            this.min_distance = ((IntegerValue)this.minDistance.eval(contextSequence).convertTo(31)).getInt();
        }
        String arg = this.searchTerm.eval(contextSequence).getStringValue();
        try {
            terms = this.getSearchTerms(arg);
        }
        catch (EXistException e) {
            throw new XPathException(this.getASTNode(), e.getMessage(), e);
        }
        NodeSet[] hits = this.getMatches(contextSequence.getDocumentSet(), useContext ? contextSequence.toNodeSet() : null, 1, this.contextQName, terms);
        this.preselectResult = hits[0];
        if (this.preselectResult != null) {
            for (int k = 1; k < hits.length; ++k) {
                if (hits[k] == null) continue;
                this.preselectResult = this.preselectResult.deepIntersection(hits[k]);
            }
        } else {
            this.preselectResult = NodeSet.EMPTY_SET;
        }
        if (terms.length > 1) {
            boolean hasWildcards = false;
            for (int i = 0; i < terms.length; ++i) {
                hasWildcards |= NativeTextEngine.containsWildcards(terms[i]);
            }
            this.preselectResult = (NodeSet)(hasWildcards ? this.patternMatch(this.context, terms, this.preselectResult) : this.exactMatch(this.context, terms, this.preselectResult));
        }
        return this.preselectResult;
    }

    public Sequence evalQuery(String searchArg, NodeSet nodes) throws XPathException {
        String[] terms;
        if (this.maxDistance != null) {
            this.max_distance = ((IntegerValue)this.maxDistance.eval(nodes).convertTo(31)).getInt();
        }
        if (this.minDistance != null) {
            this.min_distance = ((IntegerValue)this.minDistance.eval(nodes).convertTo(31)).getInt();
        }
        try {
            terms = this.getSearchTerms(searchArg);
        }
        catch (EXistException e) {
            throw new XPathException(this.getASTNode(), e.getMessage(), e);
        }
        NodeSet hits = this.processQuery(terms, nodes);
        if (hits == null) {
            return Sequence.EMPTY_SEQUENCE;
        }
        if (terms.length == 1) {
            return hits;
        }
        boolean hasWildcards = false;
        for (int i = 0; i < terms.length; ++i) {
            hasWildcards |= NativeTextEngine.containsWildcards(terms[i]);
        }
        return hasWildcards ? this.patternMatch(this.context, terms, hits) : this.exactMatch(this.context, terms, hits);
    }

    private Sequence exactMatch(XQueryContext context, String[] terms, NodeSet result) {
        ExtArrayNodeSet r = new ExtArrayNodeSet();
        Tokenizer tok = context.getBroker().getTextEngine().getTokenizer();
        NodeSetIterator i = result.iterator();
        block0: while (i.hasNext()) {
            TextToken token;
            NodeProxy current = (NodeProxy)i.next();
            String value = current.getNodeValueSeparated();
            tok.setText(value);
            int j = 0;
            if (j >= terms.length) break;
            String term = terms[j];
            int current_distance = -1;
            while ((token = tok.nextToken()) != null) {
                String word = token.getText().toLowerCase();
                if (current_distance > this.max_distance) {
                    j = 0;
                    term = terms[j];
                    current_distance = -1;
                }
                if (word.equalsIgnoreCase(term)) {
                    boolean withIn = current_distance >= this.min_distance;
                    current_distance = 0;
                    if (++j == terms.length) {
                        if (!withIn) continue block0;
                        r.add(current);
                        continue block0;
                    }
                    term = terms[j];
                } else if (j > 0 && word.equalsIgnoreCase(terms[0])) {
                    j = 1;
                    term = terms[j];
                    current_distance = 0;
                    continue;
                }
                if (-1 >= current_distance) continue;
                ++current_distance;
            }
        }
        return r;
    }

    private Sequence patternMatch(XQueryContext context, String[] terms, NodeSet result) {
        Pattern[] patterns = new Pattern[terms.length];
        Matcher[] matchers = new Matcher[terms.length];
        for (int i = 0; i < patterns.length; ++i) {
            try {
                patterns[i] = Pattern.compile(GlobToRegex.globToRegexp(terms[i]), 66);
                matchers[i] = patterns[i].matcher("");
                continue;
            }
            catch (PatternSyntaxException e) {
                LOG.warn((Object)"malformed pattern", (Throwable)e);
                return Sequence.EMPTY_SEQUENCE;
            }
        }
        ExtArrayNodeSet r = new ExtArrayNodeSet(100);
        Tokenizer tok = context.getBroker().getTextEngine().getTokenizer();
        NodeSetIterator i = result.iterator();
        block3: while (i.hasNext()) {
            TextToken token;
            NodeProxy current = (NodeProxy)i.next();
            String value = current.getNodeValueSeparated();
            tok.setText(value);
            int j = 0;
            if (j >= patterns.length) break;
            Matcher matcher = matchers[j];
            int current_distance = -1;
            while ((token = tok.nextToken()) != null) {
                String word = token.getText().toLowerCase();
                if (current_distance > this.max_distance) {
                    j = 0;
                    matcher = matchers[j];
                    current_distance = -1;
                }
                matcher.reset(word);
                matchers[0].reset(word);
                if (matcher.matches()) {
                    boolean withIn = current_distance >= this.min_distance;
                    current_distance = 0;
                    if (++j == patterns.length) {
                        if (!withIn) continue block3;
                        r.add(current);
                        continue block3;
                    }
                    matcher = matchers[j];
                } else if (j > 0 && matchers[0].matches()) {
                    j = 1;
                    matcher = matchers[j];
                    current_distance = 0;
                    continue;
                }
                if (-1 >= current_distance) continue;
                ++current_distance;
            }
        }
        return r;
    }

    public void dump(ExpressionDumper dumper) {
        dumper.display("near(");
        this.path.dump(dumper);
        dumper.display(", ");
        this.searchTerm.dump(dumper);
        dumper.display(")");
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("near(");
        buf.append(this.path);
        buf.append(", ");
        buf.append(this.searchTerm);
        buf.append(")");
        return buf.toString();
    }

    public void setMaxDistance(Expression expr) {
        this.maxDistance = expr;
    }

    public void setMinDistance(Expression expr) {
        this.minDistance = expr;
    }
}

