/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.exist.collections.Collection;
import org.exist.dom.DocumentSet;
import org.exist.dom.ExtArrayNodeSet;
import org.exist.dom.NodeSet;
import org.exist.dom.QName;
import org.exist.storage.FulltextIndexSpec;
import org.exist.xmldb.XmldbURI;
import org.exist.xquery.AnalyzeContextInfo;
import org.exist.xquery.BasicExpressionVisitor;
import org.exist.xquery.CachedResult;
import org.exist.xquery.Dependency;
import org.exist.xquery.Expression;
import org.exist.xquery.Function;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.LocationStep;
import org.exist.xquery.NodeTest;
import org.exist.xquery.Optimizable;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.util.RegexTranslator;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;
import org.exist.xquery.value.SequenceType;

public class ExtRegexp
extends Function
implements Optimizable {
    public static final FunctionSignature signature = new FunctionSignature(new QName("match-all", "http://www.w3.org/2005/xpath-functions"), "eXist-specific extension function. Tries to match each of the regular expression strings passed in $b and all following parameters against the keywords contained in the fulltext index. The keywords found are then compared to the node set in $a. Every node containing all of the keywords is copied to the result sequence.", new SequenceType[]{new SequenceType(-1, 7), new SequenceType(22, 6)}, new SequenceType(-1, 7), true, "This function is eXist-specific and should not be in the standard functions namespace. Please use text:match-all() instead.");
    protected int type = 1;
    protected CachedResult cached = null;
    private LocationStep contextStep = null;
    protected QName contextQName = null;
    protected boolean optimizeSelf = false;
    protected int axis = -1;
    protected NodeSet preselectResult = null;

    public ExtRegexp(XQueryContext context) {
        super(context, signature);
    }

    public ExtRegexp(XQueryContext context, int type) {
        super(context, signature);
        this.type = type;
    }

    public ExtRegexp(XQueryContext context, int type, FunctionSignature signature) {
        super(context, signature);
        this.type = type;
    }

    public void analyze(AnalyzeContextInfo contextInfo) throws XPathException {
        super.analyze(contextInfo);
        List steps = BasicExpressionVisitor.findLocationSteps(this.getArgument(0));
        if (!steps.isEmpty()) {
            LocationStep firstStep = (LocationStep)steps.get(0);
            LocationStep lastStep = (LocationStep)steps.get(steps.size() - 1);
            if (steps.size() == 1 && firstStep.getAxis() == 12) {
                LocationStep outerStep;
                NodeTest test;
                Expression outerExpr = contextInfo.getContextStep();
                if (outerExpr != null && outerExpr instanceof LocationStep && !(test = (outerStep = (LocationStep)outerExpr).getTest()).isWildcardTest() && test.getName() != null) {
                    this.contextQName = new QName(test.getName());
                    if (outerStep.getAxis() == 6 || outerStep.getAxis() == 13) {
                        this.contextQName.setNameType((byte)1);
                    }
                    this.contextStep = firstStep;
                    this.axis = outerStep.getAxis();
                    this.optimizeSelf = true;
                }
            } else {
                NodeTest test = lastStep.getTest();
                if (!test.isWildcardTest() && test.getName() != null) {
                    this.contextQName = new QName(test.getName());
                    if (lastStep.getAxis() == 6 || lastStep.getAxis() == 13) {
                        this.contextQName.setNameType((byte)1);
                    }
                    this.contextStep = lastStep;
                    this.axis = firstStep.getAxis();
                    if (this.axis == 12 && steps.size() > 1) {
                        this.axis = ((LocationStep)steps.get(1)).getAxis();
                    }
                }
            }
        }
    }

    public boolean canOptimize(Sequence contextSequence) {
        if (this.contextQName == null) {
            return false;
        }
        return this.checkForQNameIndex(contextSequence);
    }

    public boolean optimizeOnSelf() {
        return this.optimizeSelf;
    }

    public int getOptimizeAxis() {
        return this.axis;
    }

    public NodeSet preSelect(Sequence contextSequence, boolean useContext) throws XPathException {
        this.preselectResult = null;
        List terms = this.getSearchTerms(contextSequence);
        NodeSet[] hits = this.getMatches(contextSequence.getDocumentSet(), useContext ? contextSequence.toNodeSet() : null, 1, this.contextQName, terms);
        this.preselectResult = hits[0];
        if (this.preselectResult != null) {
            for (int k = 1; k < hits.length; ++k) {
                if (hits[k] == null) continue;
                this.preselectResult = this.type == 1 ? this.preselectResult.deepIntersection(hits[k]) : this.preselectResult.union(hits[k]);
            }
        } else {
            this.preselectResult = NodeSet.EMPTY_SET;
        }
        return this.preselectResult;
    }

    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        NodeSet result;
        Expression path;
        if (this.preselectResult != null && this.preselectResult.isEmpty()) {
            return Sequence.EMPTY_SEQUENCE;
        }
        if (contextItem != null) {
            contextSequence = contextItem.toSequence();
        }
        if (this.preselectResult == null && !this.checkForQNameIndex(contextSequence)) {
            this.contextQName = null;
        }
        if ((path = this.getArgument(0)) == null || !Dependency.dependsOn(path, 2)) {
            boolean canCache;
            boolean bl = canCache = (this.getTermDependencies() & 2) == 0;
            if (canCache && this.cached != null && this.cached.isValid(contextSequence, contextItem)) {
                return this.cached.getResult();
            }
            if (this.contextStep == null || this.preselectResult == null) {
                NodeSet nodes = path == null ? contextSequence.toNodeSet() : path.eval(contextSequence).toNodeSet();
                List terms = this.getSearchTerms(contextSequence);
                result = this.evalQuery(nodes, terms).toNodeSet();
            } else {
                this.contextStep.setPreloadNodeSets(true);
                this.contextStep.setPreloadedData(contextSequence.getDocumentSet(), this.preselectResult);
                result = path.eval(contextSequence).toNodeSet();
            }
            if (canCache && contextSequence.isCacheable()) {
                this.cached = new CachedResult(contextSequence, contextItem, result);
            }
        } else {
            result = new ExtArrayNodeSet();
            SequenceIterator i = contextSequence.iterate();
            while (i.hasNext()) {
                Item current = i.nextItem();
                List terms = this.getSearchTerms(contextSequence);
                NodeSet nodes = path == null ? contextSequence.toNodeSet() : path.eval(current.toSequence()).toNodeSet();
                Sequence temp = this.evalQuery(nodes, terms);
                result.addAll(temp);
            }
        }
        this.preselectResult = null;
        return result;
    }

    private boolean checkForQNameIndex(Sequence contextSequence) {
        if (contextSequence == null || this.contextQName == null) {
            return false;
        }
        boolean hasQNameIndex = true;
        Iterator i = contextSequence.getCollectionIterator();
        while (i.hasNext()) {
            Collection collection = (Collection)i.next();
            if (collection.getURI().equals(XmldbURI.SYSTEM_COLLECTION_URI)) continue;
            FulltextIndexSpec config = collection.getFulltextIndexConfiguration(this.context.getBroker());
            if (config != null) {
                hasQNameIndex = config.hasQNameIndex(this.contextQName);
            }
            if (hasQNameIndex) continue;
            if (!LOG.isTraceEnabled()) break;
            LOG.trace((Object)("cannot use index on QName: " + this.contextQName + ". Collection " + collection.getURI() + " does not define an index"));
            break;
        }
        return hasQNameIndex;
    }

    public int getDependencies() {
        int deps = 0;
        for (int i = 0; i < this.getArgumentCount(); ++i) {
            deps |= this.getArgument(i).getDependencies();
        }
        return deps;
    }

    public Sequence evalQuery(NodeSet nodes, List terms) throws XPathException {
        if (terms == null || terms.size() == 0) {
            return Sequence.EMPTY_SEQUENCE;
        }
        NodeSet[] hits = this.getMatches(nodes.getDocumentSet(), nodes, 0, this.contextQName, terms);
        NodeSet result = hits[0];
        if (result != null) {
            for (int k = 1; k < hits.length; ++k) {
                if (hits[k] == null) continue;
                result = this.type == 1 ? result.deepIntersection(hits[k]) : result.union(hits[k]);
            }
            return result;
        }
        return NodeSet.EMPTY_SET;
    }

    protected NodeSet[] getMatches(DocumentSet docs, NodeSet contextSet, int axis, QName qname, List terms) throws XPathException {
        NodeSet[] hits = new NodeSet[terms.size()];
        for (int k = 0; k < terms.size(); ++k) {
            hits[k] = this.context.getBroker().getTextEngine().getNodesContaining(this.context, docs, contextSet, axis, qname, (String)terms.get(k), 1);
            LOG.debug((Object)("Matches for " + terms.get(k) + ": " + hits[k].getLength()));
        }
        return hits;
    }

    protected List getSearchTerms(Sequence contextSequence) throws XPathException {
        if (this.getArgumentCount() < 2) {
            throw new XPathException(this.getASTNode(), "function requires at least 2 arguments");
        }
        ArrayList<String> terms = new ArrayList<String>();
        for (int i = 1; i < this.getLength(); ++i) {
            Expression next = this.getArgument(i);
            Sequence seq = next.eval(contextSequence);
            if (seq.hasOne()) {
                terms.add(this.translateRegexp(seq.itemAt(0).getStringValue()));
                continue;
            }
            SequenceIterator it = seq.iterate();
            while (it.hasNext()) {
                terms.add(this.translateRegexp(it.nextItem().getStringValue()));
            }
        }
        return terms;
    }

    protected int getTermDependencies() throws XPathException {
        int deps = 0;
        for (int i = 0; i < this.getArgumentCount(); ++i) {
            deps |= this.getArgument(i).getDependencies();
        }
        return deps;
    }

    public void resetState(boolean postOptimization) {
        super.resetState(postOptimization);
        if (!postOptimization) {
            this.cached = null;
        }
    }

    protected String translateRegexp(String pattern) throws XPathException {
        try {
            pattern = RegexTranslator.translate(pattern, true);
        }
        catch (RegexTranslator.RegexSyntaxException e) {
            throw new XPathException(this.getASTNode(), "Conversion from XPath2 to Java regular expression syntax failed: " + e.getMessage(), e);
        }
        return pattern;
    }
}

