/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions;

import org.exist.dom.QName;
import org.exist.xquery.Dependency;
import org.exist.xquery.Expression;
import org.exist.xquery.Function;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.Profiler;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.AtomicValue;
import org.exist.xquery.value.DateTimeValue;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;

public class FunCurrentDateTime
extends Function {
    public static final FunctionSignature fnCurrentDateTime = new FunctionSignature(new QName("current-dateTime", "http://www.w3.org/2005/xpath-functions"), "Returns the xs:dateTime (with timezone) that is current at some time during the evaluation of a query or transformation in which fn:current-dateTime() is executed.", null, new SequenceType(50, 2));
    public static final FunctionSignature fnCurrentTime = new FunctionSignature(new QName("current-time", "http://www.w3.org/2005/xpath-functions"), "Returns the xs:time (with timezone) that is current at some time during the evaluation of a query or transformation in which fn:current-time() is executed.", null, new SequenceType(52, 2));
    public static final FunctionSignature fnCurrentDate = new FunctionSignature(new QName("current-date", "http://www.w3.org/2005/xpath-functions"), "Returns the xs:date (with timezone) that is current at some time during the evaluation of a query or transformation in which fn:current-date() is executed.", null, new SequenceType(51, 2));

    public FunCurrentDateTime(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().start(this);
            this.context.getProfiler().message((Expression)this, Profiler.DEPENDENCIES, "DEPENDENCIES", Dependency.getDependenciesName(this.getDependencies()));
            if (contextSequence != null) {
                this.context.getProfiler().message((Expression)this, Profiler.START_SEQUENCES, "CONTEXT SEQUENCE", contextSequence);
            }
            if (contextItem != null) {
                this.context.getProfiler().message((Expression)this, Profiler.START_SEQUENCES, "CONTEXT ITEM", contextItem.toSequence());
            }
        }
        AtomicValue result = new DateTimeValue(this.context.getCalendar());
        if (!this.isCalledAs("current-dateTime")) {
            if (this.isCalledAs("current-date")) {
                result = result.convertTo(51);
            } else if (this.isCalledAs("current-time")) {
                result = result.convertTo(52);
            } else {
                throw new Error("can't handle function " + this.mySignature.getName().getLocalName());
            }
        }
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().end(this, "", result);
        }
        return result;
    }

    public int getDependencies() {
        return 1;
    }
}

