/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.exist.dom.NodeProxy;
import org.exist.dom.NodeSet;
import org.exist.dom.QName;
import org.exist.memtree.ElementImpl;
import org.exist.memtree.NodeImpl;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.Dependency;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.Profiler;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.NodeValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.StringValue;
import org.exist.xquery.value.ValueSequence;
import org.w3c.dom.Element;

public class FunInScopePrefixes
extends BasicFunction {
    public static final FunctionSignature signature = new FunctionSignature(new QName("in-scope-prefixes", "http://www.w3.org/2005/xpath-functions"), "Returns the prefixes of the in-scope namespaces for $a. For namespaces that have a prefix, it returns the prefix as an xs:NCName. For the default namespace, which has no prefix, it returns the zero-length string.", new SequenceType[]{new SequenceType(1, 2)}, new SequenceType(22, 7));

    public FunInScopePrefixes(XQueryContext context) {
        super(context, signature);
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        Iterator i;
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().start(this);
            this.context.getProfiler().message((Expression)this, Profiler.DEPENDENCIES, "DEPENDENCIES", Dependency.getDependenciesName(this.getDependencies()));
            if (contextSequence != null) {
                this.context.getProfiler().message((Expression)this, Profiler.START_SEQUENCES, "CONTEXT SEQUENCE", contextSequence);
            }
        }
        LinkedHashMap prefixes = new LinkedHashMap();
        NodeValue node = (NodeValue)args[0].itemAt(0);
        if (node.getImplementationType() == 1) {
            NodeProxy proxy = (NodeProxy)node;
            if (proxy.getNodeType() == 1 && !this.context.inheritNamespaces()) {
                FunInScopePrefixes.collectNamespacePrefixes((org.exist.dom.ElementImpl)proxy.getNode(), prefixes);
            } else {
                NodeSet ancestors = proxy.getAncestors(this.contextId, true);
                i = ancestors.iterator();
                while (i.hasNext()) {
                    proxy = (NodeProxy)i.next();
                    FunInScopePrefixes.collectNamespacePrefixes((org.exist.dom.ElementImpl)proxy.getNode(), prefixes);
                }
            }
        } else {
            NodeImpl next = (NodeImpl)node;
            do {
                FunInScopePrefixes.collectNamespacePrefixes((ElementImpl)next, prefixes);
            } while ((next = (NodeImpl)next.getParentNode()) != null && next.getNodeType() == 1);
        }
        ValueSequence result = new ValueSequence();
        i = prefixes.keySet().iterator();
        while (i.hasNext()) {
            String prefix = (String)i.next();
            if (this.context.getURIForPrefix(prefix) == null && ("exist".equals(prefix) || "xs".equals(prefix) || "xsi".equals(prefix) || "wdt".equals(prefix) || "fn".equals(prefix) || "local".equals(prefix))) continue;
            result.add(new StringValue(prefix));
        }
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().end(this, "", result);
        }
        return result;
    }

    public static void collectNamespacePrefixes(org.exist.dom.ElementImpl element, Map prefixes) {
        String prefix;
        prefixes.put("xml", "http://www.w3.org/XML/1998/namespace");
        String namespaceURI = element.getNamespaceURI();
        if (namespaceURI != null && namespaceURI.length() > 0) {
            prefix = element.getPrefix();
            prefixes.put(prefix == null ? "" : prefix, namespaceURI);
        }
        if (element.declaresNamespacePrefixes()) {
            Iterator i = element.getPrefixes();
            while (i.hasNext()) {
                prefix = (String)i.next();
                prefixes.put(prefix, element.getNamespaceForPrefix(prefix));
            }
        }
    }

    public static void collectNamespacePrefixes(Element element, Map prefixes) {
        prefixes.put("xml", "http://www.w3.org/XML/1998/namespace");
        String namespaceURI = element.getNamespaceURI();
        System.out.println("FunInScopePrefixes::collectNamespacePrefixes Element 1:" + element + "/" + namespaceURI);
        if (namespaceURI != null && namespaceURI.length() > 0) {
            String prefix = element.getPrefix();
            System.out.println("FunInScopePrefixes::collectNamespacePrefixes Element 2:" + element + "/" + prefix);
            prefixes.put(prefix == null ? "" : prefix, namespaceURI);
        }
    }

    public static void collectNamespacePrefixes(ElementImpl element, Map prefixes) {
        prefixes.put("xml", "http://www.w3.org/XML/1998/namespace");
        String namespaceURI = element.getNamespaceURI();
        if (namespaceURI != null && namespaceURI.length() > 0) {
            String prefix = element.getPrefix();
            prefixes.put(prefix == null ? "" : prefix, namespaceURI);
        }
        if (element.declaresNamespacePrefixes()) {
            prefixes.putAll(element.getNamespaceMap());
        }
    }
}

