/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.exist.EXistException;
import org.exist.dom.DocumentSet;
import org.exist.dom.ExtArrayNodeSet;
import org.exist.dom.NodeProxy;
import org.exist.dom.NodeSet;
import org.exist.dom.NodeSetIterator;
import org.exist.dom.QName;
import org.exist.storage.NativeValueIndex;
import org.exist.xquery.AnalyzeContextInfo;
import org.exist.xquery.Atomize;
import org.exist.xquery.BasicExpressionVisitor;
import org.exist.xquery.Dependency;
import org.exist.xquery.DynamicCardinalityCheck;
import org.exist.xquery.Expression;
import org.exist.xquery.Function;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.GeneralComparison;
import org.exist.xquery.IndexUseReporter;
import org.exist.xquery.LocationStep;
import org.exist.xquery.NodeTest;
import org.exist.xquery.Optimizable;
import org.exist.xquery.Optimize;
import org.exist.xquery.Profiler;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.util.Error;
import org.exist.xquery.util.RegexTranslator;
import org.exist.xquery.value.BooleanValue;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.Type;

public class FunMatches
extends Function
implements Optimizable,
IndexUseReporter {
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new QName("matches", "http://www.w3.org/2005/xpath-functions"), "Returns true if the first argument string matches the regular expression specified by the second argument. This function is optimized internally if a range index of type xs:string is defined on the nodes passed to the first argument. Please note that - in contrast - with the specification - this method allows zero or more items for the string argument.", new SequenceType[]{new SequenceType(22, 7), new SequenceType(22, 2)}, new SequenceType(23, 2)), new FunctionSignature(new QName("matches", "http://www.w3.org/2005/xpath-functions"), "Returns true if the first argument string matches the regular expression specified by the second argument. This function is optimized internally if a range index of type xs:string is defined on the nodes passed to the first argument. Please note that - in contrast - with the specification - this method allows zero or more items for the string argument.", new SequenceType[]{new SequenceType(22, 7), new SequenceType(22, 2), new SequenceType(22, 2)}, new SequenceType(23, 2))};
    protected Matcher matcher = null;
    protected Pattern pat = null;
    protected boolean hasUsedIndex = false;
    private LocationStep contextStep = null;
    private QName contextQName = null;
    private int axis = -1;
    private NodeSet preselectResult = null;
    private GeneralComparison.IndexFlags idxflags = new GeneralComparison.IndexFlags();

    public FunMatches(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    public void setArguments(List arguments) throws XPathException {
        List steps;
        Expression path = (Expression)arguments.get(0);
        this.steps.add(path);
        Expression arg = (Expression)arguments.get(1);
        arg = new DynamicCardinalityCheck(this.context, 2, arg, new Error("D02", "2", this.mySignature));
        if (!Type.subTypeOf(arg.returnsType(), 20)) {
            arg = new Atomize(this.context, arg);
        }
        this.steps.add(arg);
        if (arguments.size() == 3) {
            arg = (Expression)arguments.get(2);
            if (!Type.subTypeOf((arg = new DynamicCardinalityCheck(this.context, 2, arg, new Error("D02", "3", this.mySignature))).returnsType(), 20)) {
                arg = new Atomize(this.context, arg);
            }
            this.steps.add(arg);
        }
        if (!(steps = BasicExpressionVisitor.findLocationSteps(path)).isEmpty()) {
            LocationStep firstStep = (LocationStep)steps.get(0);
            LocationStep lastStep = (LocationStep)steps.get(steps.size() - 1);
            NodeTest test = lastStep.getTest();
            if (!test.isWildcardTest() && test.getName() != null) {
                this.contextQName = new QName(test.getName());
                if (lastStep.getAxis() == 6 || lastStep.getAxis() == 13) {
                    this.contextQName.setNameType((byte)1);
                }
                this.contextStep = lastStep;
                this.axis = firstStep.getAxis();
                if (this.axis == 12 && steps.size() > 1) {
                    this.axis = ((LocationStep)steps.get(1)).getAxis();
                }
            }
        }
    }

    public boolean canOptimize(Sequence contextSequence) {
        if (this.contextQName == null) {
            return false;
        }
        return Type.subTypeOf(Optimize.getQNameIndexType(this.context, contextSequence, this.contextQName), 22);
    }

    public boolean optimizeOnSelf() {
        return false;
    }

    public int getOptimizeAxis() {
        return this.axis;
    }

    public NodeSet preSelect(Sequence contextSequence, boolean useContext) throws XPathException {
        this.preselectResult = null;
        int indexType = Optimize.getQNameIndexType(this.context, contextSequence, this.contextQName);
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Using QName index on type " + Type.getTypeName(indexType)));
        }
        String pattern = this.translateRegexp(this.getArgument(1).eval(contextSequence).getStringValue());
        boolean caseSensitive = true;
        int flags = 0;
        if (this.getSignature().getArgumentCount() == 3) {
            String flagsArg = this.getArgument(2).eval(contextSequence).getStringValue();
            caseSensitive = flagsArg.indexOf(105) == -1;
            flags = FunMatches.parseFlags(flagsArg);
        }
        try {
            this.preselectResult = this.context.getBroker().getValueIndex().match(contextSequence.getDocumentSet(), useContext ? contextSequence.toNodeSet() : null, 1, pattern, this.contextQName, 1, flags, caseSensitive);
            this.hasUsedIndex = true;
        }
        catch (EXistException e) {
            throw new XPathException(this.getASTNode(), "Error during index lookup: " + e.getMessage(), e);
        }
        return this.preselectResult;
    }

    public int getDependencies() {
        Expression stringArg = this.getArgument(0);
        Expression patternArg = this.getArgument(1);
        if (Type.subTypeOf(stringArg.returnsType(), -1) && !Dependency.dependsOn(stringArg, 2) && !Dependency.dependsOn(patternArg, 2)) {
            return 1;
        }
        return 3;
    }

    public int returnsType() {
        if (this.inPredicate && (this.getDependencies() & 2) == 0) {
            return -1;
        }
        return 23;
    }

    public boolean hasUsedIndex() {
        return this.hasUsedIndex;
    }

    public void analyze(AnalyzeContextInfo contextInfo) throws XPathException {
        contextInfo.setParent(this);
        this.inPredicate = (contextInfo.getFlags() & 2) > 0;
        for (int i = 0; i < this.getArgumentCount(); ++i) {
            this.getArgument(i).analyze(contextInfo);
        }
    }

    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        Sequence result;
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().start(this);
            this.context.getProfiler().message((Expression)this, Profiler.DEPENDENCIES, "DEPENDENCIES", Dependency.getDependenciesName(this.getDependencies()));
            if (contextSequence != null) {
                this.context.getProfiler().message((Expression)this, Profiler.START_SEQUENCES, "CONTEXT SEQUENCE", contextSequence);
            }
            if (contextItem != null) {
                this.context.getProfiler().message((Expression)this, Profiler.START_SEQUENCES, "CONTEXT ITEM", contextItem.toSequence());
            }
        }
        if (this.preselectResult != null && this.preselectResult.isEmpty()) {
            return Sequence.EMPTY_SEQUENCE;
        }
        if (contextItem != null) {
            contextSequence = contextItem.toSequence();
        }
        if (this.contextStep == null || this.preselectResult == null) {
            Sequence input = this.getArgument(0).eval(contextSequence, contextItem);
            if (input.isEmpty()) {
                result = Sequence.EMPTY_SEQUENCE;
            } else if (this.inPredicate && !Dependency.dependsOn(this, 2)) {
                if (this.context.isProfilingEnabled()) {
                    this.context.getProfiler().message((Expression)this, Profiler.OPTIMIZATION_FLAGS, "", "Index evaluation");
                }
                result = this.evalWithIndex(contextSequence, contextItem, input);
            } else {
                if (this.context.isProfilingEnabled()) {
                    this.context.getProfiler().message((Expression)this, Profiler.OPTIMIZATION_FLAGS, "", "Generic evaluation");
                }
                result = this.evalGeneric(contextSequence, contextItem, input);
            }
        } else {
            this.contextStep.setPreloadNodeSets(true);
            this.contextStep.setPreloadedData(contextSequence.getDocumentSet(), this.preselectResult);
            result = this.getArgument(0).eval(contextSequence).toNodeSet();
        }
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().end(this, "", result);
        }
        return result;
    }

    private Sequence evalWithIndex(Sequence contextSequence, Item contextItem, Sequence input) throws XPathException {
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().start(this);
            this.context.getProfiler().message((Expression)this, Profiler.DEPENDENCIES, "DEPENDENCIES", Dependency.getDependenciesName(this.getDependencies()));
            if (contextSequence != null) {
                this.context.getProfiler().message((Expression)this, Profiler.START_SEQUENCES, "CONTEXT SEQUENCE", contextSequence);
            }
            if (contextItem != null) {
                this.context.getProfiler().message((Expression)this, Profiler.START_SEQUENCES, "CONTEXT ITEM", contextItem.toSequence());
            }
        }
        boolean caseSensitive = true;
        int flags = 0;
        if (this.getSignature().getArgumentCount() == 3) {
            String flagsArg = this.getArgument(2).eval(contextSequence, contextItem).getStringValue();
            caseSensitive = flagsArg.indexOf(105) == -1;
            flags = FunMatches.parseFlags(flagsArg);
        }
        Sequence result = null;
        String pattern = this.translateRegexp(this.getArgument(1).eval(contextSequence, contextItem).getStringValue());
        NodeSet nodes = input.toNodeSet();
        int indexType = nodes.getIndexType();
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("found an index of type: " + Type.getTypeName(indexType)));
        }
        if (Type.subTypeOf(indexType, 22)) {
            boolean indexScan = false;
            if (contextSequence != null) {
                GeneralComparison.IndexFlags iflags = GeneralComparison.checkForQNameIndex(this.idxflags, this.context, contextSequence, this.contextQName);
                boolean indexFound = false;
                if (!iflags.indexOnQName()) {
                    indexFound = this.contextQName != null;
                    this.contextQName = null;
                }
                if (!indexFound && this.contextQName == null && iflags.hasIndexOnQNames()) {
                    indexScan = true;
                }
            } else {
                result = this.evalFallback(nodes, pattern, flags, indexType);
            }
            if (result == null) {
                DocumentSet docs = nodes.getDocumentSet();
                try {
                    NativeValueIndex index = this.context.getBroker().getValueIndex();
                    this.hasUsedIndex = true;
                    if (this.context.isProfilingEnabled()) {
                        this.context.getProfiler().message((Expression)this, Profiler.OPTIMIZATIONS, "Using vlaue index '" + index.toString() + "'", "Regex: " + pattern);
                    }
                    if (LOG.isTraceEnabled()) {
                        LOG.trace((Object)("Using range index for fn:matches expression: " + pattern));
                    }
                    if (indexScan) {
                        result = index.matchAll(docs, nodes, 0, pattern, 1, flags, caseSensitive);
                    }
                    result = index.match(docs, nodes, 0, pattern, this.contextQName, 1, flags, caseSensitive);
                }
                catch (EXistException e) {
                    throw new XPathException(this.getASTNode(), e.getMessage(), e);
                }
            }
        } else {
            result = this.evalFallback(nodes, pattern, flags, indexType);
        }
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().end(this, "", result);
        }
        return result;
    }

    private Sequence evalFallback(NodeSet nodes, String pattern, int flags, int indexType) throws XPathException {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("fn:matches: can't use existing range index of type " + Type.getTypeName(indexType) + ". Need a string index."));
        }
        ExtArrayNodeSet result = new ExtArrayNodeSet();
        NodeSetIterator i = nodes.iterator();
        while (i.hasNext()) {
            NodeProxy node = (NodeProxy)i.next();
            if (!this.match(node.getStringValue(), pattern, flags)) continue;
            result.add((Item)node);
        }
        return result;
    }

    protected String translateRegexp(String pattern) throws XPathException {
        try {
            pattern = RegexTranslator.translate(pattern, true);
        }
        catch (RegexTranslator.RegexSyntaxException e) {
            throw new XPathException(this.getASTNode(), "Conversion from XPath2 to Java regular expression syntax failed: " + e.getMessage(), e);
        }
        return pattern;
    }

    private Sequence evalGeneric(Sequence contextSequence, Item contextItem, Sequence stringArg) throws XPathException {
        String string = stringArg.getStringValue();
        String pattern = this.translateRegexp(this.getArgument(1).eval(contextSequence, contextItem).getStringValue());
        int flags = 0;
        if (this.getSignature().getArgumentCount() == 3) {
            flags = FunMatches.parseFlags(this.getArgument(2).eval(contextSequence, contextItem).getStringValue());
        }
        return BooleanValue.valueOf(this.match(string, pattern, flags));
    }

    private boolean match(String string, String pattern, int flags) throws XPathException {
        try {
            if (this.pat == null || !pattern.equals(this.pat.pattern()) || flags != this.pat.flags()) {
                this.pat = Pattern.compile(pattern, flags);
                this.matcher = this.pat.matcher(string);
            } else {
                this.matcher.reset(string);
            }
            return this.matcher.find();
        }
        catch (PatternSyntaxException e) {
            throw new XPathException(this.getASTNode(), "Invalid regular expression: " + e.getMessage(), e);
        }
    }

    protected static final int parseFlags(String s) throws XPathException {
        int flags = 0;
        block6: for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            switch (ch) {
                case 'm': {
                    flags |= 8;
                    continue block6;
                }
                case 'i': {
                    flags = flags | 2 | 0x40;
                    continue block6;
                }
                case 'x': {
                    flags |= 4;
                    continue block6;
                }
                case 's': {
                    flags |= 0x20;
                    continue block6;
                }
                default: {
                    throw new XPathException("Invalid regular expression flag: " + ch);
                }
            }
        }
        return flags;
    }

    public void reset() {
        super.reset();
        this.hasUsedIndex = false;
    }

    public void resetState(boolean postOptimization) {
        super.resetState(postOptimization);
        if (!postOptimization) {
            this.preselectResult = null;
        }
    }
}

