/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions;

import java.util.StringTokenizer;
import org.exist.dom.QName;
import org.exist.xquery.Dependency;
import org.exist.xquery.Expression;
import org.exist.xquery.Function;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.Profiler;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.StringValue;

public class FunNormalizeSpace
extends Function {
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new QName("normalize-space", "http://www.w3.org/2005/xpath-functions"), "Returns the value of the context item with whitespace normalized by stripping leading and trailing whitespace and replacing sequences of one or more whitespace character with a single space.", new SequenceType[0], new SequenceType(22, 2)), new FunctionSignature(new QName("normalize-space", "http://www.w3.org/2005/xpath-functions"), "Returns the value of $a with whitespace normalized by stripping leading and trailing whitespace and replacing sequences of one or more whitespace character with a single space.If the value of $a is the empty sequence, returns the zero-length string. If no argument is supplied  $a defaults to the string value of the context item.", new SequenceType[]{new SequenceType(22, 3)}, new SequenceType(22, 2))};

    public FunNormalizeSpace(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    public int returnsType() {
        return 22;
    }

    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        StringValue result;
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().start(this);
            this.context.getProfiler().message((Expression)this, Profiler.DEPENDENCIES, "DEPENDENCIES", Dependency.getDependenciesName(this.getDependencies()));
            if (contextSequence != null) {
                this.context.getProfiler().message((Expression)this, Profiler.START_SEQUENCES, "CONTEXT SEQUENCE", contextSequence);
            }
            if (contextItem != null) {
                this.context.getProfiler().message((Expression)this, Profiler.START_SEQUENCES, "CONTEXT ITEM", contextItem.toSequence());
            }
        }
        if (contextItem != null) {
            contextSequence = contextItem.toSequence();
        }
        String value = null;
        if (this.getSignature().getArgumentCount() == 0) {
            if (contextSequence == null) {
                throw new XPathException(this.getASTNode(), "err:XPDY0002: Undefined context item");
            }
            value = !contextSequence.isEmpty() ? contextSequence.itemAt(0).getStringValue() : "";
        } else {
            Sequence seq = this.getArgument(0).eval(contextSequence);
            if (seq == null) {
                throw new XPathException(this.getASTNode(), "err:XPDY0002: Undefined context item");
            }
            if (!seq.isEmpty()) {
                value = seq.getStringValue();
            }
        }
        if (value == null) {
            result = StringValue.EMPTY_STRING;
        } else {
            StringBuffer buf = new StringBuffer();
            if (value.length() > 0) {
                StringTokenizer tok = new StringTokenizer(value);
                while (tok.hasMoreTokens()) {
                    buf.append(tok.nextToken());
                    if (!tok.hasMoreTokens()) continue;
                    buf.append(' ');
                }
            }
            result = new StringValue(buf.toString());
        }
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().end(this, "", result);
        }
        return result;
    }
}

