/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions;

import org.exist.dom.QName;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.Dependency;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.Profiler;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.StringValue;

public class FunStringJoin
extends BasicFunction {
    public static final FunctionSignature signature = new FunctionSignature(new QName("string-join", "http://www.w3.org/2005/xpath-functions"), "Returns a xs:string created by concatenating the members of the $a sequence using $b as a separator. If the value of $b is the zero-length string, then the members of $a are concatenated without a separator.", new SequenceType[]{new SequenceType(22, 7), new SequenceType(22, 2)}, new SequenceType(22, 2));

    public FunStringJoin(XQueryContext context) {
        super(context, signature);
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        String sep;
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().start(this);
            this.context.getProfiler().message((Expression)this, Profiler.DEPENDENCIES, "DEPENDENCIES", Dependency.getDependenciesName(this.getDependencies()));
            if (contextSequence != null) {
                this.context.getProfiler().message((Expression)this, Profiler.START_SEQUENCES, "CONTEXT SEQUENCE", contextSequence);
            }
        }
        if ((sep = args[1].getStringValue()).length() == 0) {
            sep = null;
        }
        StringBuffer out = new StringBuffer();
        boolean gotOne = false;
        SequenceIterator i = args[0].iterate();
        while (i.hasNext()) {
            Item next = i.nextItem();
            if (gotOne && sep != null) {
                out.append(sep);
            }
            out.append(next.getStringValue());
            gotOne = true;
        }
        StringValue result = new StringValue(out.toString());
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().end(this, "", result);
        }
        return result;
    }
}

