/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.session;

import java.util.Enumeration;
import org.exist.dom.QName;
import org.exist.http.servlets.SessionWrapper;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.Variable;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.functions.session.SessionModule;
import org.exist.xquery.value.JavaObjectValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.StringValue;
import org.exist.xquery.value.ValueSequence;

public class GetAttributeNames
extends BasicFunction {
    public static final FunctionSignature signature = new FunctionSignature(new QName("get-attribute-names", "http://exist-db.org/xquery/session", "session"), "Returns a sequence containing the names of all session attributes defined within the current HTTP session.", null, new SequenceType(22, 7));
    public static final FunctionSignature deprecated = new FunctionSignature(new QName("session-attributes", "http://exist-db.org/xquery/request", "request"), "Returns a sequence containing the names of all session attributes defined within the current HTTP session.", null, new SequenceType(22, 7), "Moved to session module and renamed to session:get-attribute-names.");

    public GetAttributeNames(XQueryContext context) {
        super(context, signature);
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        SessionModule myModule = (SessionModule)this.context.getModule("http://exist-db.org/xquery/session");
        Variable var = myModule.resolveVariable(SessionModule.SESSION_VAR);
        if (var == null || var.getValue() == null) {
            throw new XPathException(this.getASTNode(), "Session not set");
        }
        if (var.getValue().getItemType() != 100) {
            throw new XPathException(this.getASTNode(), "Variable $session is not bound to an Java object.");
        }
        JavaObjectValue session = (JavaObjectValue)var.getValue().itemAt(0);
        if (session.getObject() instanceof SessionWrapper) {
            ValueSequence result = new ValueSequence();
            SessionWrapper sessionWrapper = (SessionWrapper)session.getObject();
            Enumeration e = sessionWrapper.getAttributeNames();
            while (e.hasMoreElements()) {
                String attribName = (String)e.nextElement();
                result.add(new StringValue(attribName));
            }
            return result;
        }
        throw new XPathException(this.getASTNode(), "Type error: variable $session is not bound to a session object");
    }
}

