/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.session;

import org.exist.dom.QName;
import org.exist.http.servlets.RequestWrapper;
import org.exist.http.servlets.SessionWrapper;
import org.exist.security.SecurityManager;
import org.exist.security.User;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.Variable;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.functions.request.RequestModule;
import org.exist.xquery.value.BooleanValue;
import org.exist.xquery.value.JavaObjectValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.StringValue;

public class SetCurrentUser
extends BasicFunction {
    public static final FunctionSignature signature = new FunctionSignature(new QName("set-current-user", "http://exist-db.org/xquery/session", "session"), "Change the user identity for the current HTTP session. Subsequent XQueries in the session will run with the new user identity.", new SequenceType[]{new SequenceType(22, 2), new SequenceType(22, 2)}, new SequenceType(23, 3));
    public static final FunctionSignature deprecated = new FunctionSignature(new QName("set-current-user", "http://exist-db.org/xquery/request", "request"), "Change the user identity for the current HTTP session. Subsequent XQueries in the session will run with the new user identity.", new SequenceType[]{new SequenceType(22, 2), new SequenceType(22, 2)}, new SequenceType(23, 3), "Moved to session module. See session:set-current-user.");

    public SetCurrentUser(XQueryContext context) {
        super(context, signature);
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        RequestModule myModule = (RequestModule)this.context.getModule("http://exist-db.org/xquery/request");
        Variable var = myModule.resolveVariable(RequestModule.REQUEST_VAR);
        if (var == null || var.getValue() == null) {
            throw new XPathException(this.getASTNode(), "No request object found in the current XQuery context.");
        }
        if (var.getValue().getItemType() != 100) {
            throw new XPathException(this.getASTNode(), "Variable $request is not bound to an Java object.");
        }
        JavaObjectValue value = (JavaObjectValue)var.getValue().itemAt(0);
        if (value.getObject() instanceof RequestWrapper) {
            RequestWrapper request = (RequestWrapper)value.getObject();
            String userName = args[0].getStringValue();
            String passwd = args[1].getStringValue();
            SecurityManager security = this.context.getBroker().getBrokerPool().getSecurityManager();
            User user = security.getUser(userName);
            if (user == null) {
                return Sequence.EMPTY_SEQUENCE;
            }
            if (user.validate(passwd)) {
                this.context.getBroker().setUser(user);
                SessionWrapper session = request.getSession(true);
                session.setAttribute("user", (Object)userName);
                session.setAttribute("password", (Object)new StringValue(passwd));
                return BooleanValue.TRUE;
            }
            LOG.warn((Object)("Could not validate user " + userName));
            return BooleanValue.FALSE;
        }
        throw new XPathException(this.getASTNode(), "Variable $request is not bound to a Request object.");
    }
}

