/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.system;

import org.exist.dom.QName;
import org.exist.memtree.MemTreeBuilder;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.XQueryWatchDog;
import org.exist.xquery.value.NodeValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;

public class GetRunningXQueries
extends BasicFunction {
    static final String NAMESPACE_URI = "http://exist-db.org/xquery/system";
    static final String PREFIX = "system";
    public static final FunctionSignature signature = new FunctionSignature(new QName("get-running-xqueries", "http://exist-db.org/xquery/system", "system"), "Get a list of running XQueries (dba role only).", null, new SequenceType(11, 2));

    public GetRunningXQueries(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        if (!this.context.getUser().hasDbaRole()) {
            throw new XPathException(this.getASTNode(), "Permission denied, calling user '" + this.context.getUser().getName() + "' must be a DBA to get the list of running xqueries");
        }
        return this.getRunningXQueries();
    }

    private Sequence getRunningXQueries() {
        NodeValue xmlResponse = null;
        MemTreeBuilder builder = this.context.getDocumentBuilder();
        builder.startDocument();
        builder.startElement(new QName("xqueries", NAMESPACE_URI, PREFIX), null);
        XQueryWatchDog[] watchdogs = this.getContext().getBroker().getBrokerPool().getProcessMonitor().getRunningXQueries();
        for (int i = 0; i < watchdogs.length; ++i) {
            XQueryContext context = watchdogs[i].getContext();
            this.getRunningXQuery(builder, context, watchdogs[i]);
        }
        builder.endElement();
        xmlResponse = (NodeValue)((Object)builder.getDocument().getDocumentElement());
        return xmlResponse;
    }

    private void getRunningXQuery(MemTreeBuilder builder, XQueryContext context, XQueryWatchDog watchdog) {
        builder.startElement(new QName("xquery", NAMESPACE_URI, PREFIX), null);
        builder.addAttribute(new QName("id", null, null), "" + context.hashCode());
        builder.addAttribute(new QName("sourceType", null, null), context.getSourceType());
        builder.addAttribute(new QName("terminating", null, null), watchdog.isTerminating() ? "true" : "false");
        builder.startElement(new QName("sourceKey", NAMESPACE_URI, PREFIX), null);
        builder.characters(context.getSourceKey());
        builder.endElement();
        builder.startElement(new QName("xqueryExpression", NAMESPACE_URI, PREFIX), null);
        builder.characters(context.getRootExpression().toString());
        builder.endElement();
        builder.endElement();
    }
}

