/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.transform;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TemplatesHandler;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.exist.collections.Collection;
import org.exist.dom.DocumentImpl;
import org.exist.dom.NodeProxy;
import org.exist.dom.QName;
import org.exist.http.servlets.ResponseWrapper;
import org.exist.memtree.DocumentBuilderReceiver;
import org.exist.memtree.MemTreeBuilder;
import org.exist.numbering.NodeId;
import org.exist.security.PermissionDeniedException;
import org.exist.storage.serializers.Serializer;
import org.exist.xmldb.XmldbURI;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.Option;
import org.exist.xquery.Variable;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.functions.response.ResponseModule;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.JavaObjectValue;
import org.exist.xquery.value.NodeValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.Type;
import org.exist.xquery.value.ValueSequence;
import org.exist.xslt.TransformerFactoryAllocator;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class Transform
extends BasicFunction {
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new QName("transform", "http://exist-db.org/xquery/transform", "transform"), "Applies an XSL stylesheet to the node tree passed as first argument. The stylesheet is specified in the second argument. This should either be an URI or a node. If it is an URI, it can either point to an external location or to an XSL stored in the db by using the 'xmldb:' scheme. Stylesheets are cached unless they were just created from an XML fragment and not from a complete document. Stylesheet parameters may be passed in the third argument using an XML fragment with the following structure: <parameters><param name=\"param-name1\" value=\"param-value1\"/></parameters>", new SequenceType[]{new SequenceType(-1, 3), new SequenceType(11, 2), new SequenceType(-1, 3)}, new SequenceType(-1, 3)), new FunctionSignature(new QName("transform", "http://exist-db.org/xquery/transform", "transform"), "Applies an XSL stylesheet to the node tree passed as first argument. The stylesheet is specified in the second argument. This should either be an URI or a node. If it is an URI, it can either point to an external location or to an XSL stored in the db by using the 'xmldb:' scheme. Stylesheets are cached unless they were just created from an XML fragment and not from a complete document. Stylesheet parameters may be passed in the third argument using an XML fragment with the following structure: <parameters><param name=\"param-name1\" value=\"param-value1\"/></parameters>", new SequenceType[]{new SequenceType(-1, 3), new SequenceType(11, 2), new SequenceType(-1, 3), new SequenceType(22, 2)}, new SequenceType(-1, 3)), new FunctionSignature(new QName("stream-transform", "http://exist-db.org/xquery/transform", "transform"), "Applies an XSL stylesheet to the node tree passed as first argument. The parameters are the same as for the transform function. stream-transform can only be used within a servlet context. Instead of returning the transformed document fragment, it directly streams its output to the servlet's output stream. It should thus be the last statement in the XQuery.", new SequenceType[]{new SequenceType(-1, 3), new SequenceType(11, 2), new SequenceType(-1, 3)}, new SequenceType(11, 1)), new FunctionSignature(new QName("stream-transform", "http://exist-db.org/xquery/transform", "transform"), "Applies an XSL stylesheet to the node tree passed as first argument. The parameters are the same as for the transform function. stream-transform can only be used within a servlet context. Instead of returning the transformed document fragment, it directly streams its output to the servlet's output stream. It should thus be the last statement in the XQuery.", new SequenceType[]{new SequenceType(-1, 3), new SequenceType(11, 2), new SequenceType(-1, 3), new SequenceType(22, 2)}, new SequenceType(11, 1))};
    private final Map cache = new HashMap();

    public Transform(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        if (args[0].isEmpty()) {
            return Sequence.EMPTY_SEQUENCE;
        }
        Item inputNode = args[0].itemAt(0);
        Item stylesheetItem = args[1].itemAt(0);
        Node options = null;
        if (!args[2].isEmpty()) {
            options = ((NodeValue)args[2].itemAt(0)).getNode();
        }
        Properties serializeOptions = new Properties();
        if (this.getArgumentCount() == 4) {
            String serOpts = args[3].getStringValue();
            String[] contents = Option.tokenize(serOpts);
            for (int i = 0; i < contents.length; ++i) {
                String[] pair = Option.parseKeyValuePair(contents[i]);
                if (pair == null) {
                    throw new XPathException(this.getASTNode(), "Found invalid serialization option: " + pair);
                }
                LOG.debug((Object)("Setting serialization property: " + pair[0] + " = " + pair[1]));
                serializeOptions.setProperty(pair[0], pair[1]);
            }
        } else {
            this.context.checkOptions(serializeOptions);
        }
        TransformerHandler handler = this.createHandler(stylesheetItem, options);
        if (this.isCalledAs("transform")) {
            ValueSequence seq = new ValueSequence();
            this.context.pushDocumentContext();
            MemTreeBuilder builder = this.context.getDocumentBuilder();
            DocumentBuilderReceiver receiver = new DocumentBuilderReceiver(builder);
            SAXResult result = new SAXResult(receiver);
            result.setLexicalHandler(receiver);
            handler.setResult(result);
            try {
                handler.startDocument();
                inputNode.toSAX(this.context.getBroker(), handler, serializeOptions);
                handler.endDocument();
            }
            catch (SAXException e) {
                throw new XPathException(this.getASTNode(), "SAX exception while transforming node: " + e.getMessage(), e);
            }
            for (Node next = builder.getDocument().getFirstChild(); next != null; next = next.getNextSibling()) {
                seq.add((NodeValue)((Object)next));
            }
            this.context.popDocumentContext();
            return seq;
        }
        ResponseModule myModule = (ResponseModule)this.context.getModule("http://exist-db.org/xquery/response");
        Variable respVar = myModule.resolveVariable(ResponseModule.RESPONSE_VAR);
        if (respVar == null) {
            throw new XPathException(this.getASTNode(), "No response object found in the current XQuery context.");
        }
        if (respVar.getValue().getItemType() != 100) {
            throw new XPathException(this.getASTNode(), "Variable $response is not bound to an Java object.");
        }
        JavaObjectValue respValue = (JavaObjectValue)respVar.getValue().itemAt(0);
        if (!"org.exist.http.servlets.HttpResponseWrapper".equals(respValue.getObject().getClass().getName())) {
            throw new XPathException(this.getASTNode(), signatures[1].toString() + " can only be used within the EXistServlet or XQueryServlet");
        }
        ResponseWrapper response = (ResponseWrapper)respValue.getObject();
        try {
            BufferedOutputStream os = new BufferedOutputStream(response.getOutputStream());
            StreamResult result = new StreamResult(os);
            handler.setResult(result);
            handler.startDocument();
            inputNode.toSAX(this.context.getBroker(), handler, serializeOptions);
            handler.endDocument();
            ((OutputStream)os).close();
            response.flushBuffer();
        }
        catch (SAXException e) {
            throw new XPathException(this.getASTNode(), "SAX exception while transforming node: " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new XPathException(this.getASTNode(), "IO exception while transforming node: " + e.getMessage(), e);
        }
        return Sequence.EMPTY_SEQUENCE;
    }

    private TransformerHandler createHandler(Item stylesheetItem, Node options) throws TransformerFactoryConfigurationError, XPathException {
        TransformerHandler handler;
        SAXTransformerFactory factory = TransformerFactoryAllocator.getTransformerFactory(this.context.getBroker());
        try {
            Templates templates = null;
            if (Type.subTypeOf(stylesheetItem.getType(), -1)) {
                NodeProxy root;
                NodeValue stylesheetNode = (NodeValue)stylesheetItem;
                if (stylesheetNode.getImplementationType() == 1 && ((root = (NodeProxy)stylesheetNode).getNodeId() == NodeId.DOCUMENT_NODE || root.getNodeId().getTreeLevel() == 1)) {
                    factory.setURIResolver(new DatabaseResolver(root.getDocument()));
                    String uri = "xmldb:" + this.context.getBroker().getBrokerPool().getId() + "://" + root.getDocument().getURI();
                    templates = this.getSource(factory, uri);
                }
                if (templates == null) {
                    templates = this.getSource(factory, stylesheetNode);
                }
            } else {
                String stylesheet = stylesheetItem.getStringValue();
                templates = this.getSource(factory, stylesheet);
            }
            handler = factory.newTransformerHandler(templates);
            if (options != null) {
                this.parseParameters(options, handler.getTransformer());
            }
        }
        catch (TransformerConfigurationException e) {
            throw new XPathException(this.getASTNode(), "Unable to set up transformer: " + e.getMessage(), e);
        }
        return handler;
    }

    private void parseParameters(Node options, Transformer handler) throws XPathException {
        if (options.getNodeType() == 1 && options.getLocalName().equals("parameters")) {
            for (Node child = options.getFirstChild(); child != null; child = child.getNextSibling()) {
                if (child.getNodeType() != 1 || !child.getLocalName().equals("param")) continue;
                Element elem = (Element)child;
                String name = elem.getAttribute("name");
                String value = elem.getAttribute("value");
                if (name == null || value == null) {
                    throw new XPathException(this.getASTNode(), "Name or value attribute missing for stylesheet parameter");
                }
                handler.setParameter(name, value);
            }
        }
    }

    private Templates getSource(SAXTransformerFactory factory, String stylesheet) throws XPathException, TransformerConfigurationException {
        int p;
        if (stylesheet.indexOf(58) == -1) {
            File f = new File(stylesheet);
            if (f.canRead()) {
                stylesheet = f.toURI().toASCIIString();
            } else {
                stylesheet = this.context.getModuleLoadPath() + File.separatorChar + stylesheet;
                f = new File(stylesheet);
                if (f.canRead()) {
                    stylesheet = f.toURI().toASCIIString();
                }
            }
        }
        String base = (p = stylesheet.lastIndexOf("/")) != -1 ? stylesheet.substring(0, p) : stylesheet;
        CachedStylesheet cached = (CachedStylesheet)this.cache.get(stylesheet);
        try {
            if (cached == null) {
                cached = new CachedStylesheet(factory, stylesheet, base);
                this.cache.put(stylesheet, cached);
            }
            return cached.getTemplates();
        }
        catch (MalformedURLException e) {
            LOG.debug((Object)e.getMessage(), (Throwable)e);
            throw new XPathException(this.getASTNode(), "Malformed URL for stylesheet: " + stylesheet, e);
        }
        catch (IOException e) {
            throw new XPathException(this.getASTNode(), "IO error while loading stylesheet: " + stylesheet, e);
        }
    }

    private Templates getSource(SAXTransformerFactory factory, NodeValue stylesheetRoot) throws XPathException, TransformerConfigurationException {
        TemplatesHandler handler = factory.newTemplatesHandler();
        try {
            handler.startDocument();
            stylesheetRoot.toSAX(this.context.getBroker(), handler, null);
            handler.endDocument();
            return handler.getTemplates();
        }
        catch (SAXException e) {
            throw new XPathException(this.getASTNode(), "A SAX exception occurred while compiling the stylesheet: " + e.getMessage(), e);
        }
    }

    private class DatabaseResolver
    implements URIResolver {
        DocumentImpl doc;

        public DatabaseResolver(DocumentImpl myDoc) {
            this.doc = myDoc;
        }

        public Source resolve(String href, String base) throws TransformerException {
            DocumentImpl xslDoc;
            Collection collection = this.doc.getCollection();
            String path = href.startsWith("/") ? href : collection.getURI() + "/" + href;
            try {
                xslDoc = (DocumentImpl)Transform.this.context.getBroker().getXMLResource(XmldbURI.create(path));
            }
            catch (PermissionDeniedException e) {
                throw new TransformerException(e.getMessage(), e);
            }
            if (xslDoc == null) {
                LOG.debug((Object)("Document " + href + " not found in collection " + collection.getURI()));
                return null;
            }
            if (!xslDoc.getPermissions().validate(Transform.this.context.getUser(), 4)) {
                throw new TransformerException("Insufficient privileges to read resource " + path);
            }
            DOMSource source = new DOMSource(xslDoc);
            return source;
        }
    }

    private class ExternalResolver
    implements URIResolver {
        private String baseURI;

        public ExternalResolver(String base) {
            this.baseURI = base;
        }

        public Source resolve(String href, String base) throws TransformerException {
            try {
                URL url = new URL(this.baseURI + "/" + href);
                URLConnection connection = url.openConnection();
                return new StreamSource(connection.getInputStream());
            }
            catch (MalformedURLException e) {
                return null;
            }
            catch (IOException e) {
                return null;
            }
        }
    }

    private class CachedStylesheet {
        SAXTransformerFactory factory;
        long lastModified = -1L;
        Templates templates = null;
        String uri;

        public CachedStylesheet(SAXTransformerFactory factory, String uri, String baseURI) throws TransformerConfigurationException, IOException, XPathException {
            this.factory = factory;
            this.uri = uri;
            if (!baseURI.startsWith("xmldb:exist://")) {
                factory.setURIResolver(new ExternalResolver(baseURI));
            }
            this.getTemplates();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Templates getTemplates() throws TransformerConfigurationException, IOException, XPathException {
            if (this.uri.startsWith("xmldb:exist://")) {
                String docPath = this.uri.substring("xmldb:exist://".length());
                DocumentImpl doc = null;
                try {
                    doc = Transform.this.context.getBroker().getXMLResource(XmldbURI.create(docPath), 0);
                    if (doc != null && (this.templates == null || doc.getMetadata().getLastModified() > this.lastModified)) {
                        this.templates = this.getSource(doc);
                    }
                    this.lastModified = doc.getMetadata().getLastModified();
                }
                catch (PermissionDeniedException e) {
                    throw new XPathException(Transform.this.getASTNode(), "Permission denied to read stylesheet: " + this.uri);
                }
                finally {
                    doc.getUpdateLock().release(0);
                }
            }
            URL url = new URL(this.uri);
            URLConnection connection = url.openConnection();
            long modified = connection.getLastModified();
            if (this.templates == null || modified > this.lastModified || modified == 0L) {
                LOG.debug((Object)("compiling stylesheet " + url.toString()));
                InputStream is = connection.getInputStream();
                try {
                    this.templates = this.factory.newTemplates(new StreamSource(is));
                }
                finally {
                    is.close();
                }
            }
            this.lastModified = modified;
            return this.templates;
        }

        private Templates getSource(DocumentImpl stylesheet) throws XPathException, TransformerConfigurationException {
            this.factory.setURIResolver(new DatabaseResolver(stylesheet));
            TemplatesHandler handler = this.factory.newTemplatesHandler();
            try {
                handler.startDocument();
                Serializer serializer = Transform.this.context.getBroker().getSerializer();
                serializer.reset();
                serializer.setSAXHandlers(handler, null);
                serializer.toSAX(stylesheet);
                handler.endDocument();
                return handler.getTemplates();
            }
            catch (SAXException e) {
                throw new XPathException(Transform.this.getASTNode(), "A SAX exception occurred while compiling the stylesheet: " + e.getMessage(), e);
            }
        }
    }
}

