/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.exist.collections.Collection;
import org.exist.dom.DocumentSet;
import org.exist.dom.NodeSet;
import org.exist.dom.QName;
import org.exist.indexing.IndexWorker;
import org.exist.indexing.OrderedValuesIndex;
import org.exist.storage.DBBroker;
import org.exist.storage.IndexSpec;
import org.exist.storage.Indexable;
import org.exist.util.Occurrences;
import org.exist.util.ValueOccurrences;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.FunctionCall;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.FunctionReference;
import org.exist.xquery.value.IntegerValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.StringValue;
import org.exist.xquery.value.ValueSequence;

public class IndexKeys
extends BasicFunction {
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new QName("index-keys", "http://exist-db.org/xquery/util", "util"), "Can be used to query existing range indexes defined on a set of nodes. All index keys defined for the given node set are reported to a callback function. The function will check for indexes defined on path as well as indexes defined by QName. The node set is specified in the first argument. The second argument specifies a start value. Only index keys of the same type but being greater than $b will be reported for non-stringtypes. For string types, only keys starting with the given prefix are reported. The third arguments is a function reference as created by the util:function function. It can be an arbitrary user-defined function, but it should take exactly 2 arguments: 1) the current index key as found in the range index as an atomic value, 2) a sequence containing three int values: a) the overall frequency of the key within the node set, b) the number of distinct documents in the node set the key occurs in, c) the current position of the key in the whole list of keys returned. The fourth argument is the maximum number of returned keys", new SequenceType[]{new SequenceType(-1, 7), new SequenceType(20, 2), new SequenceType(101, 2), new SequenceType(38, 2)}, new SequenceType(11, 7)), new FunctionSignature(new QName("index-keys", "http://exist-db.org/xquery/util", "util"), "Can be used to query existing range indexes defined on a set of nodes. All index keys defined for the given node set are reported to a callback function. The function will check for indexes defined on path as well as indexes defined by QName. The node set is specified in the first argument. The second argument specifies a start value. Only index keys of the same type but being greater than $b will be reported for non-stringtypes. For string types, only keys starting with the given prefix are reported. The third arguments is a function reference as created by the util:function function. It can be an arbitrary user-defined function, but it should take exactly 2 arguments: 1) the current index key as found in the range index as an atomic value, 2) a sequence containing three int values: a) the overall frequency of the key within the node set, b) the number of distinct documents in the node set the key occurs in, c) the current position of the key in the whole list of keys returned. The fourth argument is the maximum number of returned keysThe fifth argument specifies the index in which the search is made", new SequenceType[]{new SequenceType(-1, 7), new SequenceType(20, 2), new SequenceType(101, 2), new SequenceType(38, 2), new SequenceType(22, 2)}, new SequenceType(11, 7))};

    public IndexKeys(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        if (args[0].isEmpty()) {
            return Sequence.EMPTY_SEQUENCE;
        }
        NodeSet nodes = args[0].toNodeSet();
        DocumentSet docs = nodes.getDocumentSet();
        FunctionReference ref = (FunctionReference)args[2].itemAt(0);
        int max = ((IntegerValue)args[3].itemAt(0)).getInt();
        FunctionCall call = ref.getFunctionCall();
        ValueSequence result = new ValueSequence();
        if (this.getArgumentCount() == 5) {
            IndexWorker indexWorker = this.context.getBroker().getIndexController().getWorkerByIndexName(args[4].itemAt(0).getStringValue());
            if (indexWorker == null) {
                throw new XPathException(this.getASTNode(), "Unknown index: " + args[4].itemAt(0).getStringValue());
            }
            HashMap<String, Sequence> hints = new HashMap<String, Sequence>();
            hints.put("value_count", new IntegerValue(max));
            if (indexWorker instanceof OrderedValuesIndex) {
                hints.put("start_value", args[1]);
            } else {
                LOG.info((Object)(indexWorker + " isn't an instance of org.exist.indexing.OrderedIndexWorker. " + args[1] + " ignored."));
            }
            Occurrences[] occur = indexWorker.scanIndex(this.context, docs, nodes, hints);
            int len = occur.length > max ? max : occur.length;
            Sequence[] params = new Sequence[2];
            ValueSequence data = new ValueSequence();
            for (int j = 0; j < len; ++j) {
                params[0] = new StringValue(occur[j].getTerm().toString());
                data.add(new IntegerValue(occur[j].getOccurrences(), 43));
                data.add(new IntegerValue(occur[j].getDocuments(), 43));
                data.add(new IntegerValue(j + 1, 43));
                params[1] = data;
                result.addAll(call.evalFunction(contextSequence, null, params));
                data.clear();
            }
        } else {
            int idxType = nodes.getIndexType();
            Indexable indexable = (Indexable)((Object)args[1].itemAt(0));
            ValueOccurrences[] occur = null;
            QName[] qnames = this.getDefinedIndexes(this.context.getBroker(), docs);
            if (qnames != null && qnames.length > 0) {
                occur = this.context.getBroker().getValueIndex().scanIndexKeys(docs, nodes, qnames, indexable);
            }
            ValueOccurrences[] occur2 = this.context.getBroker().getValueIndex().scanIndexKeys(docs, nodes, indexable);
            if (occur == null || occur.length == 0) {
                occur = occur2;
            } else {
                ValueOccurrences[] t = new ValueOccurrences[occur.length + occur2.length];
                System.arraycopy(occur, 0, t, 0, occur.length);
                System.arraycopy(occur2, 0, t, occur.length, occur2.length);
                occur = t;
            }
            int len = occur.length > max ? max : occur.length;
            Sequence[] params = new Sequence[2];
            ValueSequence data = new ValueSequence();
            for (int j = 0; j < len; ++j) {
                params[0] = occur[j].getValue();
                data.add(new IntegerValue(occur[j].getOccurrences(), 43));
                data.add(new IntegerValue(occur[j].getDocuments(), 43));
                data.add(new IntegerValue(j + 1, 43));
                params[1] = data;
                result.addAll(call.evalFunction(contextSequence, null, params));
                data.clear();
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Returning: " + result.getItemCount()));
        }
        return result;
    }

    private QName[] getDefinedIndexes(DBBroker broker, DocumentSet docs) {
        HashSet<QName> indexes = new HashSet<QName>();
        Iterator i = docs.getCollectionIterator();
        while (i.hasNext()) {
            Collection collection = (Collection)i.next();
            IndexSpec idxConf = collection.getIndexConfiguration(broker);
            if (idxConf == null) continue;
            List qnames = idxConf.getIndexedQNames();
            for (int j = 0; j < qnames.size(); ++j) {
                QName qName = (QName)qnames.get(j);
                indexes.add(qName);
            }
        }
        QName[] qnames = new QName[indexes.size()];
        return indexes.toArray(qnames);
    }
}

