/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.util;

import java.util.Iterator;
import org.exist.dom.QName;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.Module;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.StringValue;
import org.exist.xquery.value.ValueSequence;

public class ModuleInfo
extends BasicFunction {
    public static final FunctionSignature registeredModulesSig = new FunctionSignature(new QName("registered-modules", "http://exist-db.org/xquery/util", "util"), "Returns a sequence containing the namespace URIs of all modules currently known to the system, including built in and imported modules.", null, new SequenceType(22, 6));
    public static final FunctionSignature moduleDescriptionSig = new FunctionSignature(new QName("get-module-description", "http://exist-db.org/xquery/util", "util"), "Returns a short description of the module identified by the namespace URI.", new SequenceType[]{new SequenceType(22, 2)}, new SequenceType(22, 2));

    public ModuleInfo(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        if ("get-module-description".equals(this.getSignature().getName().getLocalName())) {
            String uri = args[0].getStringValue();
            Module module = this.context.getModule(uri);
            if (module == null) {
                throw new XPathException(this.getASTNode(), "No module found matching namespace URI: " + uri);
            }
            return new StringValue(module.getDescription());
        }
        ValueSequence resultSeq = new ValueSequence();
        Iterator i = this.context.getModules();
        while (i.hasNext()) {
            Module module = (Module)i.next();
            resultSeq.add(new StringValue(module.getNamespaceURI()));
        }
        return resultSeq;
    }
}

