/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.xmldb;

import org.exist.dom.QName;
import org.exist.xmldb.UserManagementService;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.functions.xmldb.XMLDBAbstractCollectionManipulator;
import org.exist.xquery.value.AnyURIValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.StringValue;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.Resource;
import org.xmldb.api.base.XMLDBException;

public class XMLDBHasLock
extends XMLDBAbstractCollectionManipulator {
    public static final FunctionSignature signature = new FunctionSignature(new QName("document-has-lock", "http://exist-db.org/xquery/xmldb", "xmldb"), "Returns the name of the user that holds a write lock on the resource specified in $b in the collection $a.  If no lock is in place, the empty sequence is returned. The collection can be passed as a simple collection path or an XMLDB URI.", new SequenceType[]{new SequenceType(22, 2), new SequenceType(22, 2)}, new SequenceType(22, 3));

    public XMLDBHasLock(XQueryContext context) {
        super(context, signature);
    }

    public Sequence evalWithCollection(Collection collection, Sequence[] args, Sequence contextSequence) throws XPathException {
        try {
            UserManagementService ums = (UserManagementService)collection.getService("UserManagementService", "1.0");
            Resource res = collection.getResource(new AnyURIValue(args[1].getStringValue()).toXmldbURI().toString());
            if (res != null) {
                String lockUser = ums.hasUserLock(res);
                return lockUser == null ? Sequence.EMPTY_SEQUENCE : new StringValue(lockUser);
            }
            throw new XPathException(this.getASTNode(), "Unable to locate resource " + args[1].getStringValue());
        }
        catch (XMLDBException e) {
            throw new XPathException(this.getASTNode(), "Failed to retrieve user lock", e);
        }
    }
}

