/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.xmldb;

import org.exist.dom.QName;
import org.exist.security.Permission;
import org.exist.xmldb.UserManagementService;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.functions.xmldb.XMLDBAbstractCollectionManipulator;
import org.exist.xquery.value.IntegerValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.Resource;
import org.xmldb.api.base.XMLDBException;

public class XMLDBPermissions
extends XMLDBAbstractCollectionManipulator {
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new QName("get-permissions", "http://exist-db.org/xquery/xmldb", "xmldb"), "Returns the permissions assigned to the collection $a. The collection can be specified as a simple collection path or an XMLDB URI.", new SequenceType[]{new SequenceType(22, 2)}, new SequenceType(38, 3)), new FunctionSignature(new QName("get-permissions", "http://exist-db.org/xquery/xmldb", "xmldb"), "Returns the permissions assigned to the resource specified in $b which is a child of the collection $a. The collection can be specified as a simple collection path or an XMLDB URI.", new SequenceType[]{new SequenceType(22, 2), new SequenceType(22, 2)}, new SequenceType(38, 3))};

    public XMLDBPermissions(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    public Sequence evalWithCollection(Collection collection, Sequence[] args, Sequence contextSequence) throws XPathException {
        try {
            Permission perm = this.getPermissions(collection, args);
            return new IntegerValue(perm.getPermissions(), 38);
        }
        catch (XMLDBException xe) {
            throw new XPathException(this.getASTNode(), "Unable to retrieve resource permissions", xe);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Permission getPermissions(Collection collection, Sequence[] args) throws XMLDBException, XPathException {
        UserManagementService ums = (UserManagementService)collection.getService("UserManagementService", "1.0");
        if (this.getSignature().getArgumentCount() != 2) return ums.getPermissions(collection);
        Resource res = collection.getResource(args[1].getStringValue());
        if (res == null) throw new XPathException(this.getASTNode(), "Unable to locate resource " + args[1].getStringValue());
        return ums.getPermissions(res);
    }
}

