/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.util;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import javax.xml.parsers.SAXParserFactory;
import org.exist.dom.NodeProxy;
import org.exist.memtree.DocumentImpl;
import org.exist.memtree.SAXAdapter;
import org.exist.security.PermissionDeniedException;
import org.exist.xmldb.XmldbURI;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.Sequence;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class DocUtils {
    public static Sequence getDocument(XQueryContext context, String path) throws XPathException, PermissionDeniedException {
        return DocUtils.getDocumentByPath(context, path);
    }

    public static boolean isDocumentAvailable(XQueryContext context, String path) throws XPathException {
        try {
            Sequence seq = DocUtils.getDocumentByPath(context, path);
            return seq != null && seq.effectiveBooleanValue();
        }
        catch (PermissionDeniedException e) {
            return false;
        }
    }

    private static Sequence getDocumentByPath(XQueryContext context, String path) throws XPathException, PermissionDeniedException {
        Sequence document = Sequence.EMPTY_SEQUENCE;
        if (path.matches("^[a-z]+://.*")) {
            Object con;
            XMLReader reader = null;
            try {
                URL url = new URL(path);
                con = url.openConnection();
                if (con instanceof HttpURLConnection) {
                    HttpURLConnection httpConnection = (HttpURLConnection)con;
                    if (httpConnection.getResponseCode() == 404) {
                        Sequence sequence = Sequence.EMPTY_SEQUENCE;
                        return sequence;
                    }
                    if (httpConnection.getResponseCode() != 200) {
                        throw new PermissionDeniedException("Server returned code " + httpConnection.getResponseCode());
                    }
                }
                DocumentImpl memtreeDoc = null;
                SAXParserFactory factory = SAXParserFactory.newInstance();
                factory.setNamespaceAware(true);
                InputSource src = new InputSource(((URLConnection)con).getInputStream());
                SAXAdapter adapter = new SAXAdapter();
                reader = context.getBroker().getBrokerPool().getParserPool().borrowXMLReader();
                reader.setContentHandler(adapter);
                reader.parse(src);
                Document doc = adapter.getDocument();
                memtreeDoc = (DocumentImpl)doc;
                memtreeDoc.setContext(context);
                memtreeDoc.setDocumentURI(path);
                document = memtreeDoc;
                context.getBroker().getBrokerPool().getParserPool().returnXMLReader(reader);
            }
            catch (MalformedURLException e) {
                throw new XPathException(e.getMessage(), (Throwable)e);
            }
            catch (SAXException e) {
                throw new XPathException(e.getMessage(), (Throwable)e);
            }
            catch (IOException e) {
                if (e instanceof FileNotFoundException) {
                    con = Sequence.EMPTY_SEQUENCE;
                    return con;
                }
                throw new XPathException(e.getMessage(), (Throwable)e);
            }
            finally {
                context.getBroker().getBrokerPool().getParserPool().returnXMLReader(reader);
            }
        }
        boolean lockOnLoad = context.lockDocumentsOnLoad();
        int lockType = lockOnLoad ? 1 : 0;
        org.exist.dom.DocumentImpl doc = null;
        try {
            XmldbURI pathUri = XmldbURI.xmldbUriFor(path, false);
            pathUri = context.getBaseURI().toXmldbURI().resolveCollectionPath(pathUri);
            doc = context.getBroker().getXMLResource(pathUri, lockType);
            if (doc != null) {
                if (!doc.getPermissions().validate(context.getUser(), 4)) {
                    doc.getUpdateLock().release(lockType);
                    throw new PermissionDeniedException("Insufficient privileges to read resource " + path);
                }
                if (doc.getResourceType() == 1) {
                    throw new XPathException("Document is a binary resource, not an XML document. Please consider using the function util:binary-resource to retrieve a reference to it.");
                }
                if (lockOnLoad) {
                    context.addLockedDocument(doc);
                }
                document = new NodeProxy(doc);
            }
        }
        catch (PermissionDeniedException e) {
            throw e;
        }
        catch (URISyntaxException e) {
            throw new XPathException(e);
        }
        finally {
            if (!lockOnLoad && doc != null) {
                doc.getUpdateLock().release(lockType);
            }
        }
        return document;
    }
}

