/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xslt;

import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXTransformerFactory;
import org.apache.log4j.Logger;
import org.exist.storage.DBBroker;

public class TransformerFactoryAllocator {
    private static final Logger LOG = Logger.getLogger((Class)TransformerFactoryAllocator.class);
    public static final String CONFIGURATION_ELEMENT_NAME = "transformer";
    public static final String TRANSFORMER_CLASS_ATTRIBUTE = "class";
    public static final String PROPERTY_TRANSFORMER_CLASS = "transformer.class";

    private TransformerFactoryAllocator() {
    }

    public static SAXTransformerFactory getTransformerFactory(DBBroker broker) {
        SAXTransformerFactory factory;
        String transformerFactoryClassName = (String)broker.getConfiguration().getProperty(PROPERTY_TRANSFORMER_CLASS);
        if (transformerFactoryClassName == null) {
            factory = (SAXTransformerFactory)TransformerFactory.newInstance();
        } else {
            try {
                factory = (SAXTransformerFactory)Class.forName(transformerFactoryClassName).newInstance();
            }
            catch (ClassNotFoundException cnfe) {
                LOG.debug((Object)("Cannot find the requested TrAX factory '" + transformerFactoryClassName + "'. Using default TrAX Transformer Factory instead."));
                factory = (SAXTransformerFactory)TransformerFactory.newInstance();
            }
            catch (ClassCastException cce) {
                LOG.debug((Object)("The indicated class '" + transformerFactoryClassName + "' is not a TrAX Transformer Factory. " + "Using default TrAX Transformer Factory instead."));
                factory = (SAXTransformerFactory)TransformerFactory.newInstance();
            }
            catch (Exception e) {
                LOG.debug((Object)("Error found loading the requested TrAX Transformer Factory '" + transformerFactoryClassName + "'. Using default TrAX Transformer Factory instead."));
                factory = (SAXTransformerFactory)TransformerFactory.newInstance();
            }
        }
        return factory;
    }
}

