/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.barbecue;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.type.RotationEnum;
import net.sf.jasperreports.renderers.AbstractRenderer;
import net.sf.jasperreports.renderers.DimensionRenderable;
import net.sf.jasperreports.renderers.Graphics2DRenderable;
import net.sourceforge.barbecue.Barcode;
import net.sourceforge.barbecue.output.OutputException;

public class BarbecueRendererImpl
extends AbstractRenderer
implements Graphics2DRenderable,
DimensionRenderable {
    private static final long serialVersionUID = 10200L;
    private Barcode barcode;
    private RotationEnum rotation;

    public BarbecueRendererImpl(Barcode barcode) {
        this.barcode = barcode;
    }

    public Dimension2D getDimension(JasperReportsContext jasperReportsContext) {
        if (this.rotation != null) {
            switch (this.rotation) {
                case LEFT: 
                case RIGHT: {
                    return new Dimension((int)this.barcode.getSize().getHeight(), (int)this.barcode.getSize().getWidth());
                }
            }
            return this.barcode.getSize();
        }
        return this.barcode.getSize();
    }

    public void render(JasperReportsContext jasperReportsContext, Graphics2D grx, Rectangle2D rectangle) {
        AffineTransform origTransform = grx.getTransform();
        try {
            Dimension size = this.barcode.getSize();
            if (this.rotation != null) {
                switch (this.rotation) {
                    case LEFT: {
                        grx.translate(rectangle.getX(), rectangle.getY() + rectangle.getHeight());
                        grx.rotate(-1.5707963267948966);
                        if (rectangle.getWidth() == size.getHeight() && rectangle.getHeight() == size.getWidth()) break;
                        grx.scale(rectangle.getHeight() / size.getWidth(), rectangle.getWidth() / size.getHeight());
                        break;
                    }
                    case RIGHT: {
                        grx.translate(rectangle.getX() + rectangle.getWidth(), rectangle.getY());
                        grx.rotate(1.5707963267948966);
                        if (rectangle.getWidth() == size.getHeight() && rectangle.getHeight() == size.getWidth()) break;
                        grx.scale(rectangle.getHeight() / size.getWidth(), rectangle.getWidth() / size.getHeight());
                        break;
                    }
                    case UPSIDE_DOWN: {
                        grx.translate(rectangle.getX() + rectangle.getWidth(), rectangle.getY() + rectangle.getHeight());
                        grx.rotate(Math.PI);
                        if (rectangle.getWidth() == size.getWidth() && rectangle.getHeight() == size.getHeight()) break;
                        grx.scale(rectangle.getWidth() / size.getWidth(), rectangle.getHeight() / size.getHeight());
                        break;
                    }
                    case NONE: {
                        grx.translate(rectangle.getX(), rectangle.getY());
                        if (rectangle.getWidth() == size.getWidth() && rectangle.getHeight() == size.getHeight()) break;
                        grx.scale(rectangle.getWidth() / size.getWidth(), rectangle.getHeight() / size.getHeight());
                    }
                }
            } else {
                grx.translate(rectangle.getX(), rectangle.getY());
                if (rectangle.getWidth() != size.getWidth() || rectangle.getHeight() != size.getHeight()) {
                    grx.scale(rectangle.getWidth() / size.getWidth(), rectangle.getHeight() / size.getHeight());
                }
            }
            this.barcode.draw(grx, 0, 0);
        }
        catch (OutputException e) {
            throw new JRRuntimeException((Throwable)e);
        }
        finally {
            grx.setTransform(origTransform);
        }
    }

    public void setRotation(RotationEnum rotation) {
        this.rotation = rotation;
    }
}

