/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.data.json;

import java.io.InputStream;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import net.sf.jasperreports.data.json.JsonDataAdapter;
import net.sf.jasperreports.dataadapters.AbstractDataAdapterService;
import net.sf.jasperreports.dataadapters.DataAdapter;
import net.sf.jasperreports.dataadapters.DataFileStream;
import net.sf.jasperreports.dataadapters.DataFileUtils;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.ParameterContributorContext;
import net.sf.jasperreports.engine.util.Designator;
import net.sf.jasperreports.json.data.JsonDataSource;
import net.sf.jasperreports.json.data.JsonQLDataSource;

public class JsonDataAdapterService
extends AbstractDataAdapterService
implements Designator<DataAdapter> {
    public static final String JSON_DESIGNATION = "net.sf.jasperreports.data.adapter:JSON";
    public static final String JSONQL_DESIGNATION = "net.sf.jasperreports.data.adapter:JSONQL";
    private DataFileStream dataStream;

    public JsonDataAdapterService(ParameterContributorContext paramContribContext, JsonDataAdapter jsonDataAdapter) {
        super(paramContribContext, (DataAdapter)jsonDataAdapter);
    }

    public JsonDataAdapter getJsonDataAdapter() {
        return (JsonDataAdapter)this.getDataAdapter();
    }

    @Override
    public void contributeParameters(Map<String, Object> parameters) throws JRException {
        JsonDataAdapter jsonDataAdapter = this.getJsonDataAdapter();
        if (jsonDataAdapter != null) {
            this.dataStream = DataFileUtils.instance(this.getParameterContributorContext()).getDataStream(jsonDataAdapter.getDataFile(), parameters);
            if (jsonDataAdapter.isUseConnection()) {
                String numberPattern;
                String datePattern;
                TimeZone timeZone;
                parameters.put("JSON_INPUT_STREAM", this.dataStream);
                Locale locale = jsonDataAdapter.getLocale();
                if (locale != null) {
                    parameters.put("JSON_LOCALE", locale);
                }
                if ((timeZone = jsonDataAdapter.getTimeZone()) != null) {
                    parameters.put("JSON_TIME_ZONE", timeZone);
                }
                if ((datePattern = jsonDataAdapter.getDatePattern()) != null && datePattern.trim().length() > 0) {
                    parameters.put("net.sf.jasperreports.json.date.pattern", datePattern);
                }
                if ((numberPattern = jsonDataAdapter.getNumberPattern()) != null && numberPattern.trim().length() > 0) {
                    parameters.put("net.sf.jasperreports.json.number.pattern", numberPattern);
                }
            } else {
                String numberPattern;
                String datePattern;
                TimeZone timeZone;
                JsonQLDataSource ds;
                switch (jsonDataAdapter.getLanguage()) {
                    case JSONQL: {
                        ds = new JsonQLDataSource((InputStream)this.dataStream, jsonDataAdapter.getSelectExpression());
                        break;
                    }
                    default: {
                        ds = new JsonDataSource((InputStream)this.dataStream, jsonDataAdapter.getSelectExpression());
                    }
                }
                Locale locale = jsonDataAdapter.getLocale();
                if (locale != null) {
                    ds.setLocale(locale);
                }
                if ((timeZone = jsonDataAdapter.getTimeZone()) != null) {
                    ds.setTimeZone(timeZone);
                }
                if ((datePattern = jsonDataAdapter.getDatePattern()) != null && datePattern.trim().length() > 0) {
                    ds.setDatePattern(datePattern);
                }
                if ((numberPattern = jsonDataAdapter.getNumberPattern()) != null && numberPattern.trim().length() > 0) {
                    ds.setNumberPattern(numberPattern);
                }
                parameters.put("REPORT_DATA_SOURCE", ds);
            }
        }
    }

    @Override
    public void dispose() {
        if (this.dataStream != null) {
            this.dataStream.dispose();
        }
        super.dispose();
    }

    public String getName(DataAdapter dataAdapter) {
        if (dataAdapter instanceof JsonDataAdapter) {
            switch (((JsonDataAdapter)dataAdapter).getLanguage()) {
                case JSONQL: {
                    return JSONQL_DESIGNATION;
                }
            }
            return JSON_DESIGNATION;
        }
        return null;
    }
}

