/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.poi.query;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import net.sf.jasperreports.data.excel.ExcelFormatEnum;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRPropertiesHolder;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRValueParameter;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.data.AbstractXlsDataSource;
import net.sf.jasperreports.engine.data.XlsxDataSourceFactory;
import net.sf.jasperreports.engine.query.AbstractXlsQueryExecuter;
import net.sf.jasperreports.engine.query.QueryExecutionContext;
import net.sf.jasperreports.engine.query.SimpleQueryExecutionContext;
import net.sf.jasperreports.engine.util.JRClassLoader;
import net.sf.jasperreports.engine.util.Pair;
import net.sf.jasperreports.repo.RepositoryContext;
import net.sf.jasperreports.repo.RepositoryUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ExcelQueryExecuter
extends AbstractXlsQueryExecuter {
    private static final Log log = LogFactory.getLog(ExcelQueryExecuter.class);
    public static final String PROPERTY_XLSX_DATA_SOURCE_FACTORY = "net.sf.jasperreports.xlsx.data.source.factory";
    public static final String EXCEL_DATA_SOURCE_CLASS = "net.sf.jasperreports.poi.data.ExcelDataSource";
    public static final String FASTEXCEL_DATA_SOURCE_CLASS = "net.sf.jasperreports.fastexcel.FastExcelDataSource";
    private static final String POI_XLS_WORKBOOK_CLASS = "org.apache.poi.hssf.usermodel.HSSFWorkbook";
    private static final String POI_XLSX_WORKBOOK_CLASS = "org.apache.poi.xssf.usermodel.XSSFWorkbook";
    private static final String FASTEXCEL_WORKBOOK_CLASS = "org.dhatim.fastexcel.reader.ReadableWorkbook";

    protected ExcelQueryExecuter(JasperReportsContext jasperReportsContext, JRDataset dataset, Map<String, ? extends JRValueParameter> parametersMap) {
        this((QueryExecutionContext)SimpleQueryExecutionContext.of((JasperReportsContext)jasperReportsContext), dataset, parametersMap);
    }

    protected ExcelQueryExecuter(QueryExecutionContext context, JRDataset dataset, Map<String, ? extends JRValueParameter> parametersMap) {
        super(context, dataset, parametersMap);
    }

    protected ExcelQueryExecuter(JRDataset dataset, Map<String, ? extends JRValueParameter> parametersMap) {
        this((JasperReportsContext)DefaultJasperReportsContext.getInstance(), dataset, parametersMap);
    }

    public JRDataSource createDatasource() throws JRException {
        AbstractXlsDataSource dataSource = null;
        Object workbook = this.getParameterValue("XLSX_WORKBOOK", true);
        if (workbook == null) {
            workbook = this.getParameterValue("XLS_WORKBOOK", true);
        }
        if (workbook != null) {
            String dataSourceClassName = null;
            String workbookClassName = workbook.getClass().getName();
            if (POI_XLS_WORKBOOK_CLASS.equals(workbookClassName)) {
                dataSourceClassName = EXCEL_DATA_SOURCE_CLASS;
            } else if (POI_XLSX_WORKBOOK_CLASS.equals(workbookClassName)) {
                dataSourceClassName = EXCEL_DATA_SOURCE_CLASS;
            } else if (FASTEXCEL_WORKBOOK_CLASS.equals(workbookClassName)) {
                dataSourceClassName = FASTEXCEL_DATA_SOURCE_CLASS;
            }
            dataSource = ExcelQueryExecuter.createDataSource(dataSourceClassName, new Class[]{workbook.getClass()}, new Object[]{workbook});
        } else {
            boolean closeInputStream = false;
            InputStream xlsInputStream = (InputStream)this.getParameterValue("XLSX_INPUT_STREAM", true);
            if (xlsInputStream == null) {
                xlsInputStream = (InputStream)this.getParameterValue("XLS_INPUT_STREAM", true);
            }
            if (xlsInputStream == null) {
                closeInputStream = true;
                File xlsFile = (File)this.getParameterValue("XLSX_FILE", true);
                if (xlsFile == null) {
                    xlsFile = (File)this.getParameterValue("XLS_FILE", true);
                }
                if (xlsFile == null) {
                    String xlsSource = this.getStringParameterOrProperty("net.sf.jasperreports.xlsx.source");
                    if (xlsSource == null) {
                        xlsSource = this.getStringParameterOrProperty("net.sf.jasperreports.xls.source");
                    }
                    if (xlsSource == null) {
                        if (log.isWarnEnabled()) {
                            log.warn((Object)"No Excel source was provided.");
                        }
                    } else {
                        xlsInputStream = RepositoryUtil.getInstance((RepositoryContext)this.getRepositoryContext()).getInputStreamFromLocation(xlsSource);
                    }
                } else {
                    try {
                        xlsInputStream = new FileInputStream(xlsFile);
                    }
                    catch (IOException e) {
                        throw new JRException((Throwable)e);
                    }
                }
            }
            if (xlsInputStream != null) {
                ExcelFormatEnum format = null;
                Object objFormat = this.getParameterValue("net.sf.jasperreports.xls.format", true);
                if (objFormat instanceof ExcelFormatEnum) {
                    format = (ExcelFormatEnum)objFormat;
                }
                if (format == null) {
                    format = ExcelFormatEnum.getByName((String)this.getStringParameterOrProperty("net.sf.jasperreports.xls.format"));
                }
                if (format == null) {
                    format = ExcelFormatEnum.AUTODETECT;
                }
                if (format == ExcelFormatEnum.AUTODETECT) {
                    Pair<InputStream, ExcelFormatEnum> sniffResult = ExcelQueryExecuter.sniffExcelFormat(xlsInputStream);
                    xlsInputStream = (InputStream)sniffResult.first();
                    format = (ExcelFormatEnum)sniffResult.second();
                }
                switch (format) {
                    case XLS: {
                        dataSource = ExcelQueryExecuter.createDataSource(EXCEL_DATA_SOURCE_CLASS, new Class[]{InputStream.class, Boolean.TYPE, ExcelFormatEnum.class}, new Object[]{xlsInputStream, closeInputStream, format});
                        break;
                    }
                    case XLSX: {
                        String dataSourceFactoryClassName = this.getPropertiesUtil().getProperty(PROPERTY_XLSX_DATA_SOURCE_FACTORY, new JRPropertiesHolder[]{this.dataset});
                        if (dataSourceFactoryClassName == null) {
                            try {
                                JRClassLoader.loadClassForName((String)FASTEXCEL_DATA_SOURCE_CLASS);
                                dataSource = ExcelQueryExecuter.createDataSource(FASTEXCEL_DATA_SOURCE_CLASS, new Class[]{InputStream.class, Boolean.TYPE}, new Object[]{xlsInputStream, closeInputStream});
                            }
                            catch (ClassNotFoundException e) {
                                dataSource = ExcelQueryExecuter.createDataSource(EXCEL_DATA_SOURCE_CLASS, new Class[]{InputStream.class, Boolean.TYPE, ExcelFormatEnum.class}, new Object[]{xlsInputStream, closeInputStream, format});
                            }
                            break;
                        }
                        dataSource = ExcelQueryExecuter.createDataSource(dataSourceFactoryClassName, xlsInputStream, closeInputStream);
                        break;
                    }
                }
            }
        }
        if (dataSource != null) {
            this.initDatasource(dataSource);
        }
        return dataSource;
    }

    public static AbstractXlsDataSource createDataSource(String dataSourceClassName, Class<?>[] constrParamTypes, Object[] constrParamValues) throws JRException {
        AbstractXlsDataSource dataSource = null;
        try {
            Class dataSourceClass = JRClassLoader.loadClassForName((String)dataSourceClassName);
            Constructor constructor = dataSourceClass.getConstructor(constrParamTypes);
            dataSource = (AbstractXlsDataSource)constructor.newInstance(constrParamValues);
        }
        catch (InvocationTargetException e) {
            throw new JRException(e.getTargetException());
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException e) {
            throw new JRException((Throwable)e);
        }
        return dataSource;
    }

    public static AbstractXlsDataSource createDataSource(String dataSourceFactoryClassName, InputStream inputStream, boolean closeInputStream) throws JRException {
        AbstractXlsDataSource dataSource = null;
        try {
            Class dataSourceFactoryClass = JRClassLoader.loadClassForName((String)dataSourceFactoryClassName);
            XlsxDataSourceFactory dataSourceFactory = (XlsxDataSourceFactory)dataSourceFactoryClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            dataSource = dataSourceFactory.getDataSource(inputStream, closeInputStream);
        }
        catch (InvocationTargetException e) {
            throw new JRException(e.getTargetException());
        }
        catch (IOException | ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException e) {
            throw new JRException((Throwable)e);
        }
        return dataSource;
    }

    public static Pair<InputStream, ExcelFormatEnum> sniffExcelFormat(InputStream inputStream) {
        ExcelFormatEnum format = null;
        BufferedInputStream bis = new BufferedInputStream(inputStream);
        bis.mark(4);
        try {
            int test1 = bis.read();
            int test2 = bis.read();
            int test3 = bis.read();
            int test4 = bis.read();
            bis.reset();
            format = test1 == 80 && test2 == 75 && test3 == 3 && test4 == 4 ? ExcelFormatEnum.XLSX : ExcelFormatEnum.XLS;
        }
        catch (IOException e) {
            throw new JRRuntimeException((Throwable)e);
        }
        return new Pair((Object)bis, (Object)format);
    }
}

