/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.json.util;

import java.io.StringReader;
import java.util.List;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.json.JRJsonNode;
import net.sf.jasperreports.json.JsonNodeContainer;
import net.sf.jasperreports.json.expression.JsonQLExpression;
import net.sf.jasperreports.json.expression.JsonQLExpressionEvaluator;
import net.sf.jasperreports.json.parser.JsonQueryLexer;
import net.sf.jasperreports.json.parser.JsonQueryParser;
import net.sf.jasperreports.json.parser.JsonQueryWalker;
import net.sf.jasperreports.json.util.JsonQLExecuter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DefaultJsonQLExecuter
implements JsonQLExecuter {
    private static final Log log = LogFactory.getLog(DefaultJsonQLExecuter.class);
    private JsonQLExpressionEvaluator evaluator = new JsonQLExpressionEvaluator();

    @Override
    public List<JRJsonNode> selectNodes(JRJsonNode rootNode, String expression) throws JRException {
        if (expression != null && expression.trim().length() > 0) {
            JsonNodeContainer container = this.evaluator.evaluate(this.getJsonQLExpression(expression), rootNode);
            if (container != null) {
                return container.getContainerNodes();
            }
        } else {
            JsonNodeContainer container = new JsonNodeContainer(rootNode);
            return container.getContainerNodes();
        }
        return null;
    }

    @Override
    public JRJsonNode selectNode(JRJsonNode contextNode, JRJsonNode rootNode, String expression) throws JRException {
        if (expression != null && expression.trim().length() > 0) {
            JsonNodeContainer container;
            JsonQLExpression jsonQLExpression = this.getJsonQLExpression(expression);
            JRJsonNode node = contextNode;
            if (jsonQLExpression.isAbsolute()) {
                node = rootNode;
            }
            if ((container = this.evaluator.evaluate(jsonQLExpression, node)) != null) {
                return container.getNodes().get(0);
            }
        } else {
            return contextNode;
        }
        return null;
    }

    public JsonNodeContainer evaluateExpression(JRJsonNode jrJsonNode, String expression) {
        if (expression != null && expression.trim().length() > 0) {
            return this.evaluator.evaluate(this.getJsonQLExpression(expression), jrJsonNode);
        }
        return null;
    }

    public JsonQLExpressionEvaluator getEvaluator() {
        return this.evaluator;
    }

    protected JsonQLExpression getJsonQLExpression(String expression) {
        try {
            JsonQueryLexer lexer = new JsonQueryLexer(new StringReader(expression.trim()));
            JsonQueryParser parser = new JsonQueryParser(lexer);
            parser.pathExpr();
            JsonQueryWalker walker = new JsonQueryWalker();
            return walker.jsonQLExpression(parser.getAST());
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Exception is of type: " + e.getClass()));
            }
            throw new JRRuntimeException((Throwable)e);
        }
    }
}

