/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400EndJobDS;
import com.ibm.as400.access.AS400ImplRemote;
import com.ibm.as400.access.AS400Server;
import com.ibm.as400.access.ClientAccessDataStream;
import com.ibm.as400.access.DDMDataStream;
import com.ibm.as400.access.DataStream;
import com.ibm.as400.access.SocketContainer;
import com.ibm.as400.access.Trace;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.Vector;

class AS400NoThreadServer
extends AS400Server {
    private static final String copyright = "Copyright (C) 1997-2001 International Business Machines Corporation and others.";
    private AS400ImplRemote system_;
    private int service_;
    private String jobString_;
    private SocketContainer socket_;
    private InputStream inStream_;
    private OutputStream outStream_;
    private Hashtable replyStreams_;
    private Hashtable instanceReplyStreams_ = new Hashtable();
    private DataStream exchangeAttrReply_ = null;
    private Vector replyList_ = new Vector(5);
    private Vector discardList_ = new Vector();
    private int lastCorrelationId_ = 0;
    private Object correlationIdLock_ = new Object();
    private boolean closed_ = false;

    AS400NoThreadServer(AS400ImplRemote aS400ImplRemote, int n, SocketContainer socketContainer, String string) throws IOException {
        this.system_ = aS400ImplRemote;
        this.service_ = n;
        this.jobString_ = string;
        this.socket_ = socketContainer;
        this.inStream_ = socketContainer.getInputStream();
        this.outStream_ = socketContainer.getOutputStream();
        this.replyStreams_ = AS400Server.replyStreamsHashTables[n];
    }

    int getService() {
        return this.service_;
    }

    String getJobString() {
        return this.jobString_;
    }

    boolean isConnected() {
        return !this.closed_;
    }

    DataStream getExchangeAttrReply() {
        return this.exchangeAttrReply_;
    }

    synchronized DataStream sendExchangeAttrRequest(DataStream dataStream) throws IOException {
        if (this.exchangeAttrReply_ == null) {
            this.exchangeAttrReply_ = this.sendAndReceive(dataStream);
        }
        return this.exchangeAttrReply_;
    }

    void addInstanceReplyStream(DataStream dataStream) {
        this.instanceReplyStreams_.put(dataStream, dataStream);
    }

    void clearInstanceReplyStreams() {
        this.instanceReplyStreams_.clear();
    }

    DataStream sendAndReceive(DataStream dataStream) throws IOException {
        Trace.log(1, "send and receive(): ...");
        int n = this.send(dataStream);
        return this.receive(n);
    }

    void sendAndDiscardReply(DataStream dataStream) throws IOException {
        Trace.log(1, "send and discard(): ...");
        int n = this.send(dataStream);
        this.discardList_.addElement(new Integer(n));
    }

    int send(DataStream dataStream) throws IOException {
        Trace.log(1, "send(): send request...");
        int n = this.newCorrelationId();
        dataStream.setCorrelation(n);
        dataStream.write(this.outStream_);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int newCorrelationId() {
        Object object = this.correlationIdLock_;
        synchronized (object) {
            if (++this.lastCorrelationId_ == 0) {
                this.lastCorrelationId_ = 1;
            }
            return this.lastCorrelationId_;
        }
    }

    void send(DataStream dataStream, int n) throws IOException {
        Trace.log(1, "send(): send request...");
        dataStream.setCorrelation(n);
        dataStream.write(this.outStream_);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized DataStream receive(int n) throws IOException {
        Trace.log(1, "AS400Server receive");
        DataStream dataStream = null;
        do {
            int n2;
            Object object = this.replyList_;
            synchronized (object) {
                if (!this.replyList_.isEmpty()) {
                    for (n2 = 0; n2 < this.replyList_.size(); ++n2) {
                        DataStream dataStream2 = (DataStream)this.replyList_.elementAt(n2);
                        if (dataStream2.getCorrelation() != n) continue;
                        this.replyList_.removeElementAt(n2);
                        dataStream = dataStream2;
                        break;
                    }
                }
            }
            if (dataStream == null) {
                Trace.log(1, "run(): wait for reply...");
                object = null;
                object = this.service_ != 5 ? ClientAccessDataStream.construct(this.inStream_, this.instanceReplyStreams_, this.replyStreams_, this.system_) : DDMDataStream.construct(this.inStream_, this.replyStreams_, this.system_);
                if (Trace.isTraceOn()) {
                    Trace.log(1, "run(): reply received..." + object.toString());
                }
                n2 = 1;
                int n3 = ((DataStream)object).getCorrelation();
                for (int i = 0; i < this.discardList_.size(); ++i) {
                    if ((Integer)this.discardList_.elementAt(i) != n3) continue;
                    this.discardList_.removeElementAt(i);
                    n2 = 0;
                    break;
                }
                if (n2 == 0) continue;
                if (Trace.isTraceOn()) {
                    Trace.log(1, "adding reply...", n3);
                }
                this.replyList_.addElement(object);
                continue;
            }
            Trace.log(1, "received(): valid reply received...", n);
        } while (dataStream == null);
        return dataStream;
    }

    void forceDisconnect() {
        this.closed_ = true;
        if (this.service_ == 4 || this.service_ == 2 || this.service_ == 6) {
            AS400EndJobDS aS400EndJobDS = new AS400EndJobDS(AS400Server.getServerId(this.service_));
            try {
                aS400EndJobDS.write(this.outStream_);
            }
            catch (IOException iOException) {
                Trace.log(2, "Send end job data stream failed.", (Throwable)iOException);
            }
        }
        try {
            this.socket_.close();
        }
        catch (IOException iOException) {
            Trace.log(2, "Socket close failed.", (Throwable)iOException);
        }
    }
}

