/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.ConvTable;
import com.ibm.as400.access.DBDataFormat;
import com.ibm.as400.access.DBDataStreamException;
import com.ibm.as400.access.JDTrace;
import com.ibm.as400.access.Trace;

class DBSuperExtendedDataFormat
implements DBDataFormat {
    private static final int FIXED_LENGTH_ = 16;
    private static final int REPEATED_FIXED_LENGTH_ = 48;
    private byte[] rawBytes_ = null;
    private int offset_ = -1;
    private int numberOfFields_ = -1;

    public DBSuperExtendedDataFormat() {
    }

    public DBSuperExtendedDataFormat(int n) {
        this.numberOfFields_ = n;
    }

    public void overlay(byte[] byArray, int n) {
        this.rawBytes_ = byArray;
        this.offset_ = n;
        if (this.numberOfFields_ == -1) {
            this.numberOfFields_ = BinaryConverter.byteArrayToInt(this.rawBytes_, n + 4);
        } else {
            this.setNumberOfFields(this.numberOfFields_);
        }
    }

    public int getConsistencyToken() {
        return BinaryConverter.byteArrayToInt(this.rawBytes_, this.offset_);
    }

    public int getNumberOfFields() {
        return this.numberOfFields_;
    }

    public int getRecordSize() {
        return BinaryConverter.byteArrayToInt(this.rawBytes_, this.offset_ + 12);
    }

    public int getFieldSQLType(int n) {
        return BinaryConverter.byteArrayToShort(this.rawBytes_, this.offset_ + 18 + n * 48);
    }

    public int getFieldLength(int n) {
        return BinaryConverter.byteArrayToInt(this.rawBytes_, this.offset_ + 20 + n * 48);
    }

    public int getFieldScale(int n) {
        return BinaryConverter.byteArrayToShort(this.rawBytes_, this.offset_ + 24 + n * 48);
    }

    public int getFieldPrecision(int n) {
        return BinaryConverter.byteArrayToShort(this.rawBytes_, this.offset_ + 26 + n * 48);
    }

    public int getFieldCCSID(int n) {
        return BinaryConverter.byteArrayToUnsignedShort(this.rawBytes_, this.offset_ + 28 + n * 48);
    }

    public int getFieldParameterType(int n) {
        return this.rawBytes_[this.offset_ + 30 + n * 48];
    }

    public int getFieldLOBLocator(int n) {
        return BinaryConverter.byteArrayToInt(this.rawBytes_, this.offset_ + 33 + n * 48);
    }

    public int getFieldLOBMaxSize(int n) {
        return BinaryConverter.byteArrayToInt(this.rawBytes_, this.offset_ + 42 + n * 48);
    }

    public int getFieldNameLength(int n) {
        int n2 = BinaryConverter.byteArrayToInt(this.rawBytes_, this.offset_ + 48 + n * 48);
        int n3 = BinaryConverter.byteArrayToInt(this.rawBytes_, this.offset_ + 16 + n * 48 + n2);
        int n4 = n3 - 8;
        return n4;
    }

    public int getFieldNameCCSID(int n) {
        int n2 = this.findCodePoint(n, 14400);
        if (n2 >= 0) {
            return BinaryConverter.byteArrayToShort(this.rawBytes_, this.offset_ + 16 + n2 + 6 + n * 48);
        }
        JDTrace.logInformation("Did not find the code point for the field name");
        return this.getFieldCCSID(n);
    }

    public String getFieldName(int n, ConvTable convTable) {
        int n2 = this.findCodePoint(n, 14400);
        if (n2 >= 0) {
            return convTable.byteArrayToString(this.rawBytes_, this.offset_ + 16 + n2 + 8 + n * 48, this.getFieldNameLength(n));
        }
        JDTrace.logInformation("Did not find the code point for the field name.");
        return "";
    }

    private int findCodePoint(int n, int n2) {
        int n3 = BinaryConverter.byteArrayToInt(this.rawBytes_, this.offset_ + 52 + n * 48);
        int n4 = 0;
        int n5 = BinaryConverter.byteArrayToInt(this.rawBytes_, this.offset_ + 48 + n * 48);
        int n6 = BinaryConverter.byteArrayToInt(this.rawBytes_, this.offset_ + 16 + n * 48 + n5);
        short s = BinaryConverter.byteArrayToShort(this.rawBytes_, this.offset_ + 16 + n * 48 + n5 + 4);
        while (s != n2 && n4 < n3) {
            n6 = BinaryConverter.byteArrayToInt(this.rawBytes_, this.offset_ + 16 + (n4 += n6) + n * 48 + n5);
            s = BinaryConverter.byteArrayToShort(this.rawBytes_, this.offset_ + 16 + n4 + n5 + n * 48);
        }
        if (s != n2) {
            return -1;
        }
        return n4 + n5;
    }

    public void setConsistencyToken(int n) {
        BinaryConverter.intToByteArray(n, this.rawBytes_, this.offset_);
    }

    public void setNumberOfFields(int n) {
        BinaryConverter.intToByteArray(n, this.rawBytes_, this.offset_ + 4);
    }

    public void setRecordSize(int n) {
        Trace.log(1, "called DBSuperExtendedDataFormat.setRecordSize()");
    }

    public void setFieldDescriptionLength(int n) {
        Trace.log(1, "called DBSuperExtendedDataFormat.setFieldDescriptionLength()");
    }

    public void setFieldSQLType(int n, int n2) {
        Trace.log(1, "called DBSuperExtendedDataFormat.setFieldSQLType()");
    }

    public void setFieldLength(int n, int n2) {
        Trace.log(1, "called DBSuperExtendedDataFormat.setFieldLength()");
    }

    public void setFieldScale(int n, int n2) {
        Trace.log(1, "called DBSuperExtendedDataFormat.setFieldScale()");
    }

    public void setFieldPrecision(int n, int n2) {
        Trace.log(1, "called DBSuperExtendedDataFormat.setFieldPrecision()");
    }

    public void setFieldCCSID(int n, int n2) {
        Trace.log(1, "called DBSuperExtendedDataFormat.setFieldCCSID()");
    }

    public void setFieldParameterType(int n, int n2) {
        this.rawBytes_[this.offset_ + n * 48 + 30] = (byte)n2;
    }

    public void setFieldNameLength(int n, int n2) {
        Trace.log(1, "called DBSuperExtendedDataFormat.setFieldNameLength()");
    }

    public void setFieldNameCCSID(int n, int n2) {
        Trace.log(1, "called DBSuperExtendedDataFormat.setFieldNameCCSID()");
    }

    public void setFieldName(int n, String string, ConvTable convTable) throws DBDataStreamException {
        Trace.log(1, "called DBSuperExtendedDataFormat.setFieldName()");
    }

    public int getLength() {
        return 0;
    }
}

