/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.IFSFile;
import com.ibm.as400.access.IFSFileFilter;
import com.ibm.as400.access.Trace;
import java.io.IOException;
import java.util.Enumeration;
import java.util.NoSuchElementException;

class IFSFileEnumeration
implements Enumeration {
    private static final String copyright = "Copyright (C) 1997-2002 International Business Machines Corporation and others.";
    private static final int MAXIMUM_GET_COUNT_ = 128;
    private IFSFile[] contents_;
    private IFSFile[] contentsPending_;
    private IFSFile file_;
    private IFSFileFilter filter_;
    private int index_;
    private String pattern_;
    private String restartName_;
    private byte[] restartID_;
    private boolean isRestartByNameSupported_;

    IFSFileEnumeration(IFSFile iFSFile, IFSFileFilter iFSFileFilter, String string) throws AS400SecurityException, IOException {
        this.file_ = iFSFile;
        this.filter_ = iFSFileFilter;
        this.pattern_ = string;
        String string2 = this.file_.getPath().toUpperCase();
        if (string2.startsWith("/QSYS.LIB") || string2.startsWith("/QDLS.LIB") || string2.startsWith("/QDLS/")) {
            this.isRestartByNameSupported_ = true;
            this.contentsPending_ = this.loadPendingBlock((String)null);
            if (this.contentsPending_ != null) {
                this.restartName_ = this.contentsPending_[this.contentsPending_.length - 1].getName();
            }
        } else {
            this.isRestartByNameSupported_ = false;
            this.contentsPending_ = this.loadPendingBlock((byte[])null);
            if (this.contentsPending_ != null) {
                this.restartID_ = this.contentsPending_[this.contentsPending_.length - 1].getRestartID();
            }
        }
        this.getNextBlock();
    }

    public boolean hasMoreElements() {
        return this.contents_ != null && this.index_ < this.contents_.length || this.contentsPending_ != null;
    }

    private IFSFile[] loadPendingBlock(String string) throws AS400SecurityException, IOException {
        IFSFile[] iFSFileArray = this.file_.listFiles0(this.filter_, this.pattern_, 128, string);
        if (iFSFileArray.length == 0) {
            iFSFileArray = null;
        }
        return iFSFileArray;
    }

    private IFSFile[] loadPendingBlock(byte[] byArray) throws AS400SecurityException, IOException {
        IFSFile[] iFSFileArray = this.file_.listFiles0(this.filter_, this.pattern_, 128, byArray);
        if (iFSFileArray.length == 0) {
            iFSFileArray = null;
        }
        return iFSFileArray;
    }

    private void getNextBlock() throws AS400SecurityException, IOException {
        if (this.contentsPending_ == null) {
            if (Trace.traceOn_) {
                Trace.log(1, "getNextBlock() was called when contentsPending_==null.");
            }
            return;
        }
        this.contents_ = this.contentsPending_;
        this.contentsPending_ = null;
        this.index_ = 0;
        if (this.contents_.length >= 126) {
            if (this.isRestartByNameSupported_) {
                if (this.restartName_ == null) {
                    if (Trace.traceOn_) {
                        Trace.log(2, "getNextBlock() was called when restartName_==null.");
                    }
                    return;
                }
                this.contentsPending_ = this.loadPendingBlock(this.restartName_);
                if (this.contentsPending_ != null) {
                    this.restartName_ = this.contentsPending_[this.contentsPending_.length - 1].getName();
                }
            } else {
                if (this.restartID_ == null) {
                    if (Trace.traceOn_) {
                        Trace.log(2, "getNextBlock() was called when restartID_==null.");
                    }
                    return;
                }
                this.contentsPending_ = this.loadPendingBlock(this.restartID_);
                if (this.contentsPending_ != null) {
                    this.restartID_ = this.contentsPending_[this.contentsPending_.length - 1].getRestartID();
                }
            }
        }
    }

    public Object nextElement() {
        if (this.index_ < this.contents_.length) {
            return this.contents_[this.index_++];
        }
        if (this.contentsPending_ == null) {
            throw new NoSuchElementException();
        }
        try {
            this.getNextBlock();
        }
        catch (Exception exception) {
            throw new NoSuchElementException();
        }
        return this.contents_[this.index_++];
    }
}

