/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400Impl;
import com.ibm.as400.access.AS400ImplRemote;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.AS400Server;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.CharConverter;
import com.ibm.as400.access.ClientAccessDataStream;
import com.ibm.as400.access.ConnectionDroppedException;
import com.ibm.as400.access.DataStream;
import com.ibm.as400.access.ExtendedIOException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.IFSCachedAttributes;
import com.ibm.as400.access.IFSChangeAttrsReq;
import com.ibm.as400.access.IFSCreateDirHandleRep;
import com.ibm.as400.access.IFSCreateDirHandleReq;
import com.ibm.as400.access.IFSCreateDirReq;
import com.ibm.as400.access.IFSDataStream;
import com.ibm.as400.access.IFSDataStreamReq;
import com.ibm.as400.access.IFSDeleteDirReq;
import com.ibm.as400.access.IFSDeleteFileReq;
import com.ibm.as400.access.IFSFile;
import com.ibm.as400.access.IFSFileDescriptorImplRemote;
import com.ibm.as400.access.IFSFileImpl;
import com.ibm.as400.access.IFSListAttrsRep;
import com.ibm.as400.access.IFSListAttrsReq;
import com.ibm.as400.access.IFSOpenRep;
import com.ibm.as400.access.IFSOpenReq;
import com.ibm.as400.access.IFSQuerySpaceRep;
import com.ibm.as400.access.IFSQuerySpaceReq;
import com.ibm.as400.access.IFSRenameReq;
import com.ibm.as400.access.IFSReturnCodeRep;
import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.ObjectAlreadyExistsException;
import com.ibm.as400.access.Trace;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.Vector;

class IFSFileImplRemote
implements IFSFileImpl {
    private transient IFSListAttrsRep attributesReply_;
    private transient IFSCachedAttributes cachedAttributes_;
    private transient int errorRC_;
    private IFSFileDescriptorImplRemote fd_ = new IFSFileDescriptorImplRemote();
    private boolean isSymbolicLink_;
    private boolean determinedIsSymbolicLink_;
    private int patternMatching_ = 0;
    private static final boolean DEBUG = false;

    IFSFileImplRemote() {
    }

    public int canRead() throws IOException, AS400SecurityException {
        this.fd_.connect();
        return this.fd_.checkAccess(1, 8);
    }

    public int canWrite() throws IOException, AS400SecurityException {
        this.fd_.connect();
        return this.fd_.checkAccess(2, 8);
    }

    public boolean copyTo(String string, boolean bl) throws IOException, AS400SecurityException, ObjectAlreadyExistsException {
        this.fd_.connect();
        if (Trace.traceOn_ && !bl && this.fd_.getSystemVRM() < 328448) {
            Trace.log(4, "Server is V5R2 or lower, so the 'Do not replace' argument will be ignored.");
        }
        if (this.isDirectory() == 0 && this.exists(string) == 0) {
            throw new ObjectAlreadyExistsException(string, 1);
        }
        return this.fd_.copyTo(string, bl);
    }

    public long created() throws IOException, AS400SecurityException {
        this.fd_.connect();
        long l = 0L;
        IFSListAttrsRep iFSListAttrsRep = this.getAttributeSetFromServer(this.fd_.path_);
        if (iFSListAttrsRep != null) {
            this.attributesReply_ = iFSListAttrsRep;
            l = iFSListAttrsRep.getCreationDate();
        }
        return l;
    }

    public int createNewFile() throws IOException, AS400SecurityException {
        this.fd_.connect();
        return this.fd_.checkAccess(2, 4);
    }

    public int delete() throws IOException, AS400SecurityException {
        IFSDataStreamReq iFSDataStreamReq;
        block9: {
            this.fd_.connect();
            byte[] byArray = this.fd_.converter_.stringToByteArray(this.fd_.path_);
            iFSDataStreamReq = new IFSDeleteFileReq(byArray, this.fd_.preferredServerCCSID_);
            try {
                if (this.isDirectory() == 0) {
                    iFSDataStreamReq = new IFSDeleteDirReq(byArray, this.fd_.preferredServerCCSID_);
                }
            }
            catch (Exception exception) {
                if (!Trace.traceOn_) break block9;
                Trace.log(4, "Unable to determine if file or directory.\n" + exception.toString());
            }
        }
        ClientAccessDataStream clientAccessDataStream = null;
        try {
            clientAccessDataStream = (ClientAccessDataStream)this.fd_.server_.sendAndReceive(iFSDataStreamReq);
        }
        catch (ConnectionDroppedException connectionDroppedException) {
            Trace.log(2, "Byte stream server connection lost.");
            this.fd_.connectionDropped(connectionDroppedException);
        }
        catch (InterruptedException interruptedException) {
            Trace.log(2, "Interrupted");
            throw new InterruptedIOException(interruptedException.getMessage());
        }
        int n = 0;
        if (clientAccessDataStream instanceof IFSReturnCodeRep) {
            n = ((IFSReturnCodeRep)clientAccessDataStream).getReturnCode();
            if (n != 0 && Trace.traceOn_) {
                Trace.log(2, "IFSReturnCodeRep return code = ", n);
            }
        } else {
            Trace.log(2, "Unknown reply data stream ", clientAccessDataStream.data_);
            throw new InternalErrorException(Integer.toHexString(clientAccessDataStream.getReqRepID()), 2);
        }
        this.attributesReply_ = null;
        return n;
    }

    private boolean determineIsDirectory(IFSListAttrsRep iFSListAttrsRep) {
        boolean bl = false;
        String string = this.fd_.converter_.byteArrayToString(iFSListAttrsRep.getName());
        switch (iFSListAttrsRep.getObjectType()) {
            case 1: 
            case 2: {
                bl = (iFSListAttrsRep.getFixedAttributes() & 0x10) != 0;
                break;
            }
            case 4: {
                String string2 = string.toUpperCase();
                bl = string2.endsWith(".LIB") || string2.endsWith(".FILE");
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    private boolean determineIsFile(IFSListAttrsRep iFSListAttrsRep) {
        boolean bl = false;
        String string = this.fd_.converter_.byteArrayToString(iFSListAttrsRep.getName());
        switch (iFSListAttrsRep.getObjectType()) {
            case 1: 
            case 2: {
                bl = (iFSListAttrsRep.getFixedAttributes() & 0x10) == 0;
                break;
            }
            case 4: {
                String string2 = string.toUpperCase();
                bl = !string2.endsWith(".LIB") && !string2.endsWith(".FILE");
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    public int exists() throws IOException, AS400SecurityException {
        return this.exists(this.fd_.path_);
    }

    private int exists(String string) throws IOException, AS400SecurityException {
        int n = 0;
        this.fd_.connect();
        n = 2;
        try {
            IFSListAttrsRep iFSListAttrsRep = this.getAttributeSetFromServer(string);
            if (iFSListAttrsRep != null) {
                n = 0;
                this.attributesReply_ = iFSListAttrsRep;
            }
        }
        catch (AS400SecurityException aS400SecurityException) {
            n = 5;
        }
        return n;
    }

    String getAbsolutePath() {
        return this.fd_.path_;
    }

    private IFSListAttrsRep getAttributeSetFromServer(String string) throws IOException, AS400SecurityException {
        IFSListAttrsRep iFSListAttrsRep = null;
        Vector vector = this.listAttributes(string, -1, null, true);
        if (vector != null && vector.size() == 1) {
            iFSListAttrsRep = (IFSListAttrsRep)vector.elementAt(0);
        }
        return iFSListAttrsRep;
    }

    public int getCCSID() throws IOException, AS400SecurityException {
        IFSListAttrsRep iFSListAttrsRep = this.listAttributes();
        if (iFSListAttrsRep != null) {
            return iFSListAttrsRep.getCCSID(this.fd_.serverDatastreamLevel_);
        }
        return -1;
    }

    public long getFreeSpace() throws IOException, AS400SecurityException {
        try {
            this.fd_.connect();
        }
        catch (AS400SecurityException aS400SecurityException) {
            throw new ExtendedIOException(5);
        }
        long l = 0L;
        long l2 = 0L;
        ClientAccessDataStream clientAccessDataStream = null;
        try {
            IFSQuerySpaceReq iFSQuerySpaceReq = new IFSQuerySpaceReq(0);
            clientAccessDataStream = (ClientAccessDataStream)this.fd_.server_.sendAndReceive(iFSQuerySpaceReq);
        }
        catch (ConnectionDroppedException connectionDroppedException) {
            Trace.log(2, "Byte stream server connection lost.");
            this.fd_.connectionDropped(connectionDroppedException);
        }
        catch (InterruptedException interruptedException) {
            Trace.log(2, "Interrupted");
            throw new InterruptedIOException(interruptedException.getMessage());
        }
        int n = 0;
        if (!(clientAccessDataStream instanceof IFSQuerySpaceRep)) {
            if (clientAccessDataStream instanceof IFSReturnCodeRep) {
                n = ((IFSReturnCodeRep)clientAccessDataStream).getReturnCode();
                if (n != 0) {
                    Trace.log(2, "IFSReturnCodeRep return code = ", n);
                }
                throw new ExtendedIOException(n);
            }
            Trace.log(2, "Unknown reply data stream ", clientAccessDataStream.getReqRepID());
            throw new InternalErrorException(Integer.toHexString(clientAccessDataStream.getReqRepID()), 2);
        }
        l = ((IFSQuerySpaceRep)clientAccessDataStream).getFreeSpace();
        if (Trace.traceOn_) {
            if (l == Long.MAX_VALUE) {
                Trace.log(1, "MaxStorage appears to be set to *NOMAX");
            } else {
                Trace.log(1, "MaxStorage does not appear to be set to *NOMAX");
            }
        }
        String string = this.fd_.path_;
        if (this.isDirectory() != 0) {
            string = IFSFile.getParent(this.fd_.path_);
        }
        byte[] byArray = this.fd_.getConverter().stringToByteArray(string);
        clientAccessDataStream = null;
        try {
            IFSCreateDirHandleReq iFSCreateDirHandleReq = new IFSCreateDirHandleReq(byArray, this.fd_.preferredServerCCSID_);
            clientAccessDataStream = (ClientAccessDataStream)this.fd_.server_.sendAndReceive(iFSCreateDirHandleReq);
        }
        catch (ConnectionDroppedException connectionDroppedException) {
            Trace.log(2, "Byte stream server connection lost.");
            this.fd_.connectionDropped(connectionDroppedException);
        }
        catch (InterruptedException interruptedException) {
            Trace.log(2, "Interrupted");
            throw new InterruptedIOException(interruptedException.getMessage());
        }
        n = 0;
        int n2 = 0;
        if (!(clientAccessDataStream instanceof IFSCreateDirHandleRep)) {
            if (clientAccessDataStream instanceof IFSReturnCodeRep) {
                n = ((IFSReturnCodeRep)clientAccessDataStream).getReturnCode();
                if (n != 0) {
                    Trace.log(2, "IFSReturnCodeRep return code = ", n);
                }
                throw new ExtendedIOException(n);
            }
            Trace.log(2, "Unknown reply data stream ", clientAccessDataStream.getReqRepID());
            throw new InternalErrorException(Integer.toHexString(clientAccessDataStream.getReqRepID()), 2);
        }
        n2 = ((IFSCreateDirHandleRep)clientAccessDataStream).getHandle();
        clientAccessDataStream = null;
        try {
            IFSQuerySpaceReq iFSQuerySpaceReq = new IFSQuerySpaceReq(n2);
            clientAccessDataStream = (ClientAccessDataStream)this.fd_.server_.sendAndReceive(iFSQuerySpaceReq);
        }
        catch (ConnectionDroppedException connectionDroppedException) {
            Trace.log(2, "Byte stream server connection lost.");
            this.fd_.connectionDropped(connectionDroppedException);
        }
        catch (InterruptedException interruptedException) {
            Trace.log(2, "Interrupted");
            throw new InterruptedIOException(interruptedException.getMessage());
        }
        n = 0;
        if (!(clientAccessDataStream instanceof IFSQuerySpaceRep)) {
            if (clientAccessDataStream instanceof IFSReturnCodeRep) {
                n = ((IFSReturnCodeRep)clientAccessDataStream).getReturnCode();
                if (n != 0) {
                    Trace.log(2, "IFSReturnCodeRep return code = ", n);
                }
                throw new ExtendedIOException(n);
            }
            Trace.log(2, "Unknown reply data stream ", clientAccessDataStream.getReqRepID());
            throw new InternalErrorException(Integer.toHexString(clientAccessDataStream.getReqRepID()), 2);
        }
        l2 = ((IFSQuerySpaceRep)clientAccessDataStream).getFreeSpace();
        return Math.min(l, l2);
    }

    public long getOwnerUID() throws IOException, AS400SecurityException {
        IFSListAttrsRep iFSListAttrsRep = this.listAttributes();
        if (iFSListAttrsRep != null) {
            return iFSListAttrsRep.getOwnerUID();
        }
        return -1L;
    }

    public String getSubtype() throws IOException, AS400SecurityException {
        Vector vector;
        String string = "";
        this.fd_.connect();
        byte[] byArray = this.fd_.converter_.stringToByteArray(this.fd_.path_);
        byte[] byArray2 = this.fd_.converter_.stringToByteArray(".TYPE");
        IFSListAttrsReq iFSListAttrsReq = new IFSListAttrsReq(byArray, this.fd_.preferredServerCCSID_, 0, -1, null, false, byArray2, false);
        if (this.patternMatching_ != 0) {
            iFSListAttrsReq.setPatternMatching(this.patternMatching_);
        }
        if ((vector = this.listAttributes(iFSListAttrsReq)) == null) {
            if (Trace.traceOn_) {
                Trace.log(4, "Received null from listAttributes(req).");
            }
        } else if (vector.size() == 0) {
            if (Trace.traceOn_) {
                Trace.log(4, "Received no replies from listAttributes(req).");
            }
        } else {
            IFSListAttrsRep iFSListAttrsRep;
            byte[] byArray3;
            if (vector.size() > 1 && Trace.traceOn_) {
                Trace.log(4, "Received multiple replies from listAttributes(req) (" + vector.size() + ")");
            }
            if ((byArray3 = (iFSListAttrsRep = (IFSListAttrsRep)vector.elementAt(0)).getExtendedAttributeValue()) != null) {
                string = new CharConverter(37).byteArrayToString(byArray3).trim();
            }
        }
        return string;
    }

    public int isDirectory() throws IOException, AS400SecurityException {
        this.fd_.connect();
        int n = 2;
        if (this.attributesReply_ == null) {
            try {
                this.attributesReply_ = this.getAttributeSetFromServer(this.fd_.path_);
            }
            catch (AS400SecurityException aS400SecurityException) {
                n = 5;
            }
        }
        if (this.attributesReply_ != null && this.determineIsDirectory(this.attributesReply_)) {
            n = 0;
        }
        return n;
    }

    public int isFile() throws IOException, AS400SecurityException {
        this.fd_.connect();
        int n = 2;
        if (this.attributesReply_ == null) {
            try {
                this.attributesReply_ = this.getAttributeSetFromServer(this.fd_.path_);
            }
            catch (AS400SecurityException aS400SecurityException) {
                n = 5;
            }
        }
        if (this.attributesReply_ != null && this.determineIsFile(this.attributesReply_)) {
            n = 0;
        }
        return n;
    }

    public boolean isHidden() throws IOException, AS400SecurityException {
        this.fd_.connect();
        boolean bl = false;
        if (this.attributesReply_ == null) {
            this.attributesReply_ = this.getAttributeSetFromServer(this.fd_.path_);
        }
        if (this.attributesReply_ != null) {
            bl = (this.attributesReply_.getFixedAttributes() & 2) != 0;
        }
        return bl;
    }

    public boolean isReadOnly() throws IOException, AS400SecurityException {
        this.fd_.connect();
        boolean bl = false;
        if (this.attributesReply_ == null) {
            this.attributesReply_ = this.getAttributeSetFromServer(this.fd_.path_);
        }
        if (this.attributesReply_ != null) {
            bl = (this.attributesReply_.getFixedAttributes() & 1) != 0;
        }
        return bl;
    }

    public boolean isSymbolicLink() throws IOException, AS400SecurityException {
        this.fd_.connect();
        if (Trace.traceOn_ && this.fd_.getSystemVRM() < 328448) {
            Trace.log(4, "Server is V5R2 or lower, so isSymbolicLink() will always report false.");
            return false;
        }
        if (!this.determinedIsSymbolicLink_) {
            int n = this.fd_.path_.length();
            if (n <= 1) {
                if (Trace.traceOn_) {
                    Trace.log(1, "Path length is less than 2, so assuming not a symbolic link: " + this.fd_.path_);
                }
                this.isSymbolicLink_ = false;
                this.determinedIsSymbolicLink_ = true;
            } else {
                StringBuffer stringBuffer = new StringBuffer(this.fd_.path_);
                stringBuffer.setCharAt(n - 1, '*');
                String string = stringBuffer.toString();
                String string2 = string.substring(0, 1 + string.lastIndexOf(47));
                byte[] byArray = this.fd_.converter_.stringToByteArray(string);
                IFSCachedAttributes[] iFSCachedAttributesArray = this.listDirectoryDetails(string, string2, -1, byArray, true);
                IFSCachedAttributes iFSCachedAttributes = null;
                String string3 = this.fd_.path_.substring(1 + this.fd_.path_.lastIndexOf(47));
                for (int i = 0; iFSCachedAttributes == null && i < iFSCachedAttributesArray.length; ++i) {
                    if (!iFSCachedAttributesArray[i].name_.equals(string3)) continue;
                    iFSCachedAttributes = iFSCachedAttributesArray[i];
                }
                if (iFSCachedAttributes != null) {
                    this.isSymbolicLink_ = iFSCachedAttributes.isSymbolicLink_;
                    this.determinedIsSymbolicLink_ = true;
                } else {
                    if (Trace.traceOn_) {
                        Trace.log(2, "Received zero matches from listDirectoryDetails() against parent of " + string.toString());
                    }
                    this.isSymbolicLink_ = false;
                    this.determinedIsSymbolicLink_ = true;
                }
            }
        }
        return this.isSymbolicLink_;
    }

    public long lastAccessed() throws IOException, AS400SecurityException {
        this.fd_.connect();
        long l = 0L;
        IFSListAttrsRep iFSListAttrsRep = this.getAttributeSetFromServer(this.fd_.path_);
        if (iFSListAttrsRep != null) {
            this.attributesReply_ = iFSListAttrsRep;
            l = iFSListAttrsRep.getAccessDate();
        }
        return l;
    }

    public long lastModified() throws IOException, AS400SecurityException {
        this.fd_.connect();
        long l = 0L;
        IFSListAttrsRep iFSListAttrsRep = this.getAttributeSetFromServer(this.fd_.path_);
        if (iFSListAttrsRep != null) {
            this.attributesReply_ = iFSListAttrsRep;
            l = iFSListAttrsRep.getModificationDate();
        }
        return l;
    }

    public long length() throws IOException, AS400SecurityException {
        this.fd_.connect();
        long l = 0L;
        if (this.fd_.getSystemVRM() >> 8 != 1282) {
            IFSListAttrsRep iFSListAttrsRep = this.getAttributeSetFromServer(this.fd_.path_);
            if (iFSListAttrsRep != null) {
                this.attributesReply_ = iFSListAttrsRep;
                l = iFSListAttrsRep.getSize(this.fd_.serverDatastreamLevel_);
            }
        } else {
            Vector vector;
            byte[] byArray = this.fd_.converter_.stringToByteArray(this.fd_.path_);
            IFSListAttrsReq iFSListAttrsReq = new IFSListAttrsReq(byArray, this.fd_.preferredServerCCSID_, 0, -1, null, true, null, true);
            if (this.patternMatching_ != 0) {
                iFSListAttrsReq.setPatternMatching(this.patternMatching_);
            }
            if ((vector = this.listAttributes(iFSListAttrsReq)) == null) {
                if (this.errorRC_ != 0) {
                    throw new ExtendedIOException(this.errorRC_);
                }
                throw new InternalErrorException(6);
            }
            if (vector.size() == 0) {
                if (Trace.traceOn_) {
                    Trace.log(4, "Received no replies from listAttributes(req).");
                }
            } else {
                if (vector.size() > 1 && Trace.traceOn_) {
                    Trace.log(4, "Received multiple replies from listAttributes(req) (" + vector.size() + ")");
                }
                IFSListAttrsRep iFSListAttrsRep = (IFSListAttrsRep)vector.elementAt(0);
                l = iFSListAttrsRep.getSize8Bytes();
            }
        }
        return l;
    }

    private Vector listAttributes(int n) throws IOException, AS400SecurityException {
        IFSListAttrsReq iFSListAttrsReq = new IFSListAttrsReq(n, 68);
        if (this.patternMatching_ != 0) {
            iFSListAttrsReq.setPatternMatching(this.patternMatching_);
        }
        return this.listAttributes(iFSListAttrsReq);
    }

    private Vector listAttributes(String string, int n, byte[] byArray, boolean bl) throws IOException, AS400SecurityException {
        IFSListAttrsReq iFSListAttrsReq;
        byte[] byArray2 = this.fd_.converter_.stringToByteArray(string);
        if (n < 0) {
            iFSListAttrsReq = new IFSListAttrsReq(byArray2, this.fd_.preferredServerCCSID_);
            if (this.patternMatching_ != 0) {
                iFSListAttrsReq.setPatternMatching(this.patternMatching_);
            }
        } else {
            iFSListAttrsReq = new IFSListAttrsReq(byArray2, this.fd_.preferredServerCCSID_, 0, n, byArray, bl, null, false);
            if (this.patternMatching_ != 0) {
                iFSListAttrsReq.setPatternMatching(this.patternMatching_);
            }
        }
        return this.listAttributes(iFSListAttrsReq);
    }

    private Vector listAttributes(IFSListAttrsReq iFSListAttrsReq) throws IOException, AS400SecurityException {
        Vector<ClientAccessDataStream> vector = new Vector<ClientAccessDataStream>(256);
        ClientAccessDataStream clientAccessDataStream = null;
        try {
            clientAccessDataStream = (ClientAccessDataStream)this.fd_.server_.sendAndReceive(iFSListAttrsReq);
        }
        catch (ConnectionDroppedException connectionDroppedException) {
            Trace.log(2, "Byte stream server connection lost.");
            this.fd_.connectionDropped(connectionDroppedException);
        }
        catch (InterruptedException interruptedException) {
            Trace.log(2, "Interrupted");
            throw new InterruptedIOException(interruptedException.getMessage());
        }
        int n = -1;
        boolean bl = false;
        do {
            if (clientAccessDataStream instanceof IFSListAttrsRep) {
                vector.addElement(clientAccessDataStream);
            } else if (clientAccessDataStream instanceof IFSReturnCodeRep) {
                n = ((IFSReturnCodeRep)clientAccessDataStream).getReturnCode();
                if (n == 5 || n == 13) {
                    Trace.log(2, "Error getting file attributes for file " + this.fd_.path_ + ": " + "IFSReturnCodeRep return code = ", n);
                    throw new AS400SecurityException(1);
                }
                if (n != 0 && n != 18 && n != 2 && n != 3) {
                    Trace.log(2, "Error getting file attributes for file " + this.fd_.path_ + ": " + "IFSReturnCodeRep return code = ", n);
                    throw new ExtendedIOException(n);
                }
            } else {
                Trace.log(2, "Unknown reply data stream: ", clientAccessDataStream.data_);
                throw new InternalErrorException(Integer.toHexString(clientAccessDataStream.getReqRepID()), 2);
            }
            bl = ((IFSDataStream)clientAccessDataStream).isEndOfChain();
            if (bl) continue;
            try {
                clientAccessDataStream = (ClientAccessDataStream)this.fd_.server_.receive(iFSListAttrsReq.getCorrelation());
            }
            catch (ConnectionDroppedException connectionDroppedException) {
                Trace.log(2, "Byte stream server connection lost.");
                this.fd_.connectionDropped(connectionDroppedException);
            }
            catch (InterruptedException interruptedException) {
                Trace.log(2, "Interrupted");
                throw new InterruptedIOException(interruptedException.getMessage());
            }
        } while (!bl);
        this.errorRC_ = 0;
        if (n == 3) {
            this.errorRC_ = n;
            vector = null;
        } else {
            vector.trimToSize();
        }
        return vector;
    }

    private IFSListAttrsRep listAttributes() throws IOException, AS400SecurityException {
        this.fd_.connect();
        byte[] byArray = this.fd_.getConverter().stringToByteArray(this.fd_.path_);
        IFSOpenReq iFSOpenReq = new IFSOpenReq(byArray, this.fd_.preferredServerCCSID_, this.fd_.preferredServerCCSID_, 1, 0, 0, 8);
        ClientAccessDataStream clientAccessDataStream = null;
        try {
            clientAccessDataStream = (ClientAccessDataStream)this.fd_.getServer().sendAndReceive(iFSOpenReq);
        }
        catch (ConnectionDroppedException connectionDroppedException) {
            this.fd_.connectionDropped(connectionDroppedException);
        }
        catch (InterruptedException interruptedException) {
            Trace.log(2, "Interrupted", (Throwable)interruptedException);
            throw new InterruptedIOException(interruptedException.getMessage());
        }
        int n = -1;
        this.errorRC_ = 0;
        if (!(clientAccessDataStream instanceof IFSOpenRep)) {
            if (clientAccessDataStream instanceof IFSReturnCodeRep) {
                int n2 = ((IFSReturnCodeRep)clientAccessDataStream).getReturnCode();
                if (Trace.traceOn_) {
                    Trace.log(2, "IFSReturnCodeRep return code = ", n2);
                }
                if (n2 == 4) {
                    this.errorRC_ = n2;
                    return null;
                }
                throw new ExtendedIOException(n2);
            }
            Trace.log(2, "Unknown reply data stream ", clientAccessDataStream.getReqRepID());
            throw new InternalErrorException(Integer.toHexString(clientAccessDataStream.getReqRepID()), 2);
        }
        n = ((IFSOpenRep)clientAccessDataStream).getFileHandle();
        this.fd_.setOpen(true, n);
        IFSListAttrsRep iFSListAttrsRep = null;
        Vector vector = this.listAttributes(n);
        if (vector == null) {
            if (Trace.traceOn_) {
                Trace.log(4, "Received null from listAttributes(fileHandle).");
            }
        } else if (vector.size() == 0) {
            if (Trace.traceOn_) {
                Trace.log(4, "Received no replies from listAttributes(fileHandle).");
            }
        } else if (vector.size() > 1) {
            if (Trace.traceOn_) {
                Trace.log(4, "Received multiple replies from listAttributes(fileHandle) (" + vector.size() + ")");
            }
        } else {
            iFSListAttrsRep = (IFSListAttrsRep)vector.elementAt(0);
        }
        this.fd_.close0();
        return iFSListAttrsRep;
    }

    public String[] listDirectoryContents(String string) throws IOException, AS400SecurityException {
        this.fd_.connect();
        Vector vector = this.listAttributes(string, -1, null, true);
        String[] stringArray = null;
        if (vector != null) {
            stringArray = new String[vector.size()];
            int n = 0;
            for (int i = 0; i < vector.size(); ++i) {
                IFSListAttrsRep iFSListAttrsRep = (IFSListAttrsRep)vector.elementAt(i);
                String string2 = this.fd_.converter_.byteArrayToString(iFSListAttrsRep.getName());
                if (string2.equals(".") || string2.equals("..")) continue;
                stringArray[n++] = string2;
            }
            if (n == 0) {
                stringArray = new String[]{};
            } else if (stringArray.length != n) {
                String[] stringArray2 = new String[n];
                System.arraycopy(stringArray, 0, stringArray2, 0, n);
                stringArray = stringArray2;
            }
        }
        return stringArray;
    }

    private IFSCachedAttributes[] listDirectoryDetails(String string, String string2, int n, byte[] byArray, boolean bl) throws IOException, AS400SecurityException {
        this.fd_.connect();
        IFSCachedAttributes[] iFSCachedAttributesArray = null;
        try {
            Vector vector = this.listAttributes(string, n, byArray, bl);
            int n2 = 0;
            if (vector != null) {
                iFSCachedAttributesArray = new IFSCachedAttributes[vector.size()];
                int n3 = this.fd_.serverDatastreamLevel_;
                for (int i = 0; i < vector.size(); ++i) {
                    IFSListAttrsRep iFSListAttrsRep = (IFSListAttrsRep)vector.elementAt(i);
                    String string3 = this.fd_.converter_.byteArrayToString(iFSListAttrsRep.getName());
                    if (string3.equals(".") || string3.equals("..")) continue;
                    boolean bl2 = this.determineIsDirectory(iFSListAttrsRep);
                    boolean bl3 = this.determineIsFile(iFSListAttrsRep);
                    IFSCachedAttributes iFSCachedAttributes = new IFSCachedAttributes(iFSListAttrsRep.getAccessDate(), iFSListAttrsRep.getCreationDate(), iFSListAttrsRep.getFixedAttributes(), iFSListAttrsRep.getModificationDate(), iFSListAttrsRep.getObjectType(), iFSListAttrsRep.getSize(n3), string3, string2, bl2, bl3, iFSListAttrsRep.getRestartID(), iFSListAttrsRep.isSymbolicLink(n3));
                    iFSCachedAttributesArray[n2++] = iFSCachedAttributes;
                }
            }
            if (n2 == 0) {
                iFSCachedAttributesArray = new IFSCachedAttributes[]{};
            } else if (iFSCachedAttributesArray.length != n2) {
                IFSCachedAttributes[] iFSCachedAttributesArray2 = new IFSCachedAttributes[n2];
                System.arraycopy(iFSCachedAttributesArray, 0, iFSCachedAttributesArray2, 0, n2);
                iFSCachedAttributesArray = iFSCachedAttributesArray2;
            }
        }
        catch (AS400SecurityException aS400SecurityException) {
            iFSCachedAttributesArray = null;
        }
        return iFSCachedAttributesArray;
    }

    public IFSCachedAttributes[] listDirectoryDetails(String string, String string2, int n, String string3) throws IOException, AS400SecurityException {
        byte[] byArray = this.fd_.converter_.stringToByteArray(string3);
        return this.listDirectoryDetails(string, string2, n, byArray, true);
    }

    public IFSCachedAttributes[] listDirectoryDetails(String string, String string2, int n, byte[] byArray) throws IOException, AS400SecurityException {
        return this.listDirectoryDetails(string, string2, n, byArray, false);
    }

    public int mkdir(String string) throws IOException, AS400SecurityException {
        int n;
        block5: {
            this.fd_.connect();
            n = 2;
            try {
                byte[] byArray = this.fd_.converter_.stringToByteArray(string);
                IFSCreateDirReq iFSCreateDirReq = new IFSCreateDirReq(byArray, this.fd_.preferredServerCCSID_);
                ClientAccessDataStream clientAccessDataStream = (ClientAccessDataStream)this.fd_.server_.sendAndReceive(iFSCreateDirReq);
                if (clientAccessDataStream instanceof IFSReturnCodeRep) {
                    n = ((IFSReturnCodeRep)clientAccessDataStream).getReturnCode();
                    if (n == 5 || n == 13) {
                        throw new AS400SecurityException(1);
                    }
                    break block5;
                }
                Trace.log(2, "Unknown reply data stream ", clientAccessDataStream.data_);
                throw new InternalErrorException(Integer.toHexString(clientAccessDataStream.getReqRepID()), 2);
            }
            catch (ConnectionDroppedException connectionDroppedException) {
                Trace.log(2, "Byte stream server connection lost.");
                this.fd_.connectionDropped(connectionDroppedException);
            }
            catch (InterruptedException interruptedException) {
                Trace.log(2, "Interrupted");
                throw new InterruptedIOException(interruptedException.getMessage());
            }
        }
        return n;
    }

    public int mkdirs() throws IOException, AS400SecurityException {
        this.fd_.connect();
        boolean bl = false;
        Vector<String> vector = new Vector<String>();
        String string = this.fd_.path_;
        int n = 2;
        n = this.exists(string);
        if (n != 0) {
            do {
                vector.addElement(string);
            } while ((string = IFSFile.getParent(string)) != null && this.exists(string) != 0);
        } else {
            n = 4;
        }
        for (int i = vector.size(); i > 0 && (n = this.mkdir(string = (String)vector.elementAt(i - 1))) == 0; --i) {
        }
        return n;
    }

    public int renameTo(IFSFileImpl iFSFileImpl) throws IOException, AS400SecurityException {
        this.fd_.connect();
        boolean bl = false;
        ClientAccessDataStream clientAccessDataStream = null;
        IFSFileImplRemote iFSFileImplRemote = (IFSFileImplRemote)iFSFileImpl;
        try {
            byte[] byArray = this.fd_.converter_.stringToByteArray(this.fd_.path_);
            byte[] byArray2 = this.fd_.converter_.stringToByteArray(iFSFileImplRemote.getAbsolutePath());
            IFSRenameReq iFSRenameReq = new IFSRenameReq(byArray, byArray2, this.fd_.preferredServerCCSID_, false);
            clientAccessDataStream = (ClientAccessDataStream)this.fd_.server_.sendAndReceive(iFSRenameReq);
        }
        catch (ConnectionDroppedException connectionDroppedException) {
            Trace.log(2, "Byte stream server connection lost.");
            this.fd_.connectionDropped(connectionDroppedException);
        }
        catch (InterruptedException interruptedException) {
            Trace.log(2, "Interrupted");
            throw new InterruptedIOException(interruptedException.getMessage());
        }
        int n = 2;
        if (clientAccessDataStream instanceof IFSReturnCodeRep) {
            n = ((IFSReturnCodeRep)clientAccessDataStream).getReturnCode();
            if (n == 0) {
                bl = true;
            } else if (Trace.traceOn_) {
                Trace.log(2, "Error renaming file: IFSReturnCodeRep return code = ", n);
            }
        } else {
            Trace.log(2, "Unknown reply data stream ", clientAccessDataStream.data_);
            throw new InternalErrorException(Integer.toHexString(clientAccessDataStream.getReqRepID()), 2);
        }
        if (bl) {
            this.fd_.path_ = iFSFileImplRemote.getAbsolutePath();
            this.attributesReply_ = null;
        }
        return n;
    }

    public boolean setCCSID(int n) throws IOException, AS400SecurityException {
        IFSListAttrsRep iFSListAttrsRep = this.listAttributes();
        if (iFSListAttrsRep == null) {
            if (this.errorRC_ != 0) {
                throw new ExtendedIOException(this.errorRC_);
            }
            throw new InternalErrorException(6);
        }
        boolean bl = false;
        byte[] byArray = iFSListAttrsRep.getOA();
        if (Trace.traceOn_) {
            Trace.log(1, "Length of returned OA2* structure (should be 150 or 166): " + byArray.length);
        }
        byte[] byArray2 = BinaryConverter.shortToByteArray((short)n);
        int n2 = IFSListAttrsRep.getCCSIDOffset(this.fd_.serverDatastreamLevel_);
        System.arraycopy(byArray2, 0, byArray, n2, 2);
        ClientAccessDataStream clientAccessDataStream = null;
        try {
            byte[] byArray3 = this.fd_.converter_.stringToByteArray(this.fd_.path_);
            IFSChangeAttrsReq iFSChangeAttrsReq = new IFSChangeAttrsReq(byArray3, this.fd_.preferredServerCCSID_, byArray);
            clientAccessDataStream = (ClientAccessDataStream)this.fd_.server_.sendAndReceive(iFSChangeAttrsReq);
        }
        catch (ConnectionDroppedException connectionDroppedException) {
            Trace.log(2, "Byte stream server connection lost.");
            this.fd_.connectionDropped(connectionDroppedException);
        }
        catch (InterruptedException interruptedException) {
            Trace.log(2, "Interrupted");
            throw new InterruptedIOException(interruptedException.getMessage());
        }
        if (clientAccessDataStream instanceof IFSReturnCodeRep) {
            int n3 = ((IFSReturnCodeRep)clientAccessDataStream).getReturnCode();
            if (n3 == 0) {
                bl = true;
            } else if (Trace.traceOn_) {
                Trace.log(2, "Error setting file data CCSID: IFSReturnCodeRep return code = ", n3);
            }
        } else {
            Trace.log(2, "Unknown reply data stream ", clientAccessDataStream.data_);
            throw new InternalErrorException(Integer.toHexString(clientAccessDataStream.getReqRepID()), 2);
        }
        return bl;
    }

    public boolean setFixedAttributes(int n) throws IOException {
        try {
            this.fd_.connect();
        }
        catch (AS400SecurityException aS400SecurityException) {
            throw new ExtendedIOException(5);
        }
        ClientAccessDataStream clientAccessDataStream = null;
        try {
            byte[] byArray = this.fd_.converter_.stringToByteArray(this.fd_.path_);
            IFSChangeAttrsReq iFSChangeAttrsReq = new IFSChangeAttrsReq(byArray, this.fd_.preferredServerCCSID_, n, true);
            clientAccessDataStream = (ClientAccessDataStream)this.fd_.server_.sendAndReceive(iFSChangeAttrsReq);
        }
        catch (ConnectionDroppedException connectionDroppedException) {
            Trace.log(2, "Byte stream server connection lost.");
            this.fd_.connectionDropped(connectionDroppedException);
        }
        catch (InterruptedException interruptedException) {
            Trace.log(2, "Interrupted");
            throw new InterruptedIOException(interruptedException.getMessage());
        }
        boolean bl = false;
        if (clientAccessDataStream instanceof IFSReturnCodeRep) {
            int n2 = ((IFSReturnCodeRep)clientAccessDataStream).getReturnCode();
            if (n2 == 0) {
                bl = true;
            } else if (Trace.traceOn_) {
                Trace.log(2, "Error setting file attributes: IFSReturnCodeRep return code = ", n2);
            }
        } else {
            Trace.log(2, "Unknown reply data stream ", clientAccessDataStream.data_);
            throw new InternalErrorException(Integer.toHexString(clientAccessDataStream.getReqRepID()), 2);
        }
        this.attributesReply_ = null;
        return bl;
    }

    public boolean setHidden(boolean bl) throws IOException {
        try {
            this.fd_.connect();
        }
        catch (AS400SecurityException aS400SecurityException) {
            throw new ExtendedIOException(5);
        }
        boolean bl2 = false;
        IFSListAttrsRep iFSListAttrsRep = null;
        try {
            iFSListAttrsRep = this.getAttributeSetFromServer(this.fd_.path_);
        }
        catch (AS400SecurityException aS400SecurityException) {
            Trace.log(2, "Failed to get attribute set", (Throwable)aS400SecurityException);
            throw new ExtendedIOException(5);
        }
        if (iFSListAttrsRep != null) {
            boolean bl3;
            int n = iFSListAttrsRep.getFixedAttributes();
            boolean bl4 = bl3 = (n & 2) != 0;
            if (bl3 != bl) {
                int n2 = bl ? n + 2 : n & 0x7FFFFFFD;
                ClientAccessDataStream clientAccessDataStream = null;
                try {
                    byte[] byArray = this.fd_.converter_.stringToByteArray(this.fd_.path_);
                    IFSChangeAttrsReq iFSChangeAttrsReq = new IFSChangeAttrsReq(byArray, this.fd_.preferredServerCCSID_, n2, true);
                    clientAccessDataStream = (ClientAccessDataStream)this.fd_.server_.sendAndReceive(iFSChangeAttrsReq);
                }
                catch (ConnectionDroppedException connectionDroppedException) {
                    Trace.log(2, "Byte stream server connection lost.");
                    this.fd_.connectionDropped(connectionDroppedException);
                }
                catch (InterruptedException interruptedException) {
                    Trace.log(2, "Interrupted");
                    throw new InterruptedIOException(interruptedException.getMessage());
                }
                if (clientAccessDataStream instanceof IFSReturnCodeRep) {
                    int n3 = ((IFSReturnCodeRep)clientAccessDataStream).getReturnCode();
                    if (n3 == 0) {
                        bl2 = true;
                    } else if (Trace.traceOn_) {
                        Trace.log(2, "Error setting hidden attribute: IFSReturnCodeRep return code = ", n3);
                    }
                } else {
                    Trace.log(2, "Unknown reply data stream ", clientAccessDataStream.data_);
                    throw new InternalErrorException(Integer.toHexString(clientAccessDataStream.getReqRepID()), 2);
                }
                this.attributesReply_ = null;
            } else {
                bl2 = true;
            }
        }
        return bl2;
    }

    public void setPatternMatching(int n) {
        this.patternMatching_ = n;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean setLastModified(long l) throws IOException {
        boolean bl;
        block18: {
            boolean bl2;
            block17: {
                bl2 = false;
                try {
                    this.fd_.connect();
                    if (l == -1L) {
                        bl2 = this.length() == 0L;
                    }
                }
                catch (AS400SecurityException aS400SecurityException) {
                    throw new ExtendedIOException(5);
                }
                bl = false;
                if (l == -1L) break block17;
                ClientAccessDataStream clientAccessDataStream = null;
                try {
                    byte[] byArray = this.fd_.converter_.stringToByteArray(this.fd_.path_);
                    IFSChangeAttrsReq iFSChangeAttrsReq = new IFSChangeAttrsReq(byArray, this.fd_.preferredServerCCSID_, 0L, l, 0L);
                    clientAccessDataStream = (ClientAccessDataStream)this.fd_.server_.sendAndReceive(iFSChangeAttrsReq);
                }
                catch (ConnectionDroppedException connectionDroppedException) {
                    Trace.log(2, "Byte stream server connection lost.");
                    this.fd_.connectionDropped(connectionDroppedException);
                }
                catch (InterruptedException interruptedException) {
                    Trace.log(2, "Interrupted");
                    throw new InterruptedIOException(interruptedException.getMessage());
                }
                if (!(clientAccessDataStream instanceof IFSReturnCodeRep)) {
                    Trace.log(2, "Unknown reply data stream ", clientAccessDataStream.data_);
                    throw new InternalErrorException(Integer.toHexString(clientAccessDataStream.getReqRepID()), 2);
                }
                int n = ((IFSReturnCodeRep)clientAccessDataStream).getReturnCode();
                if (n == 0) {
                    bl = true;
                    break block18;
                } else if (Trace.traceOn_) {
                    Trace.log(2, "Error setting last-modified date: IFSReturnCodeRep return code = ", n);
                }
                break block18;
            }
            int n = this.fd_.checkAccess(2, 8, true);
            if (n != 0) {
                if (Trace.traceOn_) {
                    Trace.log(2, "Failed to open file: IFSReturnCodeRep return code = ", n);
                }
                return false;
            }
            byte[] byArray = new byte[1];
            if (bl2) {
                this.fd_.writeBytes(byArray, 0, 1, true);
                bl = this.fd_.setLength(0);
            } else if (1 == this.fd_.read(byArray, 0, 1)) {
                this.fd_.setFileOffset(0);
                this.fd_.writeBytes(byArray, 0, 1, true);
                bl = true;
            } else {
                if (Trace.traceOn_) {
                    Trace.log(2, "Failed to read first byte of file.");
                }
                bl = false;
            }
            this.fd_.close0();
        }
        this.attributesReply_ = null;
        return bl;
    }

    public boolean setLength(int n) throws IOException {
        try {
            this.fd_.connect();
        }
        catch (AS400SecurityException aS400SecurityException) {
            throw new ExtendedIOException(5);
        }
        this.attributesReply_ = null;
        return this.fd_.setLength(n);
    }

    public void setPath(String string) {
        if (this.fd_.server_ != null) {
            throw new ExtendedIllegalStateException("path", 5);
        }
        String string2 = string.length() == 0 || string.charAt(0) != '/' ? "/" + string : string;
        this.fd_.path_ = string2;
    }

    public boolean setReadOnly(boolean bl) throws IOException {
        try {
            this.fd_.connect();
        }
        catch (AS400SecurityException aS400SecurityException) {
            throw new ExtendedIOException(5);
        }
        boolean bl2 = false;
        IFSListAttrsRep iFSListAttrsRep = null;
        try {
            iFSListAttrsRep = this.getAttributeSetFromServer(this.fd_.path_);
        }
        catch (AS400SecurityException aS400SecurityException) {
            Trace.log(2, "Failed to get attribute set", (Throwable)aS400SecurityException);
            throw new ExtendedIOException(5);
        }
        if (iFSListAttrsRep != null) {
            boolean bl3;
            int n = iFSListAttrsRep.getFixedAttributes();
            boolean bl4 = bl3 = (n & 1) != 0;
            if (bl3 != bl) {
                int n2 = bl ? n + 1 : n & 0x7FFFFFFE;
                ClientAccessDataStream clientAccessDataStream = null;
                try {
                    byte[] byArray = this.fd_.converter_.stringToByteArray(this.fd_.path_);
                    IFSChangeAttrsReq iFSChangeAttrsReq = new IFSChangeAttrsReq(byArray, this.fd_.preferredServerCCSID_, n2, true);
                    clientAccessDataStream = (ClientAccessDataStream)this.fd_.server_.sendAndReceive(iFSChangeAttrsReq);
                }
                catch (ConnectionDroppedException connectionDroppedException) {
                    Trace.log(2, "Byte stream server connection lost.");
                    this.fd_.connectionDropped(connectionDroppedException);
                }
                catch (InterruptedException interruptedException) {
                    Trace.log(2, "Interrupted");
                    throw new InterruptedIOException(interruptedException.getMessage());
                }
                if (clientAccessDataStream instanceof IFSReturnCodeRep) {
                    int n3 = ((IFSReturnCodeRep)clientAccessDataStream).getReturnCode();
                    if (n3 == 0) {
                        bl2 = true;
                    } else if (Trace.traceOn_) {
                        Trace.log(2, "Error setting read-only attribute: IFSReturnCodeRep return code = ", n3);
                    }
                } else {
                    Trace.log(2, "Unknown reply data stream ", clientAccessDataStream.data_);
                    throw new InternalErrorException(Integer.toHexString(clientAccessDataStream.getReqRepID()), 2);
                }
                this.attributesReply_ = null;
            } else {
                bl2 = true;
            }
        }
        return bl2;
    }

    public void setSystem(AS400Impl aS400Impl) {
        this.fd_.system_ = (AS400ImplRemote)aS400Impl;
    }

    static {
        AS400Server.addReplyStream((DataStream)new IFSListAttrsRep(), 0);
        AS400Server.addReplyStream((DataStream)new IFSOpenRep(), 0);
        AS400Server.addReplyStream((DataStream)new IFSCreateDirHandleRep(), 0);
        AS400Server.addReplyStream((DataStream)new IFSQuerySpaceRep(), 0);
        AS400Server.addReplyStream((DataStream)new IFSReturnCodeRep(), 0);
    }
}

