/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.ConnectionDroppedException;
import com.ibm.as400.access.DLOPermission;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.IFSFile;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.PermissionAccess;
import com.ibm.as400.access.PermissionAccessDLO;
import com.ibm.as400.access.PermissionAccessQSYS;
import com.ibm.as400.access.PermissionAccessRoot;
import com.ibm.as400.access.QSYSPermission;
import com.ibm.as400.access.RootPermission;
import com.ibm.as400.access.ServerStartupException;
import com.ibm.as400.access.Trace;
import com.ibm.as400.access.UserPermission;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Vector;

public class Permission
implements Cloneable,
Serializable {
    private static final String copyright = "Copyright (C) 1997-2002 International Business Machines Corporation and others.";
    static final long serialVersionUID = 4L;
    public static final int TYPE_DLO = 0;
    public static final int TYPE_QSYS = 1;
    public static final int TYPE_ROOT = 2;
    private AS400 as400_;
    private String authorizationList_;
    private String autListBackup_;
    private boolean autListChanged_;
    private String name_;
    private String owner_;
    private boolean ownerChanged_;
    private boolean revokeOldAuthority_;
    private boolean revokeOldGroupAuthority_;
    private String path_;
    private String asp_ = null;
    private String primaryGroup_;
    private boolean primaryGroupChanged_;
    private boolean sensitivityChanged_;
    private int sensitivityLevel_;
    private int type_;
    private transient Vector userPermissionsBuffer_;
    private transient Vector userPermissions_;
    private transient PermissionAccess access_;
    private transient PropertyChangeSupport changes_;

    public Permission(IFSFile iFSFile) throws AS400Exception, AS400SecurityException, ConnectionDroppedException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException, UnsupportedEncodingException {
        this(iFSFile.getSystem(), iFSFile.getPath(), false);
    }

    public Permission(IFSFile iFSFile, boolean bl) throws AS400Exception, AS400SecurityException, ConnectionDroppedException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException, UnsupportedEncodingException {
        this(iFSFile.getSystem(), iFSFile.getPath(), bl);
    }

    public Permission(AS400 aS400, String string) throws AS400Exception, AS400SecurityException, ConnectionDroppedException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException, UnsupportedEncodingException {
        this(aS400, string, false);
    }

    public Permission(AS400 aS400, String string, boolean bl) throws AS400Exception, AS400SecurityException, ConnectionDroppedException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException, UnsupportedEncodingException {
        if (aS400 == null) {
            throw new NullPointerException("system");
        }
        if (string == null) {
            throw new NullPointerException("fileName");
        }
        this.as400_ = aS400;
        this.path_ = string;
        int n = this.path_.lastIndexOf(47);
        this.name_ = this.path_.substring(n + 1);
        this.type_ = this.parseType(this.path_, bl);
        switch (this.type_) {
            case 1: {
                this.access_ = new PermissionAccessQSYS(this.as400_);
                break;
            }
            case 0: {
                this.access_ = new PermissionAccessDLO(this.as400_);
                break;
            }
            default: {
                this.access_ = new PermissionAccessRoot(this.as400_);
            }
        }
        Vector vector = null;
        try {
            String string2 = this.path_;
            if (this.asp_ != null) {
                string2 = this.asp_ + string2;
            }
            vector = this.access_.getAuthority(string2);
        }
        catch (PropertyVetoException propertyVetoException) {
            Trace.log(2, "unexpected exception, " + propertyVetoException.toString(), (Throwable)propertyVetoException);
        }
        this.changes_ = new PropertyChangeSupport(this);
        this.owner_ = (String)vector.elementAt(0);
        this.primaryGroup_ = (String)vector.elementAt(1);
        this.authorizationList_ = (String)vector.elementAt(2);
        this.sensitivityLevel_ = (Integer)vector.elementAt(3);
        this.userPermissionsBuffer_ = new Vector();
        this.userPermissions_ = new Vector();
        int n2 = vector.size();
        for (int i = 4; i < n2; ++i) {
            UserPermission userPermission = (UserPermission)vector.elementAt(i);
            if (userPermission == null) continue;
            userPermission.setCommitted(-1);
            this.userPermissionsBuffer_.addElement(userPermission);
            this.userPermissions_.addElement(userPermission);
        }
    }

    public void addAuthorizedUser(String string) {
        if (string == null) {
            throw new NullPointerException("userProfileName");
        }
        String string2 = string.trim().toUpperCase();
        if (this.getUserIndex(string2, this.userPermissions_) != -1) {
            Trace.log(2, "Permission already exists for user " + string);
            throw new ExtendedIllegalArgumentException("userProfileName", 2);
        }
        int n = this.getUserIndex(string2, this.userPermissionsBuffer_);
        if (n != -1) {
            UserPermission userPermission = (UserPermission)this.userPermissionsBuffer_.elementAt(n);
            userPermission.setCommitted(2);
            this.userPermissions_.addElement(userPermission);
        } else {
            UserPermission userPermission;
            switch (this.type_) {
                case 0: {
                    userPermission = new DLOPermission(string2);
                    break;
                }
                case 1: {
                    userPermission = new QSYSPermission(string2);
                    break;
                }
                default: {
                    userPermission = new RootPermission(string2);
                }
            }
            userPermission.setGroupIndicator(1);
            userPermission.setCommitted(0);
            this.userPermissionsBuffer_.addElement(userPermission);
            this.userPermissions_.addElement(userPermission);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            Trace.log(2, "Parameter 'listener' is null.");
            throw new NullPointerException("listener");
        }
        this.changes_.addPropertyChangeListener(propertyChangeListener);
    }

    public void addUserPermission(UserPermission userPermission) {
        if (userPermission == null) {
            throw new NullPointerException("userPermission");
        }
        switch (this.type_) {
            case 0: {
                if (userPermission instanceof DLOPermission) break;
            }
            case 1: {
                if (userPermission instanceof QSYSPermission) break;
            }
            case 2: {
                if (userPermission instanceof RootPermission) break;
            }
            default: {
                throw new ExtendedIllegalArgumentException("userPermission", 2);
            }
        }
        String string = userPermission.getUserID();
        if (this.getUserIndex(string, this.userPermissions_) != -1) {
            Trace.log(2, "Permission already exists for user " + string);
            throw new ExtendedIllegalArgumentException("userProfileName", 2);
        }
        int n = this.getUserIndex(string, this.userPermissionsBuffer_);
        if (n != -1) {
            UserPermission userPermission2 = (UserPermission)this.userPermissionsBuffer_.elementAt(n);
            userPermission.setCommitted(2);
            this.userPermissionsBuffer_.setElementAt(userPermission, n);
            this.userPermissions_.addElement(userPermission);
        } else {
            userPermission.setCommitted(0);
            this.userPermissionsBuffer_.addElement(userPermission);
            this.userPermissions_.addElement(userPermission);
        }
    }

    public synchronized void commit() throws AS400Exception, AS400SecurityException, ConnectionDroppedException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException, ServerStartupException {
        if (this.isCommitted()) {
            return;
        }
        try {
            if (this.autListChanged_) {
                this.access_.setAuthorizationList(this.path_, this.authorizationList_, this.autListBackup_);
                this.autListChanged_ = false;
            }
            if (this.sensitivityChanged_) {
                this.access_.setSensitivity(this.path_, this.sensitivityLevel_);
                this.sensitivityChanged_ = false;
            }
            if (this.ownerChanged_) {
                String string = this.path_;
                if (this.asp_ != null) {
                    string = this.asp_ + string;
                }
                this.access_.setOwner(string, this.owner_, this.revokeOldAuthority_);
                this.ownerChanged_ = false;
            }
            if (this.primaryGroupChanged_) {
                this.access_.setPrimaryGroup(this.path_, this.primaryGroup_, this.revokeOldGroupAuthority_);
                this.primaryGroupChanged_ = false;
            }
            int n = this.userPermissionsBuffer_.size();
            block8: for (int i = n - 1; i >= 0; --i) {
                UserPermission userPermission = (UserPermission)this.userPermissionsBuffer_.elementAt(i);
                switch (userPermission.getCommitted()) {
                    case 3: {
                        this.access_.setFromAuthorizationList(this.path_, userPermission.isFromAuthorizationList());
                        userPermission.setCommitted(-1);
                        continue block8;
                    }
                    case 0: {
                        this.access_.addUser(this.path_, userPermission);
                        userPermission.setCommitted(-1);
                        continue block8;
                    }
                    case 2: {
                        this.access_.setAuthority(this.path_, userPermission);
                        userPermission.setCommitted(-1);
                        continue block8;
                    }
                    case 1: {
                        String string = this.path_;
                        if (this.asp_ != null) {
                            string = this.asp_ + string;
                        }
                        this.access_.removeUser(string, userPermission.getUserID());
                        userPermission.setCommitted(-1);
                        this.userPermissionsBuffer_.removeElement(userPermission);
                        continue block8;
                    }
                }
            }
        }
        catch (PropertyVetoException propertyVetoException) {
            Trace.log(2, "unexpected exception, " + propertyVetoException.toString(), (Throwable)propertyVetoException);
        }
        this.changes_.firePropertyChange("permission", null, this);
    }

    public String getAuthorizationList() {
        return this.authorizationList_;
    }

    public Enumeration getAuthorizedUsers() {
        int n = this.userPermissions_.size();
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < n; ++i) {
            UserPermission userPermission = (UserPermission)this.userPermissions_.elementAt(i);
            vector.addElement(userPermission.getUserID());
        }
        return vector.elements();
    }

    public String getObjectPath() {
        return this.path_;
    }

    public String getName() {
        return this.name_;
    }

    public String getOwner() {
        return this.owner_;
    }

    public String getPrimaryGroup() {
        return this.primaryGroup_;
    }

    public int getSensitivityLevel() {
        return this.sensitivityLevel_;
    }

    public AS400 getSystem() {
        return this.as400_;
    }

    public int getType() {
        return this.type_;
    }

    private int getUserIndex(String string, Vector vector) {
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            UserPermission userPermission = (UserPermission)vector.elementAt(i);
            if (!userPermission.getUserID().equals(string)) continue;
            return i;
        }
        return -1;
    }

    public UserPermission getUserPermission(String string) {
        String string2 = string.toUpperCase();
        int n = this.getUserIndex(string2, this.userPermissions_);
        if (n != -1) {
            return (UserPermission)this.userPermissions_.elementAt(n);
        }
        return null;
    }

    public Enumeration getUserPermissions() {
        return this.userPermissions_.elements();
    }

    public boolean isCommitted() {
        boolean bl = true;
        int n = this.userPermissionsBuffer_.size();
        if (this.sensitivityChanged_) {
            return false;
        }
        if (this.autListChanged_) {
            return false;
        }
        if (this.ownerChanged_) {
            return false;
        }
        if (this.primaryGroupChanged_) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            UserPermission userPermission = (UserPermission)this.userPermissionsBuffer_.elementAt(i);
            if (userPermission.getCommitted() == -1) continue;
            bl = false;
            break;
        }
        return bl;
    }

    private int parseType(String string, boolean bl) {
        Trace.log(3, "IASP flag is: " + bl + ", object name: " + string);
        if (bl) {
            int n;
            String string2 = string.toUpperCase();
            if (!string2.endsWith("/")) {
                string2 = string2 + "/";
            }
            if ((n = string2.indexOf("/QSYS.LIB/")) >= 0) {
                if (n > 0) {
                    String string3 = string2.substring(1, n);
                    if (string3.indexOf(47) < 0) {
                        this.asp_ = string.substring(0, n);
                        this.path_ = string.substring(n);
                        return 1;
                    }
                } else {
                    return 1;
                }
            }
            if (string2.startsWith("/QDLS/")) {
                return 0;
            }
            return 2;
        }
        if (string.toUpperCase().startsWith("/QSYS.LIB/")) {
            return 1;
        }
        if (string.toUpperCase().startsWith("/QDLS/")) {
            return 0;
        }
        return 2;
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        int n;
        objectInputStream.defaultReadObject();
        switch (this.type_) {
            case 1: {
                this.access_ = new PermissionAccessQSYS(this.as400_);
                break;
            }
            case 0: {
                this.access_ = new PermissionAccessDLO(this.as400_);
                break;
            }
            default: {
                this.access_ = new PermissionAccessRoot(this.as400_);
            }
        }
        this.userPermissionsBuffer_ = new Vector();
        this.userPermissions_ = new Vector();
        int n2 = (Integer)objectInputStream.readObject();
        for (n = 0; n < n2; ++n) {
            this.userPermissionsBuffer_.addElement(objectInputStream.readObject());
        }
        n2 = (Integer)objectInputStream.readObject();
        for (n = 0; n < n2; ++n) {
            this.userPermissions_.addElement(objectInputStream.readObject());
        }
        this.changes_ = new PropertyChangeSupport(this);
        objectInputStream.readObject();
    }

    public void removeAuthorizedUser(String string) {
        if (string == null) {
            throw new NullPointerException("userProfileName");
        }
        String string2 = string.trim().toUpperCase();
        UserPermission userPermission = this.getUserPermission(string2);
        if (userPermission == null) {
            Trace.log(2, "Permission does not exist for user " + string);
            throw new ExtendedIllegalArgumentException("userProfileName", 2);
        }
        this.removeUserPermission(userPermission);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            Trace.log(2, "Parameter 'listener' is null.");
            throw new NullPointerException("listener");
        }
        this.changes_.removePropertyChangeListener(propertyChangeListener);
    }

    public void removeUserPermission(UserPermission userPermission) {
        if (userPermission == null) {
            throw new NullPointerException("permission");
        }
        if (this.userPermissions_.indexOf(userPermission) == -1) {
            Trace.log(2, "Permission does not exist for user " + userPermission.getUserID());
            throw new ExtendedIllegalArgumentException("permission", 2);
        }
        switch (userPermission.getCommitted()) {
            case 0: {
                this.userPermissions_.removeElement(userPermission);
                this.userPermissionsBuffer_.removeElement(userPermission);
                userPermission.setCommitted(-1);
                break;
            }
            default: {
                userPermission.setCommitted(1);
                this.userPermissions_.removeElement(userPermission);
            }
        }
    }

    public synchronized void setAuthorizationList(String string) {
        if (string == null) {
            throw new NullPointerException("autList");
        }
        if (string.trim().toUpperCase().equals(this.authorizationList_)) {
            return;
        }
        if (!this.autListChanged_) {
            this.autListBackup_ = this.authorizationList_;
        }
        this.authorizationList_ = string.trim().toUpperCase();
        this.autListChanged_ = true;
    }

    public synchronized void setOwner(String string, boolean bl) {
        if (string == null) {
            throw new NullPointerException("owner");
        }
        this.owner_ = string;
        this.revokeOldAuthority_ = bl;
        this.ownerChanged_ = true;
    }

    public void setPrimaryGroup(String string, boolean bl) {
        if (string == null) {
            throw new NullPointerException("primaryGroup");
        }
        this.primaryGroup_ = string;
        this.revokeOldGroupAuthority_ = bl;
        this.primaryGroupChanged_ = true;
    }

    public synchronized void setSensitivityLevel(int n) {
        if (n < 0 || n > 4) {
            throw new ExtendedIllegalArgumentException("sensitivityLevel", 2);
        }
        this.sensitivityLevel_ = n;
        this.sensitivityChanged_ = true;
    }

    public synchronized void setSystem(AS400 aS400) {
        if (aS400 == null) {
            throw new NullPointerException("system");
        }
        if (this.as400_ == null) {
            this.as400_ = aS400;
        } else {
            if (this.as400_.isConnected()) {
                throw new ExtendedIllegalStateException("system", 5);
            }
            if (this.as400_.equals(aS400)) {
                return;
            }
        }
        switch (this.type_) {
            case 1: {
                this.access_ = new PermissionAccessQSYS(this.as400_);
                break;
            }
            case 0: {
                this.access_ = new PermissionAccessDLO(this.as400_);
                break;
            }
            default: {
                this.access_ = new PermissionAccessRoot(this.as400_);
            }
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        int n;
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(new Integer(this.userPermissionsBuffer_.size()));
        for (n = 0; n < this.userPermissionsBuffer_.size(); ++n) {
            objectOutputStream.writeObject(this.userPermissionsBuffer_.elementAt(n));
        }
        objectOutputStream.writeObject(new Integer(this.userPermissions_.size()));
        for (n = 0; n < this.userPermissions_.size(); ++n) {
            objectOutputStream.writeObject(this.userPermissions_.elementAt(n));
        }
        objectOutputStream.writeObject(null);
    }
}

