/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.ConnectionPool;
import com.ibm.as400.access.Trace;

class PoolMaintenance
extends Thread {
    private static final String copyright = "Copyright (C) 1997-2003 International Business Machines Corporation and others.";
    private boolean run_ = false;
    private transient long lastRun_;
    private transient ConnectionPool pool_;

    public PoolMaintenance(ConnectionPool connectionPool) {
        super("AS400ConnectionPoolMaintenanceThread");
        this.setDaemon(true);
        this.pool_ = connectionPool;
        this.lastRun_ = System.currentTimeMillis();
    }

    public long getLastTime() {
        return this.lastRun_;
    }

    public boolean isRunning() {
        return this.run_;
    }

    public synchronized void run() {
        if (Trace.traceOn_) {
            Trace.log(3, "Connection pool maintenance daemon is started...");
        }
        this.run_ = true;
        while (true) {
            if (this.run_) {
                try {
                    this.wait(this.pool_.getCleanupInterval());
                }
                catch (InterruptedException interruptedException) {
                    Trace.log(2, "Connection pool maintenance daemon failed.");
                }
                this.pool_.cleanupConnections();
                this.lastRun_ = System.currentTimeMillis();
                continue;
            }
            try {
                this.wait();
                continue;
            }
            catch (InterruptedException interruptedException) {
                Trace.log(2, "Connection pool maintenance daemon failed.");
                continue;
            }
            break;
        }
    }

    public synchronized void setRunning(boolean bl) {
        if (this.run_ != bl) {
            this.run_ = bl;
            this.notify();
        }
    }
}

