/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400JDBCConnection;
import com.ibm.as400.access.JDError;
import com.ibm.as400.access.JDProperties;
import com.ibm.as400.access.JDUtilities;
import com.ibm.as400.access.SQLBigint;
import com.ibm.as400.access.SQLBinary;
import com.ibm.as400.access.SQLBlob;
import com.ibm.as400.access.SQLBlobLocator;
import com.ibm.as400.access.SQLChar;
import com.ibm.as400.access.SQLCharForBitData;
import com.ibm.as400.access.SQLClob;
import com.ibm.as400.access.SQLClobLocator;
import com.ibm.as400.access.SQLConversionSettings;
import com.ibm.as400.access.SQLDBClob;
import com.ibm.as400.access.SQLDBClobLocator;
import com.ibm.as400.access.SQLData;
import com.ibm.as400.access.SQLDatalink;
import com.ibm.as400.access.SQLDate;
import com.ibm.as400.access.SQLDecimal;
import com.ibm.as400.access.SQLDecimal2;
import com.ibm.as400.access.SQLDouble;
import com.ibm.as400.access.SQLFloat;
import com.ibm.as400.access.SQLGraphic;
import com.ibm.as400.access.SQLInteger;
import com.ibm.as400.access.SQLLongVarchar;
import com.ibm.as400.access.SQLLongVarcharForBitData;
import com.ibm.as400.access.SQLLongVargraphic;
import com.ibm.as400.access.SQLNumeric;
import com.ibm.as400.access.SQLNumeric2;
import com.ibm.as400.access.SQLReal;
import com.ibm.as400.access.SQLRowID;
import com.ibm.as400.access.SQLSmallint;
import com.ibm.as400.access.SQLTime;
import com.ibm.as400.access.SQLTimestamp;
import com.ibm.as400.access.SQLVarbinary;
import com.ibm.as400.access.SQLVarchar;
import com.ibm.as400.access.SQLVarcharForBitData;
import com.ibm.as400.access.SQLVargraphic;
import java.math.BigDecimal;
import java.sql.SQLException;

class SQLDataFactory {
    private static final String copyright = "Copyright (C) 1997-2003 International Business Machines Corporation and others.";

    SQLDataFactory() {
    }

    static String convertScientificNotation(String string) {
        int n = string.indexOf(69);
        if (n < 0) {
            return string;
        }
        String string2 = string.substring(n + 1);
        if (string2.startsWith("+")) {
            string2 = string2.substring(1);
        }
        int n2 = Integer.parseInt(string2);
        boolean bl = string.charAt(0) != '-';
        String string3 = string.substring(bl ? 0 : 1, n);
        int n3 = string3.indexOf(46);
        if (n3 == -1) {
            string3 = string3 + ".0";
            n3 = string3.indexOf(46);
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (n2 >= 0) {
            int n4;
            int n5 = n3 + n2;
            stringBuffer.append(string3.substring(0, n3));
            stringBuffer.append(string3.substring(n3 + 1));
            string3 = stringBuffer.toString();
            for (n4 = string3.length(); n4 < n5; ++n4) {
                stringBuffer.append("0");
            }
            if (n4 > n5) {
                String string4 = stringBuffer.toString().substring(0, n5);
                string4 = string4 + ".";
                string4 = string4 + stringBuffer.toString().substring(n5);
                stringBuffer = new StringBuffer(string4);
            } else {
                stringBuffer.append(".0");
            }
        } else if (-n2 - n3 > 0) {
            stringBuffer.append("0.");
            for (int i = 0; i < -n2 - n3; ++i) {
                stringBuffer.append("0");
            }
            stringBuffer.append(string3.substring(0, n3));
            stringBuffer.append(string3.substring(n3 + 1));
        } else {
            String string5 = string3.substring(0, n3);
            string5 = string5 + string3.substring(n3 + 1);
            stringBuffer.append(string5.substring(0, n3 + n2));
            stringBuffer.append('.');
            stringBuffer.append(string5.substring(n3 + n2));
        }
        String string6 = (bl ? "" : "-") + stringBuffer.toString();
        return string6;
    }

    static int getScale(Object object) {
        int n = 0;
        String string = object.toString();
        int n2 = string.indexOf(46);
        if (n2 != -1) {
            n = string.length() - n2 - 1;
        }
        return n;
    }

    static int getPrecision(Object object) {
        int n = 0;
        if (object instanceof Boolean) {
            n = 1;
        } else {
            String string = object.toString();
            if (string.charAt(0) == '-') {
                string = string.substring(1);
            }
            int n2 = string.length();
            int n3 = -1;
            int n4 = n2;
            int n5 = string.indexOf(46);
            if (n5 >= 0) {
                while (string.charAt(++n3) == '0') {
                }
                while (string.charAt(--n4) == '0') {
                }
            } else {
                n3 = 0;
                n4 = n2 - 1;
            }
            for (int i = n3; i <= n4; ++i) {
                if (!Character.isDigit(string.charAt(i))) continue;
                ++n;
            }
        }
        return n;
    }

    static SQLData newData(int n, int n2, int n3, int n4, SQLConversionSettings sQLConversionSettings, int n5, JDProperties jDProperties) throws SQLException {
        switch (n) {
            case -5: {
                if (n5 >= JDUtilities.vrm450) {
                    return new SQLBigint();
                }
                return new SQLInteger();
            }
            case -2: {
                if (n5 >= JDUtilities.vrm530) {
                    return new SQLBinary(n2, sQLConversionSettings);
                }
                return new SQLCharForBitData(n2, sQLConversionSettings);
            }
            case 2004: {
                return new SQLBlob(n2 - 4, sQLConversionSettings);
            }
            case 1: {
                return new SQLChar(n2, sQLConversionSettings);
            }
            case 2005: {
                return new SQLClob(n2 - 4, sQLConversionSettings);
            }
            case 91: {
                return new SQLDate(sQLConversionSettings);
            }
            case 3: {
                if (sQLConversionSettings != null && !sQLConversionSettings.useBigDecimal()) {
                    return new SQLDecimal2(n3, n4, sQLConversionSettings, n5, jDProperties);
                }
                return new SQLDecimal(n3, n4, sQLConversionSettings, n5, jDProperties);
            }
            case 8: {
                return new SQLDouble(sQLConversionSettings);
            }
            case 6: {
                return new SQLFloat(sQLConversionSettings);
            }
            case 4: {
                return new SQLInteger();
            }
            case 2: {
                if (sQLConversionSettings != null && !sQLConversionSettings.useBigDecimal()) {
                    return new SQLNumeric2(n3, n4, sQLConversionSettings, n5, jDProperties);
                }
                return new SQLNumeric(n3, n4, sQLConversionSettings, n5, jDProperties);
            }
            case 7: {
                return new SQLReal(sQLConversionSettings);
            }
            case -7: 
            case -6: 
            case 5: {
                return new SQLSmallint();
            }
            case 92: {
                return new SQLTime(sQLConversionSettings);
            }
            case 93: {
                return new SQLTimestamp(sQLConversionSettings);
            }
            case -3: {
                if (n5 >= JDUtilities.vrm530) {
                    return new SQLVarbinary(n2, sQLConversionSettings);
                }
                return new SQLVarcharForBitData(n2, sQLConversionSettings);
            }
            case -4: {
                if (n5 >= JDUtilities.vrm530) {
                    return new SQLVarbinary(n2, sQLConversionSettings);
                }
                return new SQLLongVarcharForBitData(n2, sQLConversionSettings);
            }
            case 12: {
                return new SQLVarchar(n2, sQLConversionSettings);
            }
            case -1: {
                return new SQLLongVarchar(n2, sQLConversionSettings);
            }
        }
        JDError.throwSQLException("HY004");
        return null;
    }

    static SQLData newData(AS400JDBCConnection aS400JDBCConnection, int n, int n2, int n3, int n4, int n5, int n6, boolean bl, SQLConversionSettings sQLConversionSettings, int n7, int n8) throws SQLException {
        switch (n2) {
            case 384: {
                return new SQLDate(sQLConversionSettings);
            }
            case 388: {
                return new SQLTime(sQLConversionSettings);
            }
            case 392: {
                return new SQLTimestamp(sQLConversionSettings);
            }
            case 396: {
                return new SQLDatalink(n3 - 2, sQLConversionSettings);
            }
            case 404: {
                return new SQLBlob(n3 - 4, sQLConversionSettings);
            }
            case 408: {
                if (n6 == 65535 && !bl) {
                    return new SQLBlob(n3 - 4, sQLConversionSettings);
                }
                return new SQLClob(n3 - 4, sQLConversionSettings);
            }
            case 412: {
                return new SQLDBClob(n3 - 4, sQLConversionSettings);
            }
            case 448: {
                if (n6 == 65535 && !bl) {
                    return new SQLVarcharForBitData(n3 - 2, sQLConversionSettings);
                }
                return new SQLVarchar(n3 - 2, sQLConversionSettings);
            }
            case 456: {
                if (n6 == 65535 && !bl) {
                    return new SQLLongVarcharForBitData(n3 - 2, sQLConversionSettings);
                }
                return new SQLLongVarchar(n3 - 2, sQLConversionSettings);
            }
            case 452: {
                if (n6 == 65535 && !bl) {
                    return new SQLCharForBitData(n3, sQLConversionSettings);
                }
                return new SQLChar(n3, sQLConversionSettings);
            }
            case 464: {
                return new SQLVargraphic(n3 - 2, sQLConversionSettings);
            }
            case 472: {
                return new SQLLongVargraphic(n3 - 2, sQLConversionSettings);
            }
            case 468: {
                return new SQLGraphic(n3, sQLConversionSettings);
            }
            case 480: {
                if (n3 == 4) {
                    return new SQLReal(sQLConversionSettings);
                }
                return new SQLDouble(sQLConversionSettings);
            }
            case 484: {
                if (sQLConversionSettings != null && !sQLConversionSettings.useBigDecimal()) {
                    return new SQLDecimal2(n4, n5, sQLConversionSettings, aS400JDBCConnection.getVRM(), aS400JDBCConnection.getProperties());
                }
                return new SQLDecimal(n4, n5, sQLConversionSettings, aS400JDBCConnection.getVRM(), aS400JDBCConnection.getProperties());
            }
            case 488: {
                if (sQLConversionSettings != null && !sQLConversionSettings.useBigDecimal()) {
                    return new SQLNumeric2(n4, n5, sQLConversionSettings, aS400JDBCConnection.getVRM(), aS400JDBCConnection.getProperties());
                }
                return new SQLNumeric(n4, n5, sQLConversionSettings, aS400JDBCConnection.getVRM(), aS400JDBCConnection.getProperties());
            }
            case 492: {
                return new SQLBigint();
            }
            case 496: {
                return new SQLInteger(n5);
            }
            case 500: {
                return new SQLSmallint(n5);
            }
            case 904: {
                return new SQLRowID(sQLConversionSettings);
            }
            case 908: {
                return new SQLVarbinary(n3 - 2, sQLConversionSettings);
            }
            case 912: {
                return new SQLBinary(n3, sQLConversionSettings);
            }
            case 960: {
                return new SQLBlobLocator(aS400JDBCConnection, n, n7, sQLConversionSettings, aS400JDBCConnection.getConverter(n6), n8);
            }
            case 964: {
                if (n6 == 65535 && !bl) {
                    return new SQLBlobLocator(aS400JDBCConnection, n, n7, sQLConversionSettings, aS400JDBCConnection.getConverter(n6), n8);
                }
                return new SQLClobLocator(aS400JDBCConnection, n, n7, sQLConversionSettings, aS400JDBCConnection.getConverter(n6), n8);
            }
            case 968: {
                return new SQLDBClobLocator(aS400JDBCConnection, n, n7, sQLConversionSettings, aS400JDBCConnection.getConverter(n6), n8);
            }
        }
        JDError.throwSQLException("HY000", new IllegalArgumentException(Integer.toString(n2)));
        return null;
    }

    static SQLData newData(String string, int n, int n2, int n3, int n4, SQLConversionSettings sQLConversionSettings, int n5, JDProperties jDProperties) throws SQLException {
        if (string.equals("BINARY")) {
            if (n5 >= JDUtilities.vrm530) {
                return new SQLBinary(n, sQLConversionSettings);
            }
            return new SQLCharForBitData(n, sQLConversionSettings);
        }
        if (string.equals("BIGINT")) {
            return new SQLBigint();
        }
        if (string.equals("BLOB")) {
            return new SQLBlob(n, sQLConversionSettings);
        }
        if (string.equals("BINARY LARGE OBJECT")) {
            return new SQLBlob(n, sQLConversionSettings);
        }
        if (string.equals("CHAR")) {
            if (n4 == 65535 && !jDProperties.getBoolean(28)) {
                return new SQLCharForBitData(n, sQLConversionSettings);
            }
            return new SQLChar(n, sQLConversionSettings);
        }
        if (string.equals("CHARACTE")) {
            if (n4 == 65535 && !jDProperties.getBoolean(28)) {
                return new SQLCharForBitData(n, sQLConversionSettings);
            }
            return new SQLChar(n, sQLConversionSettings);
        }
        if (string.equals("CHARACTER")) {
            if (n4 == 65535 && !jDProperties.getBoolean(28)) {
                return new SQLCharForBitData(n, sQLConversionSettings);
            }
            return new SQLChar(n, sQLConversionSettings);
        }
        if (string.equals("CHARACTER VARYING")) {
            if (n4 == 65535 && !jDProperties.getBoolean(28)) {
                return new SQLVarcharForBitData(n, sQLConversionSettings);
            }
            return new SQLVarchar(n, sQLConversionSettings);
        }
        if (string.equals("CLOB")) {
            return new SQLClob(n, sQLConversionSettings);
        }
        if (string.equals("CHARACTER LARGE OBJECT")) {
            return new SQLClob(n, sQLConversionSettings);
        }
        if (string.equals("DATALINK")) {
            return new SQLDatalink(n, sQLConversionSettings);
        }
        if (string.equals("DBCLOB")) {
            return new SQLDBClob(n, sQLConversionSettings);
        }
        if (string.equals("DOUBLE-BYTE CHARACTER LARGE OBJECT")) {
            return new SQLDBClob(n, sQLConversionSettings);
        }
        if (string.equals("DATE")) {
            return new SQLDate(sQLConversionSettings);
        }
        if (string.equals("DECIMAL")) {
            if (sQLConversionSettings != null && !sQLConversionSettings.useBigDecimal()) {
                return new SQLDecimal2(n2, n3, sQLConversionSettings, n5, jDProperties);
            }
            return new SQLDecimal(n2, n3, sQLConversionSettings, n5, jDProperties);
        }
        if (string.equals("DOUBLE")) {
            return new SQLDouble(sQLConversionSettings);
        }
        if (string.equals("DOUBLE P")) {
            return new SQLDouble(sQLConversionSettings);
        }
        if (string.equals("DOUBLE PRECISION")) {
            return new SQLDouble(sQLConversionSettings);
        }
        if (string.equals("FLOAT")) {
            if (n == 4) {
                return new SQLReal(sQLConversionSettings);
            }
            return new SQLDouble(sQLConversionSettings);
        }
        if (string.equals("GRAPHIC")) {
            return new SQLGraphic(n, sQLConversionSettings);
        }
        if (string.equals("GRAPHIC VARYING")) {
            return new SQLVargraphic(n, sQLConversionSettings);
        }
        if (string.equals("INTEGER")) {
            return new SQLInteger();
        }
        if (string.equals("NUMERIC")) {
            if (sQLConversionSettings != null && !sQLConversionSettings.useBigDecimal()) {
                return new SQLNumeric2(n2, n3, sQLConversionSettings, n5, jDProperties);
            }
            return new SQLNumeric(n2, n3, sQLConversionSettings, n5, jDProperties);
        }
        if (string.equals("REAL")) {
            return new SQLReal(sQLConversionSettings);
        }
        if (string.equals("ROWID")) {
            return new SQLRowID(sQLConversionSettings);
        }
        if (string.equals("SMALLINT")) {
            return new SQLSmallint();
        }
        if (string.equals("TIME")) {
            return new SQLTime(sQLConversionSettings);
        }
        if (string.equals("TIMESTAM")) {
            return new SQLTimestamp(sQLConversionSettings);
        }
        if (string.equals("TIMESTAMP")) {
            return new SQLTimestamp(sQLConversionSettings);
        }
        if (string.equals("TIMESTMP")) {
            return new SQLTimestamp(sQLConversionSettings);
        }
        if (string.equals("VARBINARY")) {
            if (n5 >= JDUtilities.vrm530) {
                return new SQLVarbinary(n, sQLConversionSettings);
            }
            return new SQLVarcharForBitData(n, sQLConversionSettings);
        }
        if (string.equals("VARBIN")) {
            if (n5 >= JDUtilities.vrm530) {
                return new SQLVarbinary(n, sQLConversionSettings);
            }
            return new SQLVarcharForBitData(n, sQLConversionSettings);
        }
        if (string.equals("BINARY VARYING")) {
            if (n5 >= JDUtilities.vrm530) {
                return new SQLVarbinary(n, sQLConversionSettings);
            }
            return new SQLVarcharForBitData(n, sQLConversionSettings);
        }
        if (string.equals("VARCHAR")) {
            if (n4 == 65535 && !jDProperties.getBoolean(28)) {
                return new SQLVarcharForBitData(n, sQLConversionSettings);
            }
            return new SQLVarchar(n, sQLConversionSettings);
        }
        if (string.equals("VARG")) {
            return new SQLVargraphic(n, sQLConversionSettings);
        }
        if (string.equals("VARGRAPH")) {
            return new SQLVargraphic(n, sQLConversionSettings);
        }
        if (string.equals("VARGRAPHIC")) {
            return new SQLVargraphic(n, sQLConversionSettings);
        }
        JDError.throwSQLException("HY000", new IllegalArgumentException(string));
        return null;
    }

    public static BigDecimal truncatePrecision(BigDecimal bigDecimal, int n) {
        boolean bl = bigDecimal.longValue() > 0L;
        StringBuffer stringBuffer = new StringBuffer(bl ? "" : "-");
        stringBuffer.append(bigDecimal.toString().substring(bl ? n : n + 1));
        return new BigDecimal(stringBuffer.toString());
    }

    public static String truncateScale(String string, int n) {
        int n2 = string.indexOf(46);
        if (n2 >= 0) {
            StringBuffer stringBuffer = new StringBuffer(string);
            for (int i = 1; i <= n; ++i) {
                stringBuffer.append('0');
            }
            return stringBuffer.toString().substring(0, n2 + n + 1);
        }
        return string;
    }
}

