/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.ConvTable;
import com.ibm.as400.access.JDError;
import com.ibm.as400.access.SQLConversionSettings;
import com.ibm.as400.access.SQLData;
import com.ibm.as400.access.SQLDataFactory;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

final class SQLDouble
implements SQLData {
    private static final String copyright = "Copyright (C) 1997-2003 International Business Machines Corporation and others.";
    private SQLConversionSettings settings_;
    private int truncated_;
    private double value_;

    SQLDouble(SQLConversionSettings sQLConversionSettings) {
        this.settings_ = sQLConversionSettings;
        this.truncated_ = 0;
        this.value_ = 0.0;
    }

    public Object clone() {
        return new SQLDouble(this.settings_);
    }

    public void convertFromRawBytes(byte[] byArray, int n, ConvTable convTable) throws SQLException {
        this.value_ = BinaryConverter.byteArrayToDouble(byArray, n);
    }

    public void convertToRawBytes(byte[] byArray, int n, ConvTable convTable) throws SQLException {
        BinaryConverter.doubleToByteArray(this.value_, byArray, n);
    }

    public void set(Object object, Calendar calendar, int n) throws SQLException {
        this.truncated_ = 0;
        if (object instanceof String) {
            try {
                this.value_ = Double.valueOf((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                JDError.throwSQLException(this, "07006");
            }
        } else if (object instanceof Number) {
            this.value_ = ((Number)object).doubleValue();
            long l = (long)this.value_;
            long l2 = ((Number)object).longValue();
            if (l2 != l) {
                this.truncated_ = 1;
            }
        } else if (object instanceof Boolean) {
            this.value_ = (Boolean)object == true ? 1.0 : 0.0;
        } else {
            JDError.throwSQLException(this, "07006");
        }
    }

    public int getSQLType() {
        return 15;
    }

    public String getCreateParameters() {
        return null;
    }

    public int getDisplaySize() {
        return 22;
    }

    public String getJavaClassName() {
        return "java.lang.Double";
    }

    public String getLiteralPrefix() {
        return null;
    }

    public String getLiteralSuffix() {
        return null;
    }

    public String getLocalName() {
        return "FLOAT";
    }

    public int getMaximumPrecision() {
        return 53;
    }

    public int getMaximumScale() {
        return 0;
    }

    public int getMinimumScale() {
        return 0;
    }

    public int getNativeType() {
        return 480;
    }

    public int getPrecision() {
        return 53;
    }

    public int getRadix() {
        return 2;
    }

    public int getScale() {
        return 0;
    }

    public int getType() {
        return 8;
    }

    public String getTypeName() {
        return "DOUBLE";
    }

    public boolean isSigned() {
        return true;
    }

    public boolean isText() {
        return false;
    }

    public int getActualSize() {
        return SQLDataFactory.getPrecision(Double.toString(this.value_));
    }

    public int getTruncated() {
        return this.truncated_;
    }

    public InputStream getAsciiStream() throws SQLException {
        JDError.throwSQLException(this, "07006");
        return null;
    }

    public BigDecimal getBigDecimal(int n) throws SQLException {
        this.truncated_ = 0;
        BigDecimal bigDecimal = null;
        String string = Double.toString(this.value_);
        int n2 = string.indexOf("E");
        if (n2 == -1) {
            bigDecimal = new BigDecimal(string);
        } else {
            String string2 = string.substring(0, n2);
            int n3 = Integer.parseInt(string.substring(n2 + 1));
            bigDecimal = new BigDecimal(string2);
            bigDecimal = bigDecimal.movePointRight(n3);
        }
        if (n >= 0) {
            if (n >= bigDecimal.scale()) {
                this.truncated_ = 0;
                return bigDecimal.setScale(n);
            }
            this.truncated_ = bigDecimal.scale() - n;
            return bigDecimal.setScale(n, 4);
        }
        return bigDecimal;
    }

    public InputStream getBinaryStream() throws SQLException {
        JDError.throwSQLException(this, "07006");
        return null;
    }

    public Blob getBlob() throws SQLException {
        JDError.throwSQLException(this, "07006");
        return null;
    }

    public boolean getBoolean() throws SQLException {
        this.truncated_ = 0;
        return this.value_ != 0.0;
    }

    public byte getByte() throws SQLException {
        this.truncated_ = 0;
        if (this.value_ > 127.0 || this.value_ < -128.0) {
            this.truncated_ = this.value_ > 32767.0 || this.value_ < -32768.0 ? (this.value_ > 2.147483647E9 || this.value_ < -2.147483648E9 ? 7 : 3) : 1;
        }
        return (byte)this.value_;
    }

    public byte[] getBytes() throws SQLException {
        JDError.throwSQLException(this, "07006");
        return null;
    }

    public Reader getCharacterStream() throws SQLException {
        JDError.throwSQLException(this, "07006");
        return null;
    }

    public Clob getClob() throws SQLException {
        JDError.throwSQLException(this, "07006");
        return null;
    }

    public Date getDate(Calendar calendar) throws SQLException {
        JDError.throwSQLException(this, "07006");
        return null;
    }

    public double getDouble() throws SQLException {
        this.truncated_ = 0;
        return this.value_;
    }

    public float getFloat() throws SQLException {
        this.truncated_ = 0;
        if (this.value_ > 3.4028234663852886E38 || this.value_ < (double)1.4E-45f) {
            this.truncated_ = 4;
        }
        return (float)this.value_;
    }

    public int getInt() throws SQLException {
        this.truncated_ = 0;
        if (this.value_ > 2.147483647E9 || this.value_ < -2.147483648E9) {
            this.truncated_ = 4;
        }
        return (int)this.value_;
    }

    public long getLong() throws SQLException {
        this.truncated_ = 0;
        if (this.value_ > 9.223372036854776E18 || this.value_ < -9.223372036854776E18) {
            this.truncated_ = 1;
        }
        return (long)this.value_;
    }

    public Object getObject() throws SQLException {
        this.truncated_ = 0;
        return new Double(this.value_);
    }

    public short getShort() throws SQLException {
        this.truncated_ = 0;
        if (this.value_ > 32767.0 || this.value_ < -32768.0) {
            this.truncated_ = this.value_ > 2.147483647E9 || this.value_ < -2.147483648E9 ? 6 : 2;
        }
        return (short)this.value_;
    }

    public String getString() throws SQLException {
        this.truncated_ = 0;
        String string = Double.toString(this.value_);
        int n = string.indexOf(46);
        if (n == -1) {
            return string;
        }
        return string.substring(0, n) + this.settings_.getDecimalSeparator() + string.substring(n + 1);
    }

    public Time getTime(Calendar calendar) throws SQLException {
        JDError.throwSQLException(this, "07006");
        return null;
    }

    public Timestamp getTimestamp(Calendar calendar) throws SQLException {
        JDError.throwSQLException(this, "07006");
        return null;
    }

    public InputStream getUnicodeStream() throws SQLException {
        JDError.throwSQLException(this, "07006");
        return null;
    }
}

