/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400FileRecordDescriptionImplRemote;
import com.ibm.as400.access.AS400Message;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.AS400Text;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.CharConverter;
import com.ibm.as400.access.CommandCall;
import com.ibm.as400.access.ConnectionDroppedException;
import com.ibm.as400.access.DateTimeConverter;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.ObjectAlreadyExistsException;
import com.ibm.as400.access.ObjectDescription;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.Product;
import com.ibm.as400.access.ProgramCall;
import com.ibm.as400.access.ProgramParameter;
import com.ibm.as400.access.QSYSObjectPathName;
import com.ibm.as400.access.Record;
import com.ibm.as400.access.SaveFileEntry;
import com.ibm.as400.access.Trace;
import com.ibm.as400.access.UserSpace;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.util.Date;

public class SaveFile
implements Serializable {
    static final long serialVersionUID = 4L;
    private static final boolean DEBUG = false;
    public static final String CURRENT_RELEASE = "*CURRENT";
    public static final String PREVIOUS_RELEASE = "*PRV";
    public static final long NO_MAX = 0L;
    public static final int IMMED = -1;
    public static final int CLS = 0;
    public static final int DEFAULT = -99;
    private static final int EXISTENCE_UNKNOWN = 0;
    private static final int EXISTENCE_YES = 1;
    private static final int EXISTENCE_NO = 2;
    private static final String USERSPACE_NAME = "JT4USRSPC QTEMP     ";
    private static final String USERSPACE_PATH = "/QSYS.LIB/QTEMP.LIB/JT4USRSPC.USRSPC";
    private static final ProgramParameter errorCode_ = new ProgramParameter(new byte[4]);
    private AS400 system_;
    private String path_;
    private String library_;
    private String name_;
    private String targetRelease_ = "*CURRENT";
    private String saveOutput_ = "*NONE";
    private transient int systemVRM_;
    private transient boolean gotSystemVRM_;
    private transient ObjectDescription objectDescription_;
    private transient Record fileAttributes_;
    private transient String savefileNameAndLib_;
    private transient int existence_ = 0;

    public SaveFile(AS400 aS400, String string, String string2) {
        if (aS400 == null) {
            throw new NullPointerException("system");
        }
        if (string == null) {
            throw new NullPointerException("library");
        }
        if (string2 == null) {
            throw new NullPointerException("name");
        }
        this.system_ = aS400;
        this.library_ = string;
        this.name_ = string2;
        this.path_ = QSYSObjectPathName.toPath(string, string2, "FILE");
    }

    public void clear() throws AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, ObjectDoesNotExistException {
        this.checkExistence();
        CommandCall commandCall = new CommandCall(this.system_, "QSYS/CLRSAVF FILE(" + this.library_ + "/" + this.name_ + ")");
        if (!commandCall.run()) {
            throw new AS400Exception(commandCall.getMessageList());
        }
        this.fileAttributes_ = null;
    }

    public void copyTo(String string, String string2) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (string == null) {
            throw new NullPointerException("library");
        }
        if (string2 == null) {
            throw new NullPointerException("name");
        }
        this.checkExistence();
        String string3 = QSYSObjectPathName.toPath(string, string2, "FILE");
        CommandCall commandCall = new CommandCall(this.system_, "QSYS/CPY OBJ('" + this.path_ + "') TOOBJ('" + string3 + "') REPLACE(*YES)");
        if (!commandCall.run()) {
            throw new AS400Exception(commandCall.getMessageList());
        }
    }

    public void create() throws AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, ObjectDoesNotExistException, ObjectAlreadyExistsException {
        this.create(-99L, -99, -99, false, null, null);
    }

    public void create(long l, int n, int n2, boolean bl, String string, String string2) throws AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, ObjectDoesNotExistException, ObjectAlreadyExistsException {
        CommandCall commandCall;
        if (this.exists()) {
            throw new ObjectAlreadyExistsException(this.path_, 1);
        }
        StringBuffer stringBuffer = new StringBuffer("QSYS/CRTSAVF FILE(" + this.library_ + "/" + this.name_ + ") ");
        if (l != -99L) {
            if (l == 0L) {
                stringBuffer.append("MAXRCDS(*NOMAX) ");
            } else {
                stringBuffer.append("MAXRCDS(" + l + ") ");
            }
        }
        if (n != -99) {
            stringBuffer.append("ASP(" + n + ") ");
        }
        switch (n2) {
            case -99: {
                break;
            }
            case 0: {
                stringBuffer.append("WAITFILE(*CLS) ");
                break;
            }
            case -1: {
                stringBuffer.append("WAITFILE(*IMMED) ");
                break;
            }
            default: {
                stringBuffer.append("WAITFILE(" + Integer.toString(n2) + ") ");
            }
        }
        if (bl) {
            stringBuffer.append("SHARE(*YES) ");
        }
        if (string != null) {
            stringBuffer.append("AUT(" + string + ") ");
        }
        if (string2 != null) {
            stringBuffer.append("TEXT('" + string2 + "') ");
        }
        if (!(commandCall = new CommandCall(this.system_, stringBuffer.toString())).run()) {
            this.existence_ = 0;
            throw new AS400Exception(commandCall.getMessageList());
        }
        this.existence_ = 1;
    }

    public void delete() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException {
        CommandCall commandCall = new CommandCall(this.system_, "QSYS/DLTF FILE(" + this.library_ + "/" + this.name_ + ")");
        if (!commandCall.run()) {
            this.existence_ = 0;
            AS400Message[] aS400MessageArray = commandCall.getMessageList();
            if (aS400MessageArray.length > 0) {
                if (aS400MessageArray[0].getID() != null && !aS400MessageArray[0].getID().equals("CPF2105") && !aS400MessageArray[0].getID().equals("CPF2110")) {
                    throw new AS400Exception(aS400MessageArray);
                }
            } else {
                throw new InternalErrorException("No messages returned from failed delete.", 6);
            }
        }
        this.existence_ = 2;
    }

    public boolean equals(Object object) {
        try {
            SaveFile saveFile = (SaveFile)object;
            if (!this.system_.equals(saveFile.getSystem())) {
                return false;
            }
            if (!this.library_.equals(saveFile.getLibrary())) {
                return false;
            }
            return this.name_.equals(saveFile.getName());
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public boolean exists() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (this.objectDescription_ == null) {
            this.objectDescription_ = this.getObjDesc();
        }
        this.existence_ = this.objectDescription_.exists() ? 1 : 2;
        return this.existence_ == 1;
    }

    public int getASP() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.checkExistence();
        if (this.fileAttributes_ == null) {
            this.fileAttributes_ = this.getFileAttributes();
        }
        BigDecimal bigDecimal = (BigDecimal)this.fileAttributes_.getField("SAASP");
        int n = bigDecimal.intValue();
        return n;
    }

    public long getCurrentNumberOfRecords() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        BigDecimal bigDecimal;
        long l;
        this.checkExistence();
        if (this.fileAttributes_ == null) {
            this.fileAttributes_ = this.getFileAttributes();
        }
        if ((l = (bigDecimal = (BigDecimal)this.fileAttributes_.getField("SACNRC")).longValue()) == 99999L) {
            bigDecimal = (BigDecimal)this.fileAttributes_.getField("SACNR2");
            l = bigDecimal.longValue();
        }
        return l;
    }

    public String getDescription() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.objectDescription_ = this.checkExistence();
        return (String)this.objectDescription_.getValue(203);
    }

    public long getLength() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.objectDescription_ = this.checkExistence();
        long l = (Long)this.objectDescription_.getValue(701);
        return l;
    }

    public String getLibrary() {
        return this.library_;
    }

    public long getMaximumNumberOfRecords() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.checkExistence();
        if (this.fileAttributes_ == null) {
            this.fileAttributes_ = this.getFileAttributes();
        }
        BigDecimal bigDecimal = (BigDecimal)this.fileAttributes_.getField("SASIZE");
        return bigDecimal.longValue();
    }

    public String getName() {
        return this.name_;
    }

    public ObjectDescription getObjectDescription() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.objectDescription_ = this.checkExistence();
        return this.objectDescription_;
    }

    public String getPath() {
        return this.path_;
    }

    public AS400 getSystem() {
        return this.system_;
    }

    public String getTargetRelease() {
        return this.targetRelease_;
    }

    public int getWaitTime() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.checkExistence();
        if (this.fileAttributes_ == null) {
            this.fileAttributes_ = this.getFileAttributes();
        }
        BigDecimal bigDecimal = (BigDecimal)this.fileAttributes_.getField("SAWAIT");
        return bigDecimal.intValue();
    }

    public boolean isSaveOutput() {
        return this.saveOutput_.equals("*PRINT");
    }

    public boolean isShared() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        String string;
        this.checkExistence();
        if (this.fileAttributes_ == null) {
            this.fileAttributes_ = this.getFileAttributes();
        }
        return (string = (String)this.fileAttributes_.getField("SASHAR")).equals("Y");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SaveFileEntry[] listEntries() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException, UnsupportedEncodingException {
        this.checkExistence();
        int n = this.system_.getCcsid();
        CharConverter charConverter = new CharConverter(n);
        AS400Text aS400Text = new AS400Text(36, n);
        ProgramParameter[] programParameterArray = new ProgramParameter[]{new ProgramParameter(charConverter.stringToByteArray(USERSPACE_NAME)), new ProgramParameter(charConverter.stringToByteArray("SAVF0200")), new ProgramParameter(charConverter.stringToByteArray(this.getNameAndLib())), new ProgramParameter(charConverter.stringToByteArray("*ALL      ")), new ProgramParameter(charConverter.stringToByteArray("*ALL      ")), new ProgramParameter(aS400Text.toBytes(" ")), errorCode_};
        ProgramCall programCall = new ProgramCall(this.system_, "/QSYS.LIB/QSRLSAVF.PGM", programParameterArray);
        byte[] byArray = null;
        String string = USERSPACE_NAME;
        synchronized (USERSPACE_NAME) {
            UserSpace userSpace = new UserSpace(this.system_, USERSPACE_PATH);
            try {
                userSpace.setMustUseProgramCall(true);
                userSpace.create(262144, true, "", (byte)0, "User space for SaveFile", "*EXCLUDE");
                if (!programCall.run()) {
                    throw new AS400Exception(programCall.getMessageList());
                }
                int n2 = userSpace.getLength();
                byArray = new byte[n2];
                userSpace.read(byArray, 0);
            }
            finally {
                try {
                    userSpace.close();
                }
                catch (Exception exception) {
                    Trace.log(2, "Exception while closing temporary userspace", (Throwable)exception);
                }
            }
            // ** MonitorExit[var7_7] (shouldn't be in output)
            int n3 = BinaryConverter.byteArrayToInt(byArray, 124);
            int n4 = BinaryConverter.byteArrayToInt(byArray, 132);
            int n5 = BinaryConverter.byteArrayToInt(byArray, 136);
            int n6 = BinaryConverter.byteArrayToInt(byArray, 140);
            if (n6 == 0) {
                n6 = n;
            }
            charConverter = new CharConverter(n6);
            byte[] byArray2 = new byte[8];
            SaveFileEntry[] saveFileEntryArray = new SaveFileEntry[n4];
            int n7 = 0;
            for (int i = 0; i < n4; ++i) {
                n7 = n3 + i * n5;
                String string2 = charConverter.byteArrayToString(byArray, n7, 10).trim();
                String string3 = charConverter.byteArrayToString(byArray, n7 += 10, 10).trim();
                String string4 = charConverter.byteArrayToString(byArray, n7 += 10, 10).trim();
                String string5 = charConverter.byteArrayToString(byArray, n7 += 10, 10).trim();
                System.arraycopy(byArray, n7 += 10, byArray2, 0, 8);
                Date date = this.getAsSystemDate(byArray2);
                int n8 = BinaryConverter.byteArrayToInt(byArray, n7 += 8);
                int n9 = BinaryConverter.byteArrayToInt(byArray, n7 += 4);
                int n10 = BinaryConverter.byteArrayToInt(byArray, n7 += 4);
                String string6 = charConverter.byteArrayToString(byArray, n7 += 4, 1);
                String string7 = charConverter.byteArrayToString(byArray, ++n7, 10).trim();
                String string8 = charConverter.byteArrayToString(byArray, n7 += 10, 20).trim();
                String string9 = charConverter.byteArrayToString(byArray, n7 += 20, 63).trim();
                String string10 = charConverter.byteArrayToString(byArray, n7 += 63, 50).trim();
                String string11 = this.getSystemVRM() >= 328192 ? charConverter.byteArrayToString(byArray, n7 += 50, 10).trim() : "";
                saveFileEntryArray[i] = new SaveFileEntry(string2, string3, string4, string5, date, n8, n9, n10, string6, string7, string8, string9, string10, string11);
            }
            return saveFileEntryArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Product[] listProducts() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.checkExistence();
        int n = this.system_.getCcsid();
        CharConverter charConverter = new CharConverter(n);
        ProgramParameter[] programParameterArray = new ProgramParameter[]{new ProgramParameter(charConverter.stringToByteArray(USERSPACE_NAME)), new ProgramParameter(charConverter.stringToByteArray("PRDL0100")), new ProgramParameter(charConverter.stringToByteArray(this.getNameAndLib())), errorCode_};
        ProgramCall programCall = new ProgramCall(this.system_, "/QSYS.LIB/QLPLPRDS.PGM", programParameterArray);
        byte[] byArray = null;
        String string = USERSPACE_NAME;
        synchronized (USERSPACE_NAME) {
            UserSpace userSpace = new UserSpace(this.system_, USERSPACE_PATH);
            try {
                userSpace.setMustUseProgramCall(true);
                userSpace.create(262144, true, "", (byte)0, "User space for SaveFile", "*EXCLUDE");
                if (!programCall.run()) {
                    AS400Message[] aS400MessageArray = programCall.getMessageList();
                    String string2 = aS400MessageArray[0].getID();
                    if (!string2.equalsIgnoreCase("CPF3D94")) {
                        throw new AS400Exception(aS400MessageArray);
                    }
                    if (Trace.isTraceOn()) {
                        Trace.log(3, "No product found in save file");
                    }
                    Product[] productArray = new Product[]{};
                    // ** MonitorExit[var6_6] (shouldn't be in output)
                    return productArray;
                }
                int n2 = userSpace.getLength();
                byArray = new byte[n2];
                userSpace.read(byArray, 0);
            }
            finally {
                try {
                    userSpace.close();
                }
                catch (Exception exception) {
                    Trace.log(2, "Exception while closing temporary userspace", (Throwable)exception);
                }
            }
            // ** MonitorExit[var6_6] (shouldn't be in output)
            int n3 = BinaryConverter.byteArrayToInt(byArray, 124);
            int n4 = BinaryConverter.byteArrayToInt(byArray, 132);
            int n5 = BinaryConverter.byteArrayToInt(byArray, 136);
            int n6 = BinaryConverter.byteArrayToInt(byArray, 140);
            if (n6 == 0) {
                n6 = n;
            }
            charConverter = new CharConverter(n6);
            Product[] productArray = new Product[n4];
            int n7 = 0;
            int n8 = 0;
            while (n8 < n4) {
                n7 = n3 + n8 * n5;
                String string3 = charConverter.byteArrayToString(byArray, n7, 7).trim();
                String string4 = charConverter.byteArrayToString(byArray, n7 += 7, 6).trim();
                String string5 = charConverter.byteArrayToString(byArray, n7 += 6, 4).trim();
                String string6 = charConverter.byteArrayToString(byArray, n7 += 4, 10).trim();
                String string7 = charConverter.byteArrayToString(byArray, n7 += 10, 4).trim();
                productArray[n8] = new Product(this.system_, string3, string5, string4, string6, string7);
                ++n8;
            }
            return productArray;
        }
    }

    public void refresh() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.existence_ = 0;
        this.objectDescription_ = this.checkExistence();
        this.fileAttributes_ = this.getFileAttributes();
    }

    public void renameTo(String string) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (string == null) {
            throw new NullPointerException("name");
        }
        this.checkExistence();
        CommandCall commandCall = new CommandCall(this.system_, "QSYS/RNM OBJ('" + this.path_ + "') NEWOBJ(" + string + ".FILE)");
        if (!commandCall.run()) {
            throw new AS400Exception(commandCall.getMessageList());
        }
        this.name_ = string;
        this.path_ = QSYSObjectPathName.toPath(this.library_, this.name_, "FILE");
        this.fileAttributes_ = null;
        this.objectDescription_ = null;
    }

    public void restore(String string) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (string == null) {
            throw new NullPointerException("libraryName");
        }
        this.checkExistence();
        String string2 = "QSYS/RSTLIB SAVLIB(" + string + ") " + "DEV(*SAVF) SAVF(" + this.library_ + "/" + this.name_ + ") " + "OUTPUT(" + this.saveOutput_ + ") ";
        CommandCall commandCall = new CommandCall(this.system_, string2);
        if (!commandCall.run()) {
            throw new AS400Exception(commandCall.getMessageList());
        }
    }

    public void restore(String string, String[] stringArray, String string2) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (string == null) {
            throw new NullPointerException("libraryName");
        }
        if (stringArray == null) {
            throw new NullPointerException("objectList");
        }
        this.checkExistence();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append(stringArray[i] + " ");
        }
        StringBuffer stringBuffer2 = new StringBuffer("QSYS/RSTOBJ OBJ(" + stringBuffer.toString() + ") " + "SAVLIB(" + string + ") " + "DEV(*SAVF) SAVF(" + this.library_ + "/" + this.name_ + ") " + "OUTPUT(" + this.saveOutput_ + ") ");
        if (string2 != null) {
            stringBuffer2.append("RSTLIB(" + string2 + ") ");
        }
        CommandCall commandCall = new CommandCall(this.system_);
        try {
            if (commandCall.run(stringBuffer2.toString())) {
                return;
            }
            AS400Message[] aS400MessageArray = commandCall.getMessageList();
            if (aS400MessageArray[0].getID().equals("CPF3781")) {
                if (Trace.traceOn_) {
                    Trace.log(1, "Attempting to create library " + string);
                }
                if (!commandCall.run("QSYS/CRTLIB LIB(" + (string2 == null ? string : string2) + ")")) {
                    Trace.log(2, new AS400Exception(commandCall.getMessageList()));
                }
                if (commandCall.run(stringBuffer2.toString())) {
                    return;
                }
            }
            throw new AS400Exception(commandCall.getMessageList());
        }
        catch (PropertyVetoException propertyVetoException) {
            return;
        }
    }

    public void restore(Product product) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        CommandCall commandCall;
        if (product == null) {
            throw new NullPointerException("product");
        }
        this.checkExistence();
        StringBuffer stringBuffer = new StringBuffer("QSYS/RSTLICPGM LICPGM(" + product.getProductID() + ") " + "DEV(*SAVF) SAVF(" + this.library_ + "/" + this.name_ + ") " + "OPTION(" + SaveFile.getProductOption(product) + ") " + "RSTOBJ(" + SaveFile.getObjectType(product) + ") " + "RLS(" + product.getReleaseLevel() + ") " + "OUTPUT(" + this.saveOutput_ + ") ");
        String string = product.getPrimaryLanguageFeatureID();
        if (string != null && string.length() != 0) {
            stringBuffer.append("LNG(" + string + ") ");
        }
        if (!(commandCall = new CommandCall(this.system_, stringBuffer.toString())).run()) {
            throw new AS400Exception(commandCall.getMessageList());
        }
    }

    public void save(String string) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (string == null) {
            throw new NullPointerException("libraryName");
        }
        this.checkExistence();
        String string2 = "QSYS/SAVLIB LIB(" + string + ") " + "DEV(*SAVF) SAVF(" + this.library_ + "/" + this.name_ + ") " + "TGTRLS(" + this.targetRelease_ + ") " + "CLEAR(*ALL) " + "OUTPUT(" + this.saveOutput_ + ") ";
        CommandCall commandCall = new CommandCall(this.system_, string2);
        if (!commandCall.run()) {
            throw new AS400Exception(commandCall.getMessageList());
        }
    }

    public void save(String string, String[] stringArray) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (string == null) {
            throw new NullPointerException("libraryName");
        }
        if (stringArray == null) {
            throw new NullPointerException("objectList");
        }
        this.checkExistence();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append(stringArray[i] + " ");
        }
        String string2 = "QSYS/SAVOBJ OBJ(" + stringBuffer.toString() + ") " + "LIB(" + string + ") " + "DEV(*SAVF) SAVF(" + this.library_ + "/" + this.name_ + ") " + "TGTRLS(" + this.targetRelease_ + ") " + "CLEAR(*ALL) " + "OUTPUT(" + this.saveOutput_ + ") ";
        CommandCall commandCall = new CommandCall(this.system_, string2);
        if (!commandCall.run()) {
            throw new AS400Exception(commandCall.getMessageList());
        }
    }

    public void save(String[] stringArray) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (stringArray == null) {
            throw new NullPointerException("pathList");
        }
        this.checkExistence();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append("('" + stringArray[i] + "') ");
        }
        String string = "QSYS/SAV DEV('" + this.path_ + "') " + "OBJ(" + stringBuffer.toString() + ") " + "TGTRLS(" + this.targetRelease_ + ") " + "CLEAR(*ALL) " + "OUTPUT(" + this.saveOutput_ + ") ";
        CommandCall commandCall = new CommandCall(this.system_, string);
        if (!commandCall.run()) {
            throw new AS400Exception(commandCall.getMessageList());
        }
    }

    public void save(Product product) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        CommandCall commandCall;
        if (product == null) {
            throw new NullPointerException("product");
        }
        this.checkExistence();
        StringBuffer stringBuffer = new StringBuffer("QSYS/SAVLICPGM LICPGM(" + product.getProductID() + ") " + "DEV(*SAVF) SAVF(" + this.library_ + "/" + this.name_ + ") " + "OPTION(" + SaveFile.getProductOption(product) + ") " + "RLS(" + product.getReleaseLevel() + ") " + "OBJTYPE(" + SaveFile.getObjectType(product) + ") " + "TGTRLS(" + this.targetRelease_ + ") " + "CLEAR(*ALL) ");
        String string = product.getPrimaryLanguageFeatureID();
        if (string != null && string.length() != 0) {
            stringBuffer.append("LNG(" + string + ") ");
        }
        if (!(commandCall = new CommandCall(this.system_, stringBuffer.toString())).run()) {
            throw new AS400Exception(commandCall.getMessageList());
        }
    }

    public void setDescription(String string) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (string == null) {
            throw new NullPointerException("description");
        }
        this.objectDescription_ = this.checkExistence();
        String string2 = "QSYS/CHGSAVF FILE(" + this.library_ + "/" + this.name_ + ") TEXT('" + string + "') ";
        CommandCall commandCall = new CommandCall(this.system_, string2);
        if (!commandCall.run()) {
            throw new AS400Exception(commandCall.getMessageList());
        }
        this.objectDescription_ = null;
    }

    public void setMaximumNumberOfRecords(long l) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.checkExistence();
        String string = l == 0L ? "*NOMAX" : Long.toString(l);
        String string2 = "QSYS/CHGSAVF FILE(" + this.library_ + "/" + this.name_ + ") MAXRCDS(" + string + ") ";
        CommandCall commandCall = new CommandCall(this.system_, string2);
        if (!commandCall.run()) {
            throw new AS400Exception(commandCall.getMessageList());
        }
        this.fileAttributes_ = null;
    }

    public void setSaveOutput(boolean bl) {
        this.saveOutput_ = bl ? "*PRINT" : "*NONE";
    }

    public void setShared(boolean bl) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.checkExistence();
        String string = bl ? "*YES" : "*NO";
        String string2 = "QSYS/CHGSAVF FILE(" + this.library_ + "/" + this.name_ + ") SHARE(" + string + ") ";
        CommandCall commandCall = new CommandCall(this.system_, string2);
        if (!commandCall.run()) {
            throw new AS400Exception(commandCall.getMessageList());
        }
        this.fileAttributes_ = null;
    }

    public void setTargetRelease(String string) {
        if (string == null) {
            throw new NullPointerException("targetRelease");
        }
        this.targetRelease_ = string;
    }

    public void setWaitTime(int n) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        String string;
        this.checkExistence();
        switch (n) {
            case -99: 
            case -1: {
                string = "*IMMED";
                break;
            }
            case 0: {
                string = "*CLS";
                break;
            }
            default: {
                string = Integer.toString(n);
            }
        }
        String string2 = "QSYS/CHGSAVF FILE(" + this.library_ + "/" + this.name_ + ") WAITFILE(" + string + ") ";
        CommandCall commandCall = new CommandCall(this.system_, string2);
        if (!commandCall.run()) {
            throw new AS400Exception(commandCall.getMessageList());
        }
        this.fileAttributes_ = null;
    }

    public String toString() {
        return "SaveFile (system: " + this.system_.getSystemName() + "; path: " + this.path_ + "): " + super.toString();
    }

    private String getNameAndLib() {
        if (this.savefileNameAndLib_ == null) {
            StringBuffer stringBuffer = new StringBuffer("                    ");
            stringBuffer.replace(0, this.name_.length(), this.name_);
            stringBuffer.replace(10, 10 + this.library_.length(), this.library_);
            this.savefileNameAndLib_ = stringBuffer.toString();
        }
        return this.savefileNameAndLib_;
    }

    private Date getAsSystemDate(byte[] byArray) throws AS400Exception, AS400SecurityException, ConnectionDroppedException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException, UnsupportedEncodingException {
        DateTimeConverter dateTimeConverter = new DateTimeConverter(this.system_);
        Date date = dateTimeConverter.convert(byArray, "*DTS");
        return date;
    }

    private Record getFileAttributes() throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        AS400FileRecordDescriptionImplRemote aS400FileRecordDescriptionImplRemote = new AS400FileRecordDescriptionImplRemote();
        aS400FileRecordDescriptionImplRemote.setSystem(this.system_.getImpl());
        aS400FileRecordDescriptionImplRemote.setPath(this.path_);
        return aS400FileRecordDescriptionImplRemote.getSavefileAttributes();
    }

    private int getSystemVRM() throws AS400SecurityException, IOException {
        if (!this.gotSystemVRM_) {
            this.systemVRM_ = this.system_.getVRM();
            this.gotSystemVRM_ = true;
        }
        return this.systemVRM_;
    }

    private ObjectDescription getObjDesc() {
        return new ObjectDescription(this.system_, this.library_, this.name_, "FILE");
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        if (Trace.isTraceOn()) {
            Trace.log(1, "De-serializing SaveFile object.");
        }
        objectInputStream.defaultReadObject();
    }

    private ObjectDescription checkExistence() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (this.existence_ == 1 && this.objectDescription_ != null) {
            return this.objectDescription_;
        }
        if (this.objectDescription_ == null) {
            this.objectDescription_ = this.getObjDesc();
        }
        if (this.objectDescription_.exists()) {
            return this.objectDescription_;
        }
        throw new ObjectDoesNotExistException(this.path_, 2);
    }

    private static String getObjectType(Product product) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        String string = product.getLoadType();
        if (string == null || string.length() == 0) {
            string = "*ALL";
        } else if (string.equals("*CODE")) {
            string = "*PGM";
        } else if (string.equals("*LNG")) {
            string = "*LNG";
        } else {
            Trace.log(2, "Unrecognized load type in Product: " + string);
            string = "*ALL";
        }
        return string;
    }

    private static String getProductOption(Product product) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        String string = product.getProductOption();
        if (string == null) {
            Trace.log(2, "Product.getProductOption() returned null.");
            return "";
        }
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '0') continue;
            return string.substring(i);
        }
        return "0";
    }
}

