/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.Converter;
import com.ibm.as400.access.JobCCSIDNative;
import com.ibm.as400.access.NativeException;
import com.ibm.as400.access.NativeMethods;
import com.ibm.as400.access.SSLOptions;
import com.ibm.as400.access.SocketContainer;
import com.ibm.as400.access.Trace;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;

class SocketContainerUnix2
extends SocketContainer {
    private int sd_;
    private boolean closed_ = false;
    private Object lock_ = new Object();

    SocketContainerUnix2() {
    }

    void setProperties(Socket socket, String string, String string2, int n, SSLOptions sSLOptions) throws IOException {
        int n2 = 0;
        if (string.equalsIgnoreCase("as-central")) {
            n2 = 0;
        } else if (string.equalsIgnoreCase("as-dtaq")) {
            n2 = 1;
        } else if (string.equalsIgnoreCase("as-netprt")) {
            n2 = 2;
        } else if (string.equalsIgnoreCase("as-rmtcmd")) {
            n2 = 3;
        } else if (string.equalsIgnoreCase("as-signon")) {
            n2 = 4;
        } else if (string.equalsIgnoreCase("as-ddm")) {
            n2 = 8;
        }
        try {
            this.sd_ = NativeMethods.socketCreate(n2);
        }
        catch (NativeException nativeException) {
            throw SocketContainerUnix2.createSocketException(nativeException);
        }
    }

    void close() throws IOException {
        if (!this.closed_) {
            try {
                NativeMethods.socketClose(this.sd_);
                this.closed_ = true;
            }
            catch (NativeException nativeException) {
                throw SocketContainerUnix2.createSocketException(nativeException);
            }
        }
    }

    protected void finalize() throws IOException {
        this.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    InputStream getInputStream() throws IOException {
        Object object = this.lock_;
        synchronized (object) {
            return new SCUInputStream();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    OutputStream getOutputStream() throws IOException {
        Object object = this.lock_;
        synchronized (object) {
            return new SCUOutputStream();
        }
    }

    private static SocketException createSocketException(NativeException nativeException) {
        try {
            Trace.log(2, "Error with unix domain socket, errno: " + nativeException.errno_, (Throwable)nativeException);
            int n = JobCCSIDNative.retrieveCcsid();
            Converter converter = new Converter(n);
            return new SocketException(converter.byteArrayToString(nativeException.data));
        }
        catch (Throwable throwable) {
            return new SocketException();
        }
    }

    private final class SCUOutputStream
    extends OutputStream {
        private byte[] temp_ = new byte[1];

        private SCUOutputStream() {
        }

        public void write(int n) throws IOException {
            this.temp_[0] = (byte)n;
            this.write(this.temp_, 0, 1);
        }

        public void write(byte[] byArray) throws IOException {
            this.write(byArray, 0, byArray.length);
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            try {
                NativeMethods.socketWrite(SocketContainerUnix2.this.sd_, byArray, n, n2);
            }
            catch (NativeException nativeException) {
                throw SocketContainerUnix2.createSocketException(nativeException);
            }
        }

        public void close() throws IOException {
            SocketContainerUnix2.this.close();
        }
    }

    private final class SCUInputStream
    extends InputStream {
        private boolean eof_;
        private byte[] temp_ = new byte[1];

        private SCUInputStream() {
        }

        public int read(byte[] byArray) throws IOException {
            return this.read(byArray, 0, byArray.length);
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            if (this.eof_) {
                return -1;
            }
            try {
                int n3 = NativeMethods.socketRead(SocketContainerUnix2.this.sd_, byArray, n, n2);
                if (n3 <= 0) {
                    this.eof_ = true;
                    return -1;
                }
                return n3;
            }
            catch (NativeException nativeException) {
                throw SocketContainerUnix2.createSocketException(nativeException);
            }
        }

        public int read() throws IOException {
            if (this.eof_) {
                return -1;
            }
            int n = this.read(this.temp_, 0, 1);
            if (n <= 0) {
                return -1;
            }
            return this.temp_[0] & 0xFF;
        }

        public long skip(long l) throws IOException {
            int n;
            long l2;
            if (l <= 0L) {
                return 0L;
            }
            int n2 = (int)Math.min(1024L, l2);
            byte[] byArray = new byte[n2];
            for (l2 = l; l2 > 0L && (n = this.read(byArray, 0, (int)Math.min((long)n2, l2))) >= 0; l2 -= (long)n) {
            }
            return l - l2;
        }

        public int available() throws IOException {
            Object object = SocketContainerUnix2.this.lock_;
            synchronized (object) {
                try {
                    return NativeMethods.socketAvailable(SocketContainerUnix2.this.sd_);
                }
                catch (NativeException nativeException) {
                    throw SocketContainerUnix2.createSocketException(nativeException);
                }
            }
        }

        public void close() throws IOException {
            SocketContainerUnix2.this.close();
        }
    }
}

