/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.SystemProperties;
import com.ibm.as400.access.ToolboxLogger;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Date;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class Trace {
    private static final String copyright = "Copyright (C) 1997-2001 International Business Machines Corporation and others.";
    static boolean traceOn_;
    static boolean traceInfo_;
    static boolean traceWarning_;
    static boolean traceError_;
    static boolean traceDiagnostic_;
    static boolean traceDatastream_;
    static boolean traceConversion_;
    static boolean traceProxy_;
    static boolean traceThread_;
    static boolean traceJDBC_;
    static boolean tracePCML_;
    private static int lastTraceAction_;
    private static final int TURNED_TRACE_ON = 1;
    private static final int TURNED_TRACE_OFF = 2;
    private static boolean calledSetTraceCategory_;
    private static String fileName_;
    private static PrintWriter destination_;
    private static boolean userSpecifiedDestination_;
    private static Hashtable printWriterHash;
    private static Hashtable fileNameHash;
    public static final int DATASTREAM = 0;
    public static final int DIAGNOSTIC = 1;
    public static final int ERROR = 2;
    public static final int INFORMATION = 3;
    public static final int WARNING = 4;
    public static final int CONVERSION = 5;
    public static final int PROXY = 6;
    public static final int PCML = 7;
    public static final int JDBC = 8;
    public static final String LOGGER_NAME = "com.ibm.as400.access";
    private static ToolboxLogger logger_;
    private static boolean JDK14_OR_LATER;

    private Trace() {
    }

    public static String getFileName() {
        return fileName_;
    }

    public static String getFileName(Object object) {
        if (object == null) {
            throw new NullPointerException("component");
        }
        return (String)fileNameHash.get(object);
    }

    public static PrintWriter getPrintWriter() {
        return destination_;
    }

    public static PrintWriter getPrintWriter(Object object) {
        if (object == null) {
            throw new NullPointerException("component");
        }
        return (PrintWriter)printWriterHash.get(object);
    }

    public static final boolean isTraceAllOn() {
        return traceConversion_ && traceDatastream_ && traceDiagnostic_ && traceError_ && traceInfo_ && traceProxy_ && traceWarning_ && traceThread_ && traceJDBC_ && tracePCML_;
    }

    public static final boolean isTraceConversionOn() {
        return traceConversion_;
    }

    public static final boolean isTraceDatastreamOn() {
        return traceDatastream_;
    }

    public static final boolean isTraceDiagnosticOn() {
        return traceDiagnostic_;
    }

    public static final boolean isTraceErrorOn() {
        return traceError_;
    }

    public static final boolean isTraceInformationOn() {
        return traceInfo_;
    }

    public static final boolean isTraceJDBCOn() {
        return traceJDBC_;
    }

    public static final boolean isTraceOn() {
        return traceOn_;
    }

    public static final boolean isTracePCMLOn() {
        return tracePCML_;
    }

    public static final boolean isTraceProxyOn() {
        return traceProxy_;
    }

    public static final boolean isTraceThreadOn() {
        return traceThread_;
    }

    public static final boolean isTraceWarningOn() {
        return traceWarning_;
    }

    static void loadTraceProperties() {
        String string;
        block17: {
            Object object;
            String string2 = SystemProperties.getProperty("com.ibm.as400.access.Trace.category");
            if (string2 != null) {
                Trace.setTraceOn(true);
                object = new StringTokenizer(string2, ", ;");
                while (((StringTokenizer)object).hasMoreTokens()) {
                    string = ((StringTokenizer)object).nextToken();
                    if (string.equalsIgnoreCase("datastream")) {
                        Trace.setTraceDatastreamOn(true);
                        continue;
                    }
                    if (string.equalsIgnoreCase("diagnostic")) {
                        Trace.setTraceDiagnosticOn(true);
                        continue;
                    }
                    if (string.equalsIgnoreCase("error")) {
                        Trace.setTraceErrorOn(true);
                        continue;
                    }
                    if (string.equalsIgnoreCase("information")) {
                        Trace.setTraceInformationOn(true);
                        continue;
                    }
                    if (string.equalsIgnoreCase("warning")) {
                        Trace.setTraceWarningOn(true);
                        continue;
                    }
                    if (string.equalsIgnoreCase("conversion")) {
                        Trace.setTraceConversionOn(true);
                        continue;
                    }
                    if (string.equalsIgnoreCase("proxy")) {
                        Trace.setTraceProxyOn(true);
                        continue;
                    }
                    if (string.equalsIgnoreCase("thread")) {
                        Trace.setTraceThreadOn(true);
                        continue;
                    }
                    if (string.equalsIgnoreCase("jdbc")) {
                        Trace.setTraceJDBCOn(true);
                        continue;
                    }
                    if (string.equalsIgnoreCase("pcml")) {
                        Trace.setTracePCMLOn(true);
                        continue;
                    }
                    if (string.equalsIgnoreCase("all")) {
                        Trace.setTraceAllOn(true);
                        continue;
                    }
                    if (!Trace.isTraceOn()) continue;
                    Trace.log(4, "Trace category not valid: " + string + ".");
                }
            }
            if ((object = SystemProperties.getProperty("com.ibm.as400.access.Trace.file")) != null) {
                try {
                    Trace.setFileName((String)object);
                    destination_.println("Toolbox for Java - Open Source Software, JTOpen 5.0, codebase 5722-JC1 V5R4M0.1");
                }
                catch (IOException iOException) {
                    if (!Trace.isTraceOn()) break block17;
                    Trace.log(4, "Trace file not valid: " + (String)object + ".", (Throwable)iOException);
                }
            }
        }
        if ((string = SystemProperties.getProperty("com.ibm.as400.access.Trace.enabled")) != null) {
            boolean bl;
            traceOn_ = bl = Boolean.valueOf(string).booleanValue();
        }
    }

    private static void logTimeStamp(Object object, PrintWriter printWriter) {
        if (object != null && object.toString() != null) {
            printWriter.print("[" + object.toString() + "]  ");
        }
        if (traceThread_) {
            printWriter.print(Thread.currentThread().toString());
            printWriter.print("  ");
        }
        printWriter.print(new Date().toString());
        printWriter.print("  ");
    }

    private static void logTimeStamp(Object object, StringBuffer stringBuffer) {
        if (object != null && object.toString() != null) {
            stringBuffer.append("[" + object.toString() + "]  ");
        }
        if (traceThread_) {
            stringBuffer.append(Thread.currentThread().toString());
            stringBuffer.append("  ");
        }
        stringBuffer.append(new Date().toString());
        stringBuffer.append("  ");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void logData(Object object, int n, String string, Throwable throwable) {
        if (traceOn_ && Trace.traceCategory(n) || Trace.findLogger() && logger_.isLoggable(n)) {
            if (logger_ == null || userSpecifiedDestination_) {
                PrintWriter printWriter = destination_;
                synchronized (printWriter) {
                    if (object != null && Trace.getFileName(object) != null) {
                        Trace.logTimeStamp(object, destination_);
                        destination_.println(string);
                    } else if (object == null) {
                        Trace.logTimeStamp(null, destination_);
                        destination_.println(string);
                    }
                    if (throwable != null) {
                        throwable.printStackTrace(destination_);
                    } else if (n == 2) {
                        new Throwable().printStackTrace(destination_);
                    }
                }
                if (object != null) {
                    printWriter = (PrintWriter)printWriterHash.get(object);
                    if (printWriter == null) {
                        printWriter = new PrintWriter(System.out, true);
                        printWriterHash.put(object, printWriter);
                    }
                    PrintWriter printWriter2 = printWriter;
                    synchronized (printWriter2) {
                        Trace.logTimeStamp(object, printWriter);
                        printWriter.println(string);
                        if (throwable != null) {
                            throwable.printStackTrace(printWriter);
                        } else if (n == 2) {
                            new Throwable().printStackTrace(printWriter);
                        }
                    }
                }
            } else {
                StringBuffer stringBuffer = new StringBuffer();
                Trace.logTimeStamp(object, stringBuffer);
                stringBuffer.append(string);
                if (throwable != null) {
                    logger_.log(n, stringBuffer.toString(), throwable);
                } else if (n == 2) {
                    logger_.log(n, stringBuffer.toString(), new Throwable());
                } else {
                    logger_.log(n, stringBuffer.toString());
                }
            }
        }
    }

    public static final void log(int n, String string) {
        if (string == null) {
            throw new NullPointerException("message");
        }
        Trace.logData(null, n, string, null);
    }

    public static final void log(Object object, int n, String string) {
        if (string == null) {
            throw new NullPointerException("message");
        }
        if (object == null) {
            throw new NullPointerException("component");
        }
        Trace.logData(object, n, string, null);
    }

    public static final void log(int n, String string, Throwable throwable) {
        if (string == null) {
            throw new NullPointerException("message");
        }
        if (throwable == null) {
            throw new NullPointerException("e");
        }
        Trace.logData(null, n, string, throwable);
    }

    public static final void log(Object object, int n, String string, Throwable throwable) {
        if (string == null) {
            throw new NullPointerException("message");
        }
        if (throwable == null) {
            throw new NullPointerException("e");
        }
        if (object == null) {
            throw new NullPointerException("component");
        }
        Trace.logData(object, n, string, throwable);
    }

    public static final void log(int n, Throwable throwable) {
        if (throwable.getLocalizedMessage() == null) {
            Trace.log(n, "Exception does not contain a message.", throwable);
        } else {
            Trace.log(n, throwable.getLocalizedMessage(), throwable);
        }
    }

    public static final void log(Object object, int n, Throwable throwable) {
        if (throwable.getLocalizedMessage() == null) {
            Trace.log(object, n, "Exception does not contain a message.", throwable);
        } else {
            Trace.log(object, n, throwable.getLocalizedMessage(), throwable);
        }
    }

    public static final void log(int n, String string, int n2) {
        if (string == null) {
            throw new NullPointerException("message");
        }
        Trace.log(n, string + "  " + n2);
    }

    public static final void log(Object object, int n, String string, int n2) {
        if (string == null) {
            throw new NullPointerException("message");
        }
        Trace.log(object, n, string + "  " + n2);
    }

    static final void logSSL(int n, int n2, int n3, int n4) {
        Trace.log(2, "An SSLException occurred, turn on DIAGNOSITC tracing to see the details.");
        Trace.log(n, "SSL Category: " + n2);
        Trace.log(n, "SSL Error: " + n3);
        Trace.log(n, "SSL Int1: " + n4);
    }

    public static final void log(int n, String string, boolean bl) {
        if (string == null) {
            throw new NullPointerException("message");
        }
        Trace.log(n, string + "  " + bl);
    }

    public static final void log(Object object, int n, String string, boolean bl) {
        if (string == null) {
            throw new NullPointerException("message");
        }
        Trace.log(object, n, string + "  " + bl);
    }

    public static final void log(int n, String string, byte[] byArray) {
        if (byArray == null) {
            if (string == null) {
                throw new NullPointerException("message");
            }
            Trace.log(n, string + "  " + byArray);
        } else {
            Trace.log(n, string, byArray, 0, byArray.length);
        }
    }

    public static final void log(Object object, int n, String string, byte[] byArray) {
        if (byArray == null) {
            if (string == null) {
                throw new NullPointerException("message");
            }
            Trace.log(object, n, string + "  " + byArray);
        } else {
            Trace.log(object, n, string, byArray, 0, byArray.length);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void log(int n, String string, byte[] byArray, int n2, int n3) {
        if (string == null) {
            throw new NullPointerException("message");
        }
        if (byArray == null) {
            throw new NullPointerException("data");
        }
        if (traceOn_ && Trace.traceCategory(n) || Trace.findLogger() && logger_.isLoggable(n)) {
            if (logger_ == null || userSpecifiedDestination_) {
                PrintWriter printWriter = destination_;
                synchronized (printWriter) {
                    Trace.logTimeStamp(null, destination_);
                    destination_.println(string);
                    Trace.printByteArray(destination_, byArray, n2, n3);
                    if (n == 2) {
                        new Throwable().printStackTrace(destination_);
                    }
                }
            } else {
                StringBuffer stringBuffer = new StringBuffer();
                Trace.logTimeStamp(null, stringBuffer);
                Trace.printByteArray(stringBuffer, byArray, n2, n3);
                if (n == 2) {
                    logger_.log(n, stringBuffer.toString(), new Throwable());
                } else {
                    logger_.log(n, stringBuffer.toString());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void log(Object object, int n, String string, byte[] byArray, int n2, int n3) {
        if (string == null) {
            throw new NullPointerException("message");
        }
        if (byArray == null) {
            throw new NullPointerException("data");
        }
        if (object == null) {
            throw new NullPointerException("category");
        }
        if (traceOn_ && Trace.traceCategory(n) || Trace.findLogger() && logger_.isLoggable(n)) {
            if (logger_ == null || userSpecifiedDestination_) {
                PrintWriter printWriter = (PrintWriter)printWriterHash.get(object);
                if (printWriter == null) {
                    printWriter = new PrintWriter(System.out, true);
                    printWriterHash.put(object, printWriter);
                }
                PrintWriter printWriter2 = printWriter;
                synchronized (printWriter2) {
                    Trace.logTimeStamp(object, printWriter);
                    printWriter.println(string);
                    Trace.printByteArray(printWriter, byArray, n2, n3);
                    if (n == 2) {
                        new Throwable().printStackTrace(printWriter);
                    }
                }
            }
            Trace.log(n, string, byArray, n2, n3);
        }
    }

    private static void printByteArray(PrintWriter printWriter, byte[] byArray, int n, int n2) {
        int n3 = 0;
        while (n3 < n2) {
            int n4 = byArray[n] >>> 4 & 0xF;
            int n5 = byArray[n] & 0xF;
            char c = n4 < 10 ? (char)(48 + n4) : (char)(n4 - 10 + 65);
            char c2 = n5 < 10 ? (char)(48 + n5) : (char)(n5 - 10 + 65);
            printWriter.print(c);
            printWriter.print(c2);
            printWriter.print(" ");
            if ((n3 & 0xF) == 15) {
                printWriter.println();
            }
            ++n3;
            ++n;
        }
        if ((n2 - 1 & 0xF) != 15) {
            printWriter.println();
        }
    }

    private static void printByteArray(StringBuffer stringBuffer, byte[] byArray, int n, int n2) {
        int n3 = 0;
        while (n3 < n2) {
            int n4 = byArray[n] >>> 4 & 0xF;
            int n5 = byArray[n] & 0xF;
            char c = n4 < 10 ? (char)(48 + n4) : (char)(n4 - 10 + 65);
            char c2 = n5 < 10 ? (char)(48 + n5) : (char)(n5 - 10 + 65);
            stringBuffer.append(c);
            stringBuffer.append(c2);
            stringBuffer.append(" ");
            if ((n3 & 0xF) == 15) {
                stringBuffer.append("\n");
            }
            ++n3;
            ++n;
        }
        if ((n2 - 1 & 0xF) != 15) {
            stringBuffer.append("\n");
        }
    }

    public static void setTraceAllOn(boolean bl) {
        traceConversion_ = bl;
        traceDatastream_ = bl;
        traceDiagnostic_ = bl;
        traceError_ = bl;
        traceInfo_ = bl;
        traceJDBC_ = bl;
        tracePCML_ = bl;
        traceProxy_ = bl;
        traceThread_ = bl;
        traceWarning_ = bl;
        calledSetTraceCategory_ = true;
        if (Trace.findLogger()) {
            logger_.setLevel();
        }
    }

    public static void setTraceConversionOn(boolean bl) {
        traceConversion_ = bl;
        calledSetTraceCategory_ = true;
        if (Trace.findLogger()) {
            logger_.setLevel();
        }
    }

    public static void setTraceDatastreamOn(boolean bl) {
        traceDatastream_ = bl;
        calledSetTraceCategory_ = true;
        if (Trace.findLogger()) {
            logger_.setLevel();
        }
    }

    public static void setTraceDiagnosticOn(boolean bl) {
        traceDiagnostic_ = bl;
        calledSetTraceCategory_ = true;
        if (Trace.findLogger()) {
            logger_.setLevel();
        }
    }

    public static void setTraceErrorOn(boolean bl) {
        traceError_ = bl;
        calledSetTraceCategory_ = true;
        if (Trace.findLogger()) {
            logger_.setLevel();
        }
    }

    public static synchronized void setFileName(String string) throws IOException {
        destination_.flush();
        if (string != null) {
            File file = new File(string);
            FileOutputStream fileOutputStream = new FileOutputStream(string, file.exists());
            destination_ = new PrintWriter(fileOutputStream, true);
            userSpecifiedDestination_ = true;
            fileName_ = string;
        } else {
            destination_.close();
            fileName_ = null;
            destination_ = new PrintWriter(System.out, true);
            userSpecifiedDestination_ = false;
        }
    }

    public static synchronized void setFileName(Object object, String string) throws IOException {
        String string2;
        if (object == null) {
            throw new NullPointerException("component");
        }
        PrintWriter printWriter = (PrintWriter)printWriterHash.remove(object);
        if (printWriter != null) {
            printWriter.flush();
        }
        if ((string2 = (String)fileNameHash.remove(object)) != null) {
            printWriter.close();
        }
        if (string != null) {
            File file = new File(string);
            FileOutputStream fileOutputStream = new FileOutputStream(string, file.exists());
            fileNameHash.put(object, string);
            printWriter = new PrintWriter(fileOutputStream, true);
            printWriterHash.put(object, printWriter);
        } else {
            printWriter = new PrintWriter(System.out, true);
            printWriterHash.put(object, printWriter);
        }
    }

    public static synchronized void setPrintWriter(PrintWriter printWriter) throws IOException {
        destination_.flush();
        if (fileName_ != null) {
            destination_.close();
            fileName_ = null;
        }
        if (printWriter != null) {
            destination_ = printWriter;
            userSpecifiedDestination_ = true;
        } else {
            destination_ = new PrintWriter(System.out, true);
            userSpecifiedDestination_ = false;
        }
    }

    public static synchronized void setPrintWriter(Object object, PrintWriter printWriter) throws IOException {
        String string;
        if (object == null) {
            throw new NullPointerException("component");
        }
        PrintWriter printWriter2 = (PrintWriter)printWriterHash.remove(object);
        if (printWriter2 != null) {
            printWriter2.flush();
        }
        if ((string = (String)fileNameHash.remove(object)) != null) {
            printWriter2.close();
        }
        printWriter2 = printWriter != null ? printWriter : new PrintWriter(System.out, true);
        printWriterHash.put(object, printWriter2);
    }

    public static void setTraceInformationOn(boolean bl) {
        traceInfo_ = bl;
        calledSetTraceCategory_ = true;
        if (Trace.findLogger()) {
            logger_.setLevel();
        }
    }

    public static void setTraceJDBCOn(boolean bl) {
        traceJDBC_ = bl;
        calledSetTraceCategory_ = true;
        if (Trace.findLogger()) {
            logger_.setLevel();
        }
    }

    private static boolean findLogger() {
        if (logger_ == null && JDK14_OR_LATER && (logger_ = ToolboxLogger.getLogger()) != null) {
            logger_.info("Toolbox for Java - Open Source Software, JTOpen 5.0, codebase 5722-JC1 V5R4M0.1");
            if (!logger_.isLoggingOff() && lastTraceAction_ != 2) {
                traceOn_ = true;
            }
        }
        return logger_ != null;
    }

    public static void setTraceOn(boolean bl) {
        traceOn_ = bl;
        lastTraceAction_ = bl ? 1 : 2;
        Trace.findLogger();
        if (traceOn_ && (logger_ == null || userSpecifiedDestination_)) {
            destination_.println("Toolbox for Java - Open Source Software, JTOpen 5.0, codebase 5722-JC1 V5R4M0.1");
        }
        if (logger_ != null && calledSetTraceCategory_) {
            logger_.setLevel();
            logger_.config("Toolbox for Java - Open Source Software, JTOpen 5.0, codebase 5722-JC1 V5R4M0.1");
        }
    }

    public static void setTracePCMLOn(boolean bl) {
        tracePCML_ = bl;
        calledSetTraceCategory_ = true;
        if (Trace.findLogger()) {
            logger_.setLevel();
        }
    }

    public static void setTraceProxyOn(boolean bl) {
        traceProxy_ = bl;
        calledSetTraceCategory_ = true;
        if (Trace.findLogger()) {
            logger_.setLevel();
        }
    }

    public static void setTraceThreadOn(boolean bl) {
        traceThread_ = bl;
        calledSetTraceCategory_ = true;
        if (Trace.findLogger()) {
            logger_.setLevel();
        }
    }

    public static void setTraceWarningOn(boolean bl) {
        traceWarning_ = bl;
        calledSetTraceCategory_ = true;
        if (Trace.findLogger()) {
            logger_.setLevel();
        }
    }

    private static boolean traceCategory(int n) {
        boolean bl = false;
        switch (n) {
            case 3: {
                bl = traceInfo_;
                break;
            }
            case 4: {
                bl = traceWarning_;
                break;
            }
            case 2: {
                bl = traceError_;
                break;
            }
            case 1: {
                bl = traceDiagnostic_;
                break;
            }
            case 0: {
                bl = traceDatastream_;
                break;
            }
            case 5: {
                bl = traceConversion_;
                break;
            }
            case 6: {
                bl = traceProxy_;
                break;
            }
            case 7: {
                bl = tracePCML_;
                break;
            }
            case 8: {
                bl = traceJDBC_;
                break;
            }
            default: {
                throw new ExtendedIllegalArgumentException("category (" + Integer.toString(n) + ")", 2);
            }
        }
        return bl;
    }

    static {
        calledSetTraceCategory_ = false;
        fileName_ = null;
        destination_ = new PrintWriter(System.out, true);
        userSpecifiedDestination_ = false;
        printWriterHash = new Hashtable();
        fileNameHash = new Hashtable();
        logger_ = null;
        JDK14_OR_LATER = false;
        try {
            Class.forName("java.util.logging.LogManager");
            JDK14_OR_LATER = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        Trace.loadTraceProperties();
    }
}

