/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.data;

import com.ibm.as400.access.Trace;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;

public class PcmlMessageLog {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    private static String m_logFileName = null;
    private static OutputStream m_outputStream;
    private static PrintWriter m_logTarget;
    private static boolean m_traceEnabled;
    private static String m_hexDigits;
    private static StringBuffer m_cp37Table;

    static void main(String[] stringArray) throws IOException {
        PcmlMessageLog.logError("This is a test error to the console");
        PcmlMessageLog.traceOut("Message to stdout");
        PcmlMessageLog.traceErr("Message to stderr");
        PcmlMessageLog.traceOut("Test dump of byte array: " + PcmlMessageLog.byteArrayToHexString(new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32}));
        byte[] byArray = new byte[256];
        for (int n = -128; n < 127; n = (int)((byte)(n + 1))) {
            byArray[n - -128] = n;
        }
        byArray[255] = 127;
        PcmlMessageLog.dumpBytes(byArray);
        PcmlMessageLog.setLogFileName("pcml.log");
        PcmlMessageLog.logError("This is a test error to pcml.log");
        PcmlMessageLog.setLogStream(new FileOutputStream("user.log"));
        PcmlMessageLog.logError("This is a test error to user.log with throwable", new IllegalArgumentException("test exception"));
        PcmlMessageLog.setLogFileName(null);
        PcmlMessageLog.logError("This is a test error back to the console");
        PcmlMessageLog.setTraceEnabled(false);
        PcmlMessageLog.traceOut("Message to stdout should not be sent");
        PcmlMessageLog.traceErr("Message to stderr should not be sent");
        System.out.println("Test complete!");
    }

    private PcmlMessageLog() {
    }

    public static void setLogFileName(String string) throws IOException {
        m_logFileName = string;
        Trace.setFileName(string);
    }

    public static String getLogFileName() {
        return m_logFileName;
    }

    public static void setLogStream(OutputStream outputStream) {
        m_logFileName = null;
        if (outputStream != null) {
            m_outputStream = outputStream;
            m_logTarget = new PrintWriter(m_outputStream, true);
        } else {
            m_outputStream = System.err;
            m_logTarget = new PrintWriter(System.err, true);
        }
        try {
            Trace.setPrintWriter(m_logTarget);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static OutputStream getLogStream() {
        return m_outputStream;
    }

    public static void logError(Object object) {
        Trace.log(2, object.toString());
    }

    public static void logError(Object object, Throwable throwable) {
        Trace.log(2, object.toString(), throwable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void printStackTrace(Throwable throwable) {
        PrintWriter printWriter = m_logTarget;
        synchronized (printWriter) {
            m_logTarget.println("Stack trace:");
            throwable.printStackTrace(m_logTarget);
        }
    }

    public static void setTraceEnabled(boolean bl) {
        Trace.setTracePCMLOn(bl);
        if (bl) {
            Trace.setTraceOn(bl);
        }
    }

    public static boolean isTraceEnabled() {
        return Trace.isTracePCMLOn();
    }

    public static void traceOut(Object object) {
        if (m_traceEnabled) {
            System.out.println(object);
        }
    }

    public static void traceErr(Object object) {
        if (m_traceEnabled) {
            System.err.println(object);
        }
    }

    static void traceParameter(String string, String string2, byte[] byArray) {
        if (Trace.isTracePCMLOn()) {
            Trace.log(7, string + "\t  " + string2);
            PcmlMessageLog.dumpBytes(byArray);
        }
    }

    private static void dumpBytes(byte[] byArray) {
        int n;
        if (byArray == null) {
            return;
        }
        int n2 = byArray.length;
        String string = "";
        String string2 = "";
        for (n = 0; n < n2; n += 4) {
            if (n % 32 == 0) {
                if (n == 0) {
                    Trace.log(7, "Offset : 0....... 4....... 8....... C....... 0....... 4....... 8....... C.......   0...4...8...C...0...4...8...C...");
                } else {
                    string2 = string2 + " *" + string + "*";
                    Trace.log(7, string2);
                    string = "";
                    string2 = "";
                }
                String string3 = "      " + Integer.toHexString(n);
                string3 = string3.substring(string3.length() - 6);
                string2 = string2 + string3 + " : ";
            }
            string2 = string2 + PcmlMessageLog.byteArrayToHexString(byArray, n, 4) + " ";
            string = string + PcmlMessageLog.byteArrayToCP37String(byArray, n, 4);
        }
        if (n > 0) {
            for (int i = n2; i < n; ++i) {
                string2 = string2 + "  ";
                string = string + " ";
            }
            while (n % 32 != 0) {
                string2 = string2 + "         ";
                string = string + "    ";
                n += 4;
            }
            string2 = string2 + " *" + string + "*";
            Trace.log(7, string2);
            string2 = "";
            string = "";
        }
    }

    private static String byteArrayToCP37String(byte[] byArray, int n, int n2) {
        if (byArray == null) {
            return "";
        }
        int n3 = byArray.length;
        if (n3 == 0 || n < 0 || n >= n3) {
            return "";
        }
        int n4 = n + n2 <= n3 ? n + n2 - 1 : n3 - 1;
        StringBuffer stringBuffer = new StringBuffer(n4 - n + 1);
        for (int i = n; i <= n4; ++i) {
            if (byArray[i] < 0) {
                stringBuffer.append(m_cp37Table.charAt(256 + byArray[i]));
                continue;
            }
            stringBuffer.append(m_cp37Table.charAt(byArray[i]));
        }
        return stringBuffer.toString();
    }

    static String byteArrayToHexString(byte[] byArray) {
        if (byArray == null) {
            return "";
        }
        return PcmlMessageLog.byteArrayToHexString(byArray, 0, byArray.length);
    }

    static String byteArrayToHexString(byte[] byArray, int n, int n2) {
        if (byArray == null) {
            return "";
        }
        int n3 = byArray.length;
        if (n3 == 0 || n < 0 || n >= n3) {
            return "";
        }
        int n4 = n + n2 <= n3 ? n + n2 - 1 : n3 - 1;
        StringBuffer stringBuffer = new StringBuffer((n4 - n + 1) * 2);
        for (int i = n; i <= n4; ++i) {
            stringBuffer.append(PcmlMessageLog.byteToHexString(byArray[i]));
        }
        return stringBuffer.toString();
    }

    private static String byteToHexString(byte by) {
        int n = by << 24 >>> 28;
        int n2 = by << 28 >>> 28;
        return m_hexDigits.substring(n, n + 1) + m_hexDigits.substring(n2, n2 + 1);
    }

    static {
        m_traceEnabled = false;
        m_hexDigits = "0123456789ABCDEF";
        m_cp37Table = new StringBuffer(256);
        for (int i = 0; i < 256; ++i) {
            m_cp37Table.append('.');
        }
        m_cp37Table.setCharAt(64, ' ');
        m_cp37Table.setCharAt(75, '.');
        m_cp37Table.setCharAt(76, '<');
        m_cp37Table.setCharAt(77, '(');
        m_cp37Table.setCharAt(78, '+');
        m_cp37Table.setCharAt(80, '&');
        m_cp37Table.setCharAt(90, '!');
        m_cp37Table.setCharAt(91, '$');
        m_cp37Table.setCharAt(92, '*');
        m_cp37Table.setCharAt(93, ')');
        m_cp37Table.setCharAt(94, ';');
        m_cp37Table.setCharAt(96, '-');
        m_cp37Table.setCharAt(97, '/');
        m_cp37Table.setCharAt(106, '|');
        m_cp37Table.setCharAt(107, ',');
        m_cp37Table.setCharAt(108, '%');
        m_cp37Table.setCharAt(109, '_');
        m_cp37Table.setCharAt(110, '>');
        m_cp37Table.setCharAt(111, '?');
        m_cp37Table.setCharAt(121, '`');
        m_cp37Table.setCharAt(122, ':');
        m_cp37Table.setCharAt(123, '#');
        m_cp37Table.setCharAt(124, '@');
        m_cp37Table.setCharAt(125, '\'');
        m_cp37Table.setCharAt(126, '=');
        m_cp37Table.setCharAt(127, '\"');
        m_cp37Table.setCharAt(129, 'a');
        m_cp37Table.setCharAt(130, 'b');
        m_cp37Table.setCharAt(131, 'c');
        m_cp37Table.setCharAt(132, 'd');
        m_cp37Table.setCharAt(133, 'e');
        m_cp37Table.setCharAt(134, 'f');
        m_cp37Table.setCharAt(135, 'g');
        m_cp37Table.setCharAt(136, 'h');
        m_cp37Table.setCharAt(137, 'i');
        m_cp37Table.setCharAt(145, 'j');
        m_cp37Table.setCharAt(146, 'k');
        m_cp37Table.setCharAt(147, 'l');
        m_cp37Table.setCharAt(148, 'm');
        m_cp37Table.setCharAt(149, 'n');
        m_cp37Table.setCharAt(150, 'o');
        m_cp37Table.setCharAt(151, 'p');
        m_cp37Table.setCharAt(152, 'q');
        m_cp37Table.setCharAt(153, 'r');
        m_cp37Table.setCharAt(162, 's');
        m_cp37Table.setCharAt(163, 't');
        m_cp37Table.setCharAt(164, 'u');
        m_cp37Table.setCharAt(165, 'v');
        m_cp37Table.setCharAt(166, 'w');
        m_cp37Table.setCharAt(167, 'x');
        m_cp37Table.setCharAt(168, 'y');
        m_cp37Table.setCharAt(169, 'z');
        m_cp37Table.setCharAt(193, 'A');
        m_cp37Table.setCharAt(194, 'B');
        m_cp37Table.setCharAt(195, 'C');
        m_cp37Table.setCharAt(196, 'D');
        m_cp37Table.setCharAt(197, 'E');
        m_cp37Table.setCharAt(198, 'F');
        m_cp37Table.setCharAt(199, 'G');
        m_cp37Table.setCharAt(200, 'H');
        m_cp37Table.setCharAt(201, 'I');
        m_cp37Table.setCharAt(209, 'J');
        m_cp37Table.setCharAt(210, 'K');
        m_cp37Table.setCharAt(211, 'L');
        m_cp37Table.setCharAt(212, 'M');
        m_cp37Table.setCharAt(213, 'N');
        m_cp37Table.setCharAt(214, 'O');
        m_cp37Table.setCharAt(215, 'P');
        m_cp37Table.setCharAt(216, 'Q');
        m_cp37Table.setCharAt(217, 'R');
        m_cp37Table.setCharAt(226, 'S');
        m_cp37Table.setCharAt(227, 'T');
        m_cp37Table.setCharAt(228, 'U');
        m_cp37Table.setCharAt(229, 'V');
        m_cp37Table.setCharAt(230, 'W');
        m_cp37Table.setCharAt(231, 'X');
        m_cp37Table.setCharAt(232, 'Y');
        m_cp37Table.setCharAt(233, 'Z');
        m_cp37Table.setCharAt(240, '0');
        m_cp37Table.setCharAt(241, '1');
        m_cp37Table.setCharAt(242, '2');
        m_cp37Table.setCharAt(243, '3');
        m_cp37Table.setCharAt(244, '4');
        m_cp37Table.setCharAt(245, '5');
        m_cp37Table.setCharAt(246, '6');
        m_cp37Table.setCharAt(247, '7');
        m_cp37Table.setCharAt(248, '8');
        m_cp37Table.setCharAt(249, '9');
    }
}

