/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.data;

import com.ibm.as400.access.AS400DataType;
import com.ibm.as400.access.AS400Text;
import com.ibm.as400.access.Trace;
import com.ibm.as400.data.PcmlAttributeList;
import com.ibm.as400.data.PcmlDimensions;
import com.ibm.as400.data.PcmlDocNode;
import com.ibm.as400.data.PcmlDocument;
import com.ibm.as400.data.PcmlException;
import com.ibm.as400.data.PcmlNode;
import com.ibm.as400.data.RfmlRecordFormat;
import com.ibm.as400.data.XmlException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Enumeration;

class RfmlDocument
extends PcmlDocument {
    private static final String copyright = "Copyright (C) 1997-2002 International Business Machines Corporation and others.";
    static final long serialVersionUID = 5L;
    private static final String[] RFML_ATTRIBUTES = new String[]{"version", "ccsid"};
    private static final int DEFAULT_CCSID = 65535;
    private String m_Ccsid;
    private int m_CcsidInt;

    RfmlDocument(PcmlAttributeList pcmlAttributeList, String string) {
        super(pcmlAttributeList, string);
        this.setNodeType(5);
        this.setCcsid(this.getAttributeValue("ccsid"));
    }

    String[] getAttributeList() {
        return RFML_ATTRIBUTES;
    }

    public final String getCcsid() {
        return this.m_Ccsid;
    }

    public final int getCcsidInt() {
        if (this.m_CcsidInt == 0) {
            return 65535;
        }
        return this.m_CcsidInt;
    }

    protected AS400DataType getConverter(int n, int n2, int n3, int n4) throws PcmlException {
        if (n == 1) {
            if (n4 != this.m_CcsidInt) {
                return new AS400Text(n2, n4);
            }
            switch (n2) {
                case 1: {
                    if (this.m_Text_1 == null) {
                        this.m_Text_1 = new AS400Text(n2, n4);
                    }
                    return this.m_Text_1;
                }
                case 10: {
                    if (this.m_Text_10 == null) {
                        this.m_Text_10 = new AS400Text(n2, n4);
                    }
                    return this.m_Text_10;
                }
            }
            return new AS400Text(n2, n4);
        }
        return super.getConverter(n, n2, n3, n4);
    }

    synchronized double getDoubleValue(String string) throws PcmlException {
        return this.getDoubleValue(string, new PcmlDimensions());
    }

    synchronized double getDoubleValue(String string, PcmlDimensions pcmlDimensions) throws PcmlException {
        Object object = this.getValue(string, pcmlDimensions);
        if (object == null) {
            throw new PcmlException("INPUT_VALUE_NOT_SET", new Object[]{string});
        }
        if (object instanceof String) {
            return Double.parseDouble((String)object);
        }
        if (object instanceof Number) {
            return ((Number)object).doubleValue();
        }
        throw new PcmlException("STRING_OR_NUMBER", new Object[]{object.getClass().getName(), string});
    }

    RfmlRecordFormat getRecordFormatNode(String string) throws XmlException {
        PcmlNode pcmlNode = this.getElement(string);
        if (pcmlNode instanceof RfmlRecordFormat) {
            return (RfmlRecordFormat)pcmlNode;
        }
        if (pcmlNode == null) {
            throw new XmlException("ELEMENT_NOT_FOUND", new Object[]{string, "<recordformat>"});
        }
        throw new XmlException("WRONG_ELEMENT_TYPE", new Object[]{string, "<recordformat>"});
    }

    protected void setCcsid(String string) {
        if (string == null || string.equals("")) {
            this.m_Ccsid = null;
            this.m_CcsidInt = 0;
            return;
        }
        try {
            this.m_Ccsid = string;
            this.m_CcsidInt = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            this.m_Ccsid = null;
            this.m_CcsidInt = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void toXml(OutputStream outputStream) throws IOException, XmlException {
        PrintWriter printWriter = new PrintWriter(outputStream);
        try {
            printWriter.println("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>");
            printWriter.println("<!DOCTYPE rfml SYSTEM \"rfml.dtd\">");
            RfmlDocument.toXml(this, printWriter, "");
            if (printWriter.checkError()) {
                Trace.log(2, "Error when writing RFML to OutputStream.");
            }
        }
        finally {
            printWriter.close();
        }
    }

    private static void toXml(PcmlDocNode pcmlDocNode, PrintWriter printWriter, String string) throws IOException, XmlException {
        printWriter.print(string + "<" + pcmlDocNode.getTagName());
        String[] stringArray = pcmlDocNode.getAttributeList();
        for (int i = 0; i < stringArray.length; ++i) {
            if (pcmlDocNode.getAttributeValue(stringArray[i]) == null) continue;
            printWriter.print(" " + stringArray[i] + "=\"" + pcmlDocNode.getAttributeValue(stringArray[i]) + "\"");
        }
        if ((pcmlDocNode.getNodeType() != 4 || !pcmlDocNode.getAttributeValue("type").equals("struct")) && pcmlDocNode.hasChildren()) {
            printWriter.println(">");
            Enumeration enumeration = pcmlDocNode.getChildren();
            while (enumeration.hasMoreElements()) {
                PcmlDocNode pcmlDocNode2 = (PcmlDocNode)enumeration.nextElement();
                RfmlDocument.toXml(pcmlDocNode2, printWriter, string + "  ");
            }
            printWriter.println(string + "</" + pcmlDocNode.getTagName() + ">");
        } else {
            printWriter.println("/>");
        }
        printWriter.flush();
    }
}

