/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.resource;

import com.ibm.as400.access.Trace;
import com.ibm.as400.resource.Presentation;
import com.ibm.as400.resource.Resource;
import com.ibm.as400.resource.ResourceEvent;
import com.ibm.as400.resource.ResourceException;
import com.ibm.as400.resource.ResourceListener;
import com.ibm.as400.resource.ResourceMetaData;
import com.ibm.as400.resource.ResourceMetaDataTable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public abstract class ChangeableResource
extends Resource {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    static final long serialVersionUID = 4L;
    private transient Hashtable bufferedValues_;
    private transient Hashtable uncommittedChanges_;
    private transient Hashtable uncommittedChangeBidiStringTypes_;

    public ChangeableResource() {
        this.initializeTransient();
    }

    public ChangeableResource(Presentation presentation, Object object, ResourceMetaData[] resourceMetaDataArray) {
        super(presentation, object, resourceMetaDataArray);
        this.initializeTransient();
    }

    public ChangeableResource(Presentation presentation, Object object, ResourceMetaDataTable resourceMetaDataTable) {
        super(presentation, object, resourceMetaDataTable);
        this.initializeTransient();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelAttributeChanges() throws ResourceException {
        ChangeableResource changeableResource = this;
        synchronized (changeableResource) {
            this.uncommittedChanges_.clear();
        }
        this.fireAttributeChangesCanceled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commitAttributeChanges() throws ResourceException {
        this.fireBusy();
        try {
            int n;
            int n2 = this.uncommittedChanges_.size();
            Object[] objectArray = new Object[n2];
            Object[] objectArray2 = new Object[n2];
            int[] nArray = new int[n2];
            boolean bl = this.isBidiEnabled();
            Enumeration enumeration = this.uncommittedChanges_.keys();
            int n3 = 0;
            while (enumeration.hasMoreElements()) {
                objectArray[n3] = enumeration.nextElement();
                objectArray2[n3] = this.uncommittedChanges_.get(objectArray[n3]);
                if (bl) {
                    nArray[n3] = (Integer)this.uncommittedChangeBidiStringTypes_.get(objectArray[n3]);
                    if (nArray[n3] == -1) {
                        nArray[n3] = this.getDefaultBidiStringType();
                    }
                }
                ++n3;
            }
            for (n = 0; n < objectArray.length; ++n) {
                if (objectArray[n] == null) {
                    throw new NullPointerException("attributeIDs[" + n + "]");
                }
                ResourceMetaData resourceMetaData = this.validateAttributeID(objectArray[n]);
                if (resourceMetaData.isReadOnly()) {
                    Trace.log(2, "Attempted to set read-only attribute: " + objectArray[n]);
                    throw new ResourceException(8);
                }
                if (objectArray2[n] == null) {
                    throw new NullPointerException("values[" + n + "]");
                }
                objectArray2[n] = resourceMetaData.validateValue(objectArray2[n]);
            }
            if (bl) {
                this.commitAttributeChanges(objectArray, objectArray2, nArray);
            } else {
                this.commitAttributeChanges(objectArray, objectArray2);
            }
            for (n = 0; n < objectArray.length; ++n) {
                this.bufferedValues_.put(objectArray[n], objectArray2[n]);
            }
            this.uncommittedChanges_.clear();
            this.uncommittedChangeBidiStringTypes_.clear();
            this.fireAttributeChangesCommitted();
        }
        finally {
            this.fireIdle();
        }
    }

    protected void commitAttributeChanges(Object[] objectArray, Object[] objectArray2) throws ResourceException {
    }

    protected void commitAttributeChanges(Object[] objectArray, Object[] objectArray2, int[] nArray) throws ResourceException {
    }

    protected void fireAttributeChangesCanceled() {
        ResourceEvent resourceEvent = new ResourceEvent(this, 1);
        Vector vector = (Vector)this.resourceListeners_.clone();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            ((ResourceListener)enumeration.nextElement()).attributeChangesCanceled(resourceEvent);
        }
    }

    protected void fireAttributeChangesCommitted() {
        ResourceEvent resourceEvent = new ResourceEvent(this, 2);
        Vector vector = (Vector)this.resourceListeners_.clone();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            ((ResourceListener)enumeration.nextElement()).attributeChangesCommitted(resourceEvent);
        }
    }

    protected void fireAttributeValueChanged(Object object, Object object2) {
        ResourceEvent resourceEvent = new ResourceEvent(this, 4, object, object2);
        Vector vector = (Vector)this.resourceListeners_.clone();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            ((ResourceListener)enumeration.nextElement()).attributeValueChanged(resourceEvent);
        }
    }

    protected void fireResourceCreated() {
        ResourceEvent resourceEvent = new ResourceEvent(this, 5);
        Vector vector = (Vector)this.resourceListeners_.clone();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            ((ResourceListener)enumeration.nextElement()).resourceCreated(resourceEvent);
        }
    }

    protected void fireResourceDeleted() {
        ResourceEvent resourceEvent = new ResourceEvent(this, 6);
        Vector vector = (Vector)this.resourceListeners_.clone();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            ((ResourceListener)enumeration.nextElement()).resourceDeleted(resourceEvent);
        }
    }

    public Object getAttributeUnchangedValue(Object object) throws ResourceException {
        if (this.isBidiEnabled()) {
            return this.getAttributeUnchangedValue(object, this.getDefaultBidiStringType());
        }
        return this.getAttributeUnchangedValueImplementation(object, this.getDefaultBidiStringType());
    }

    public Object getAttributeUnchangedValue(Object object, int n) throws ResourceException {
        if (!this.isBidiEnabled()) {
            return this.getAttributeUnchangedValue(object);
        }
        return this.getAttributeUnchangedValueImplementation(object, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getAttributeUnchangedValueImplementation(Object object, int n) throws ResourceException {
        this.validateAttributeID(object);
        ChangeableResource changeableResource = this;
        synchronized (changeableResource) {
            if (this.bufferedValues_.containsKey(object)) {
                return this.bufferedValues_.get(object);
            }
            return super.getAttributeValueImplementation(object);
        }
    }

    public Object getAttributeValue(Object object) throws ResourceException {
        if (this.isBidiEnabled()) {
            return this.getAttributeValue(object, this.getDefaultBidiStringType());
        }
        return this.getAttributeValueImplementation(object, this.getDefaultBidiStringType());
    }

    public Object getAttributeValue(Object object, int n) throws ResourceException {
        if (!this.isBidiEnabled()) {
            return this.getAttributeValue(object);
        }
        return this.getAttributeValueImplementation(object, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getAttributeValueImplementation(Object object, int n) throws ResourceException {
        ChangeableResource changeableResource = this;
        synchronized (changeableResource) {
            if (this.uncommittedChanges_.containsKey(object)) {
                return this.uncommittedChanges_.get(object);
            }
            return this.getAttributeUnchangedValue(object, n);
        }
    }

    public boolean hasUncommittedAttributeChanges(Object object) {
        this.validateAttributeID(object);
        return this.uncommittedChanges_.containsKey(object);
    }

    protected void initializeAttributeValue(Object object, Object object2) {
        super.initializeAttributeValue(object, object2);
        this.bufferedValues_.put(object, object2);
    }

    private void initializeTransient() {
        this.uncommittedChanges_ = new Hashtable();
        this.uncommittedChangeBidiStringTypes_ = new Hashtable();
        this.bufferedValues_ = new Hashtable();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.initializeTransient();
    }

    public void refreshAttributeValues() throws ResourceException {
        this.bufferedValues_.clear();
        super.refreshAttributeValues();
    }

    public void setAttributeValue(Object object, Object object2) throws ResourceException {
        if (this.isBidiEnabled()) {
            this.setAttributeValue(object, object2, this.getDefaultBidiStringType());
        } else {
            this.setAttributeValueImplementation(object, object2, this.getDefaultBidiStringType());
        }
    }

    public void setAttributeValue(Object object, Object object2, int n) throws ResourceException {
        if (!this.isBidiEnabled()) {
            this.setAttributeValue(object, object2);
        } else {
            this.setAttributeValueImplementation(object, object2, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setAttributeValueImplementation(Object object, Object object2, int n) throws ResourceException {
        ResourceMetaData resourceMetaData;
        if (Trace.isTraceOn()) {
            Trace.log(1, "Setting attribute value " + object + " (for " + this + ") to " + object2 + "(" + object2.getClass() + "), bidi string type = " + n);
        }
        if ((resourceMetaData = this.validateAttributeID(object)).isReadOnly()) {
            Trace.log(2, "Attempted to set read-only attribute: " + object);
            throw new ResourceException(8);
        }
        if (object2 == null) {
            throw new NullPointerException("value");
        }
        object2 = resourceMetaData.validateValue(object2);
        ChangeableResource changeableResource = this;
        synchronized (changeableResource) {
            this.uncommittedChanges_.put(object, object2);
            this.uncommittedChangeBidiStringTypes_.put(object, new Integer(n));
        }
        this.fireAttributeValueChanged(object, object2);
    }
}

