/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.util;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400Message;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.Command;
import com.ibm.as400.access.CommandLineArguments;
import com.ibm.as400.access.CommandList;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.PanelGroup;
import com.ibm.as400.access.QSYSObjectPathName;
import com.ibm.as400.access.Trace;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Hashtable;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.xml.sax.SAXException;

public class CommandHelpRetriever {
    private static final String copyright = "Copyright (C) 1997-2002 International Business Machines Corporation and others.";
    private boolean debug_ = false;
    private static Templates htmlTemplate_;
    private static Templates uimTemplate_;
    private static URIResolver defaultResolver_;
    private static String library_;
    private static String command_;
    private boolean showChoices_ = false;
    private String outputDirectory_ = ".";
    private Transformer htmlTransformer_;
    private Transformer uimTransformer_;
    private final HelpResolver resolver_ = new HelpResolver();
    private static final String[] mriHTMLTags_;
    private static final String[] mriUIMTags_;
    private static final String[][] transformedHTMLParms_;
    private static String[][] transformedUIMParms_;
    private static boolean genUIM_;
    private static boolean genHTML_;
    static /* synthetic */ Class class$com$ibm$as400$util$CommandHelpRetriever;

    public static void main(String[] stringArray) {
        PrintWriter printWriter = new PrintWriter(System.out, true);
        if (stringArray.length == 0) {
            printWriter.println();
            CommandHelpRetriever.usage();
        }
        try {
            CommandHelpRetriever commandHelpRetriever = new CommandHelpRetriever();
            AS400 aS400 = CommandHelpRetriever.parseParms(stringArray, commandHelpRetriever);
            CommandList commandList = new CommandList(aS400, library_, command_);
            Command[] commandArray = commandList.generateList();
            File file = new File(commandHelpRetriever.outputDirectory_);
            boolean bl = file.isDirectory();
            if (!bl && commandArray.length > 1) {
                if (Trace.isTraceOn()) {
                    Trace.log(1, "The output parameter cannot be a file when a wildcard command is specified");
                }
                throw new ExtendedIllegalArgumentException("output", 2);
            }
            for (int i = 0; i < commandArray.length; ++i) {
                try {
                    String string;
                    Object object;
                    File file2;
                    String string2;
                    if (genHTML_) {
                        string2 = commandHelpRetriever.generateHTML(commandArray[i]);
                        file2 = null;
                        if (bl) {
                            object = new QSYSObjectPathName(commandArray[i].getPath());
                            string = ((QSYSObjectPathName)object).getLibraryName() + "_" + ((QSYSObjectPathName)object).getObjectName() + ".html";
                            file2 = new File(file, string);
                        } else {
                            file2 = file;
                        }
                        object = new FileWriter(file2);
                        ((Writer)object).write(string2);
                        ((OutputStreamWriter)object).close();
                    }
                    if (!genUIM_) continue;
                    string2 = commandHelpRetriever.generateUIM(commandArray[i]);
                    file2 = null;
                    if (bl) {
                        object = new QSYSObjectPathName(commandArray[i].getPath());
                        string = ((QSYSObjectPathName)object).getLibraryName() + "_" + ((QSYSObjectPathName)object).getObjectName() + ".uim";
                        file2 = new File(file, string);
                    } else {
                        file2 = file;
                    }
                    object = new FileWriter(file2);
                    ((Writer)object).write(string2);
                    ((OutputStreamWriter)object).close();
                    continue;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static final String encode(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = string.toCharArray();
        block6: for (int i = 0; i < cArray.length; ++i) {
            switch (cArray[i]) {
                case '\"': {
                    stringBuffer.append("&quot;");
                    continue block6;
                }
                case '&': {
                    stringBuffer.append("&amp;");
                    continue block6;
                }
                case '<': {
                    stringBuffer.append("&lt;");
                    continue block6;
                }
                case '>': {
                    stringBuffer.append("&gt;");
                    continue block6;
                }
                default: {
                    stringBuffer.append(cArray[i]);
                }
            }
        }
        return stringBuffer.toString();
    }

    private static final String encodeAmp(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] == '&') {
                stringBuffer.append("&amp;");
                continue;
            }
            stringBuffer.append(cArray[i]);
        }
        return stringBuffer.toString();
    }

    public synchronized String generateHTML(Command command) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, ObjectDoesNotExistException, SAXException, ParserConfigurationException, TransformerConfigurationException, TransformerException {
        if (command == null) {
            throw new NullPointerException("command");
        }
        return this.generate(command, null);
    }

    public synchronized String generateHTML(Command command, PanelGroup panelGroup) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, ObjectDoesNotExistException, SAXException, ParserConfigurationException, TransformerConfigurationException, TransformerException {
        if (command == null) {
            throw new NullPointerException("command");
        }
        if (panelGroup == null) {
            throw new NullPointerException("panelGroup");
        }
        return this.generate(command, panelGroup);
    }

    public synchronized byte[] generateHTMLBytes(Command command, PanelGroup panelGroup) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, ObjectDoesNotExistException, SAXException, ParserConfigurationException, TransformerConfigurationException, TransformerException {
        if (command == null) {
            throw new NullPointerException("command");
        }
        return this.generate(command, panelGroup).getBytes("UTF-8");
    }

    private synchronized String generate(Command command, PanelGroup panelGroup) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, ObjectDoesNotExistException, SAXException, ParserConfigurationException, TransformerConfigurationException, TransformerException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        String string;
        Object object5;
        String string2;
        String string3;
        block17: {
            block16: {
                if (Trace.isTraceOn()) {
                    Trace.log(1, "Generating HTML documentation for '" + command + "' and panel group '" + panelGroup + "'.");
                }
                string3 = command.getXML();
                if (this.debug_) {
                    string2 = command.getPath();
                    object5 = new QSYSObjectPathName(string2);
                    string = ((QSYSObjectPathName)object5).getLibraryName();
                    object4 = ((QSYSObjectPathName)object5).getObjectName();
                    object3 = new File(this.outputDirectory_);
                    boolean bl = ((File)object3).isDirectory();
                    object2 = null;
                    object2 = bl ? new File((File)object3, string + "_" + (String)object4 + "_XML.xml") : new File(this.outputDirectory_ + "_XML.xml");
                    object = new FileWriter((File)object2);
                    ((Writer)object).write(string3);
                    ((OutputStreamWriter)object).flush();
                    ((OutputStreamWriter)object).close();
                }
                if (Trace.isTraceOn()) {
                    Trace.log(1, "Retrieved command XML:\n" + string3 + "\n");
                }
                string2 = null;
                object5 = null;
                try {
                    switch (command.getThreadSafety()) {
                        case -16: {
                            string2 = "0";
                            break;
                        }
                        case -15: {
                            string2 = "1";
                            break;
                        }
                        case -14: {
                            string2 = "2";
                            break;
                        }
                    }
                    object5 = command.getWhereAllowedToRun();
                }
                catch (AS400Exception aS400Exception) {
                    object4 = aS400Exception.getAS400MessageList();
                    if (((AS400Message[])object4).length == 1 && object4[0].getID().toUpperCase().trim().equals("CPF6250")) break block16;
                    throw new AS400Exception((AS400Message[])object4);
                }
            }
            if (Trace.isTraceOn()) {
                Trace.log(1, "Using command threadsafety = " + string2 + " and where allowed to run = " + (String)object5 + ".");
            }
            string = null;
            try {
                string = panelGroup == null ? command.getXMLHelpText() : command.getXMLHelpText(panelGroup);
            }
            catch (AS400Exception aS400Exception) {
                object3 = aS400Exception.getAS400MessageList();
                if (((AS400Message[])object3).length == 1 && object3[0].getID().toUpperCase().trim().equals("CPF6250")) break block17;
                throw new AS400Exception((AS400Message[])object3);
            }
        }
        if (this.debug_ && string != null) {
            object4 = command.getPath();
            object3 = new QSYSObjectPathName((String)object4);
            String string4 = ((QSYSObjectPathName)object3).getLibraryName();
            object2 = ((QSYSObjectPathName)object3).getObjectName();
            object = new File(this.outputDirectory_);
            boolean bl = ((File)object).isDirectory();
            File file = null;
            file = bl ? new File((File)object, string4 + "_" + (String)object2 + "_HTMLHelp.html") : new File(this.outputDirectory_ + "_HTMLHelp.html");
            FileWriter fileWriter = new FileWriter(file);
            fileWriter.write(string);
            fileWriter.flush();
            fileWriter.close();
        }
        this.setupHTMLTransformer(command.getSystem().getLocale());
        this.htmlTransformer_.setParameter("CommandHelp", string == null || string.trim().length() == 0 ? "__NO_HELP" : "myCommandHelpResolver");
        this.htmlTransformer_.setParameter("ShowChoicePgmValues", this.showChoices_ ? "1" : "0");
        this.htmlTransformer_.setParameter("ThreadSafe", string2 == null ? "0" : string2);
        this.htmlTransformer_.setParameter("WhereAllowed", object5 == null ? "000000000000000" : object5);
        this.resolver_.helpResults_ = string;
        object4 = new StreamSource(new StringReader(string3));
        object3 = new StringWriter();
        StreamResult streamResult = new StreamResult((Writer)object3);
        if (Trace.isTraceOn()) {
            Trace.log(1, "Performing XSL transform.");
        }
        this.htmlTransformer_.transform((Source)object4, streamResult);
        if (Trace.isTraceOn()) {
            Trace.log(1, "Successfully generated help documentation.");
        }
        return ((StringWriter)object3).toString();
    }

    public synchronized String generateUIM(Command command) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, ObjectDoesNotExistException, SAXException, ParserConfigurationException, TransformerConfigurationException, TransformerException {
        Object object;
        Object object2;
        Object object3;
        if (command == null) {
            throw new NullPointerException("command");
        }
        if (Trace.isTraceOn()) {
            Trace.log(1, "Generating UIM documentation for " + command + ".");
        }
        String string = null;
        try {
            string = command.getXMLExtended();
        }
        catch (AS400Exception aS400Exception) {
            object3 = aS400Exception.getAS400MessageList();
            if (((AS400Message[])object3).length == 1 && object3[0].getID().equalsIgnoreCase("CPF3C21")) {
                if (Trace.isTraceOn()) {
                    Trace.log(4, "Extended command XML format not supported by this server. Using older version.");
                }
                string = command.getXML();
            }
            throw aS400Exception;
        }
        if (this.debug_) {
            object2 = command.getPath();
            object3 = new QSYSObjectPathName((String)object2);
            object = ((QSYSObjectPathName)object3).getLibraryName();
            String string2 = ((QSYSObjectPathName)object3).getObjectName();
            File file = new File(this.outputDirectory_);
            boolean bl = file.isDirectory();
            File file2 = null;
            file2 = bl ? new File(file, (String)object + "_" + string2 + "_XML_X.xml") : new File(this.outputDirectory_ + "_XML_X.xml");
            FileWriter fileWriter = new FileWriter(file2);
            fileWriter.write(string);
            fileWriter.flush();
            fileWriter.close();
        }
        if (Trace.isTraceOn()) {
            Trace.log(1, "Retrieved extended command XML:\n" + string + "\n");
        }
        this.setupUIMTransformer(command.getSystem().getLocale());
        object2 = new StreamSource(new StringReader(string));
        object3 = new StringWriter();
        object = new StreamResult((Writer)object3);
        if (Trace.isTraceOn()) {
            Trace.log(1, "Performing XSL transform of UIM.");
        }
        this.uimTransformer_.transform((Source)object2, (Result)object);
        if (Trace.isTraceOn()) {
            Trace.log(1, "Successfully generated UIM documentation.");
        }
        return ((StringWriter)object3).toString();
    }

    public boolean getDebug() {
        return this.debug_;
    }

    public String getOutputLocation() {
        return this.outputDirectory_;
    }

    public boolean getShowChoiceProgramValues() {
        return this.showChoices_;
    }

    private static final String[][] getTransformedHTMLParms(Locale locale) {
        String[][] stringArray = new String[mriHTMLTags_.length + 4][];
        if (Trace.isTraceOn()) {
            Trace.log(1, "Transforming CommandHelpRetriever HTML MRI for locale: " + locale);
        }
        ResourceBundle resourceBundle = ResourceBundle.getBundle("com.ibm.as400.access.MRI", locale);
        ResourceBundle resourceBundle2 = ResourceBundle.getBundle("com.ibm.as400.access.MRI2", locale);
        for (int i = 0; i < mriHTMLTags_.length; ++i) {
            stringArray[i] = new String[]{"_" + mriHTMLTags_[i], CommandHelpRetriever.encode(resourceBundle2.getString("GENCMDDOC_" + mriHTMLTags_[i]))};
        }
        stringArray[i++] = new String[]{"_DESCRIPTION", CommandHelpRetriever.encode(resourceBundle2.getString("NETSERVER_DESCRIPTION_NAME"))};
        stringArray[i++] = new String[]{"_THREADSAFE_NO", CommandHelpRetriever.encode(resourceBundle.getString("DLG_NO_BUTTON"))};
        stringArray[i++] = new String[]{"_THREADSAFE_YES", CommandHelpRetriever.encode(resourceBundle.getString("DLG_YES_BUTTON"))};
        stringArray[i] = new String[]{"_TYPE_NAME", CommandHelpRetriever.encode(resourceBundle2.getString("NETSERVER_NAME_NAME"))};
        return stringArray;
    }

    private static final String[][] getTransformedUIMParms(Locale locale) {
        String[][] stringArray = new String[mriUIMTags_.length][];
        if (Trace.isTraceOn()) {
            Trace.log(1, "Transforming CommandHelpRetriever UIM MRI for locale: " + locale);
        }
        ResourceBundle resourceBundle = ResourceBundle.getBundle("com.ibm.as400.access.MRI2", locale);
        for (int i = 0; i < mriUIMTags_.length; ++i) {
            stringArray[i] = new String[]{"_" + mriUIMTags_[i], CommandHelpRetriever.encodeAmp(resourceBundle.getString("GENCMDDOC_" + mriUIMTags_[i]))};
        }
        return stringArray;
    }

    private static AS400 parseParms(String[] stringArray, CommandHelpRetriever commandHelpRetriever) throws Exception {
        String string;
        String string2;
        String string3;
        String string4;
        String string5;
        String string6;
        Vector<String> vector = new Vector<String>();
        vector.addElement("-system");
        vector.addElement("-userid");
        vector.addElement("-password");
        vector.addElement("-library");
        vector.addElement("-command");
        vector.addElement("-showChoicePgmValues");
        vector.addElement("-output");
        vector.addElement("-debug");
        vector.addElement("-uim");
        vector.addElement("-html");
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("-help", "-h");
        hashtable.put("-?", "-h");
        hashtable.put("-s", "-system");
        hashtable.put("-sys", "-system");
        hashtable.put("-u", "-userid");
        hashtable.put("-uid", "-userid");
        hashtable.put("-p", "-password");
        hashtable.put("-pwd", "-password");
        hashtable.put("-l", "-library");
        hashtable.put("-lib", "-library");
        hashtable.put("-c", "-command");
        hashtable.put("-cmd", "-command");
        hashtable.put("-scpv", "-showChoicePgmValues");
        hashtable.put("-o", "-output");
        hashtable.put("-d", "-debug");
        CommandLineArguments commandLineArguments = new CommandLineArguments(stringArray, vector, hashtable);
        if (commandLineArguments.getOptionValue("-h") != null) {
            CommandHelpRetriever.usage();
        }
        AS400 aS400 = new AS400();
        String string7 = commandLineArguments.getOptionValue("-system");
        if (string7 != null) {
            aS400.setSystemName(string7);
        }
        if ((string6 = commandLineArguments.getOptionValue("-userid")) != null) {
            aS400.setUserId(string6);
        }
        if ((string5 = commandLineArguments.getOptionValue("-password")) != null) {
            aS400.setPassword(string5);
        }
        if ((string4 = commandLineArguments.getOptionValue("-library")) == null) {
            throw new ExtendedIllegalArgumentException("library", 2);
        }
        library_ = string4;
        String string8 = commandLineArguments.getOptionValue("-command");
        if (string8 == null) {
            throw new ExtendedIllegalArgumentException("command", 2);
        }
        command_ = string8;
        String string9 = commandLineArguments.getOptionValue("-showChoicePgmValues");
        if (string9 != null && (string9.length() == 0 || string9.equalsIgnoreCase("true"))) {
            commandHelpRetriever.setShowChoiceProgramValues(true);
        }
        if ((string3 = commandLineArguments.getOptionValue("-output")) != null) {
            commandHelpRetriever.setOutputLocation(string3);
        }
        if ((string2 = commandLineArguments.getOptionValue("-debug")) != null && (string2.length() == 0 || string2.equalsIgnoreCase("true"))) {
            commandHelpRetriever.setDebug(true);
        }
        genUIM_ = false;
        genHTML_ = true;
        String string10 = commandLineArguments.getOptionValue("-uim");
        if (string10 != null && (string10.length() == 0 || string10.equalsIgnoreCase("true"))) {
            genUIM_ = true;
            genHTML_ = false;
        }
        if ((string = commandLineArguments.getOptionValue("-html")) != null && (string.length() == 0 || string.equalsIgnoreCase("true"))) {
            genHTML_ = true;
        }
        return aS400;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDebug(boolean bl) {
        CommandHelpRetriever commandHelpRetriever = this;
        synchronized (commandHelpRetriever) {
            this.debug_ = bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOutputLocation(String string) {
        if (string == null) {
            throw new NullPointerException("location");
        }
        CommandHelpRetriever commandHelpRetriever = this;
        synchronized (commandHelpRetriever) {
            this.outputDirectory_ = string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setShowChoiceProgramValues(boolean bl) {
        CommandHelpRetriever commandHelpRetriever = this;
        synchronized (commandHelpRetriever) {
            this.showChoices_ = bl;
        }
    }

    private void setupHTMLTransformer(Locale locale) throws TransformerConfigurationException {
        this.htmlTransformer_ = htmlTemplate_.newTransformer();
        this.htmlTransformer_.setURIResolver(this.resolver_);
        String[][] stringArray = null;
        stringArray = locale == null ? transformedHTMLParms_ : CommandHelpRetriever.getTransformedHTMLParms(locale);
        for (int i = 0; i < stringArray.length; ++i) {
            this.htmlTransformer_.setParameter(stringArray[i][0], stringArray[i][1]);
        }
    }

    private void setupUIMTransformer(Locale locale) throws TransformerConfigurationException {
        this.uimTransformer_ = uimTemplate_.newTransformer();
        String[][] stringArray = null;
        stringArray = locale == null ? CommandHelpRetriever.getTransformedUIMParms(Locale.getDefault()) : CommandHelpRetriever.getTransformedUIMParms(locale);
        for (int i = 0; i < stringArray.length; ++i) {
            this.uimTransformer_.setParameter(stringArray[i][0], stringArray[i][1]);
        }
    }

    static void usage() {
        ResourceBundle resourceBundle = ResourceBundle.getBundle("com.ibm.as400.access.MRI2");
        String string = resourceBundle.getString("PROXY_SERVER_USAGE");
        String string2 = resourceBundle.getString("PROXY_SERVER_OPTIONSLC");
        String string3 = resourceBundle.getString("PROXY_SERVER_OPTIONSUC");
        String string4 = resourceBundle.getString("PROXY_SERVER_SHORTCUTS");
        System.out.println(string + ":");
        System.out.println();
        System.out.println("  com.ibm.as400.util.CommandHelpRetriever [ " + string2 + " ]");
        System.out.println();
        System.out.println("  -library library");
        System.out.println("  -command command");
        System.out.println();
        System.out.println(string3 + ":");
        System.out.println();
        System.out.println("  [ -html ]");
        System.out.println("  [ -uim ]");
        System.out.println("  [ -system systemName ]");
        System.out.println("  [ -userID userID ]");
        System.out.println("  [ -password password ]");
        System.out.println("  [ -showChoicePgmValues ]");
        System.out.println("  [ -output outputLocation ]");
        System.out.println("  [ -debug ]");
        System.out.println();
        System.out.println(string4 + ":");
        System.out.println();
        System.out.println("  -h | -?");
        System.out.println("  -l library");
        System.out.println("  -c command");
        System.out.println("  [ -s systemName ]");
        System.out.println("  [ -u userID ]");
        System.out.println("  [ -p password ]");
        System.out.println("  [ -scpv [true | false] ]");
        System.out.println("  [ -o outputLocation ]");
        System.out.println("  [ -d [true | false] ]");
        System.exit(0);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        library_ = null;
        command_ = null;
        mriHTMLTags_ = new String[]{"ALLOW_ALL", "ALLOW_COMPILED_CL_OR_REXX1", "ALLOW_COMPILED_CL_OR_REXX2", "ALLOW_INTERACTIVE1", "ALLOW_INTERACTIVE2", "ALLOW_JOB_BATCH", "ALLOW_JOB_INTERACTIVE", "ALLOW_MODULE_BATCH", "ALLOW_MODULE_INTERACTIVE", "ALLOW_PROGRAM_BATCH", "ALLOW_PROGRAM_INTERACTIVE", "ALLOW_REXX_BATCH", "ALLOW_REXX_INTERACTIVE", "ALLOW_USING_COMMAND_API", "CHOICES", "ELEMENT", "ERRORS", "EXAMPLES", "KEY", "KEYWORD", "NAME_LOWERCASE", "NONE", "NOTES", "OPTIONAL", "PARAMETERS", "POSITIONAL", "QUALIFIER", "REQUIRED", "THREADSAFE", "THREADSAFE_CONDITIONAL", "TOP_OF_PAGE", "TYPE_CL_VARIABLE_NAME", "TYPE_COMMAND_STRING", "TYPE_COMMUNICATIONS_NAME", "TYPE_DATE", "TYPE_DECIMAL_NUMBER", "TYPE_ELEMENT_LIST", "TYPE_GENERIC_NAME", "TYPE_INTEGER", "TYPE_NOT_RESTRICTED", "TYPE_PATH_NAME", "TYPE_QUALIFIED_JOB_NAME", "TYPE_QUALIFIED_OBJECT_NAME", "TYPE_QUALIFIER_LIST", "TYPE_SIMPLE_NAME", "TYPE_TIME", "TYPE_VALUE_LOGICAL", "TYPE_VALUE_CHARACTER", "TYPE_VALUE_HEX", "TYPE_UNSIGNED_INTEGER", "UNKNOWN", "VALUES_OTHER", "VALUES_OTHER_REPEAT", "VALUES_REPEAT", "VALUES_SINGLE", "WHERE_ALLOWED_TO_RUN"};
        mriUIMTags_ = new String[]{"HELP", "HELP_FOR_COMMAND", "INTRO_COMMAND_HELP", "DESCRIBE_COMMAND", "RESTRICTIONS_HEADING", "RESTRICTION_AUT", "RESTRICTION_THREADSAFE", "LIST_SPECIAL_AUT", "LIST_OTHER_AUT", "LIST_THREADSAFE_RESTRICTIONS", "DESCRIBE_OTHER_RESTRICTION", "RESTRICTION_COMMENT", "NO_PARAMETERS", "EXAMPLES_HEADING", "EXAMPLE_1_TITLE", "DESCRIBE_EXAMPLE_1", "EXAMPLE_2_TITLE", "DESCRIBE_EXAMPLE_2", "INTRO_EXAMPLE_HELP", "ERROR_MESSAGES_HEADING", "ERROR_MESSAGES_COMMENT_1", "ERROR_MESSAGES_COMMENT_2", "ERROR_MESSAGES_COMMENT_3", "HELP_FOR_PARAMETER", "INTRO_PARAMETER_HELP", "DESCRIBE_PARAMETER", "REQUIRED_PARAMETER", "ELEMENT", "QUALIFIER", "VALUES_OTHER", "VALUES_OTHER_REPEAT", "VALUES_REPEAT", "VALUES_SINGLE", "VALUE_CHARACTER", "VALUE_CL_VARIABLE_NAME", "VALUE_COMMAND_STRING", "VALUE_COMMUNICATIONS_NAME", "VALUE_DATE", "VALUE_DECIMAL_NUMBER", "VALUE_GENERIC_NAME", "VALUE_HEX", "VALUE_INTEGER", "VALUE_LOGICAL", "VALUE_NAME", "VALUE_NOT_RESTRICTED", "VALUE_PATH_NAME", "VALUE_SIMPLE_NAME", "VALUE_TIME", "VALUE_UNSIGNED_INTEGER", "SPECIFY_VALUE", "SPECIFY_NAME", "SPECIFY_GENERIC_NAME", "SPECIFY_PATH_NAME", "SPECIFY_NUMBER", "SPECIFY_CL_VARIABLE_NAME", "SPECIFY_COMMAND_STRING", "SPECIFY_DATE", "SPECIFY_TIME", "MULTIPLE_PARAMETER_VALUES_ALLOWED", "MULTIPLE_ELEMENT_VALUES_ALLOWED", "DESCRIBE_PREDEFINED_PARAMETER_VALUE", "DESCRIBE_USERDEFINED_PARAMETER_VALUE", "DESCRIBE_PARAMETER_DEFAULT", "DESCRIBE_PARAMETER_VALUE_WITH_RANGE"};
        transformedHTMLParms_ = CommandHelpRetriever.getTransformedHTMLParms(Locale.getDefault());
        try {
            if (Trace.isTraceOn()) {
                Trace.log(1, "Loading gencmddoc.xsl.");
            }
            String string = (class$com$ibm$as400$util$CommandHelpRetriever == null ? (class$com$ibm$as400$util$CommandHelpRetriever = CommandHelpRetriever.class$("com.ibm.as400.util.CommandHelpRetriever")) : class$com$ibm$as400$util$CommandHelpRetriever).getClassLoader().getResource("com/ibm/as400/util/gencmddoc.xsl").toString();
            if (Trace.isTraceOn()) {
                Trace.log(1, "Loading gencmdhlp.xsl.");
            }
            String string2 = (class$com$ibm$as400$util$CommandHelpRetriever == null ? (class$com$ibm$as400$util$CommandHelpRetriever = CommandHelpRetriever.class$("com.ibm.as400.util.CommandHelpRetriever")) : class$com$ibm$as400$util$CommandHelpRetriever).getClassLoader().getResource("com/ibm/as400/util/gencmdhlp.xsl").toString();
            if (Trace.isTraceOn()) {
                Trace.log(1, "Loading XSL templates.");
            }
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            defaultResolver_ = transformerFactory.getURIResolver();
            htmlTemplate_ = transformerFactory.newTemplates(new StreamSource(string));
            uimTemplate_ = transformerFactory.newTemplates(new StreamSource(string2));
        }
        catch (Exception exception) {
            if (Trace.isTraceOn()) {
                Trace.log(2, "Unable to initialize CommandHelpRetriever XSL and MRI.", (Throwable)exception);
            }
            throw new RuntimeException(exception.toString());
        }
        genUIM_ = false;
        genHTML_ = true;
    }

    private static class HelpResolver
    implements URIResolver {
        public String helpResults_;

        private HelpResolver() {
        }

        public Source resolve(String string, String string2) throws TransformerException {
            if (string.indexOf("myCommandHelpResolver") > -1) {
                return new StreamSource(new StringReader(this.helpResults_));
            }
            return defaultResolver_.resolve(string, string2);
        }
    }
}

