/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400DataType;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.Trace;

public class AS400UnsignedBin4
implements AS400DataType {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    static final long serialVersionUID = 4L;
    private static final int SIZE = 4;
    private static final long MIN_VALUE = 0L;
    private static final long MAX_VALUE = 0xFFFFFFFFL;
    private static final long defaultValue = 0L;

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            Trace.log(2, "Unexpected cloning error", (Throwable)cloneNotSupportedException);
            throw new InternalErrorException(6);
        }
    }

    public int getByteLength() {
        return 4;
    }

    public Object getDefaultValue() {
        return new Long(0L);
    }

    public int getInstanceType() {
        return 11;
    }

    public byte[] toBytes(Object object) {
        long l = (Long)object;
        if (l < 0L || l > 0xFFFFFFFFL) {
            throw new ExtendedIllegalArgumentException("javaValue (" + object.toString() + ")", 4);
        }
        byte[] byArray = new byte[4];
        BinaryConverter.unsignedIntToByteArray(l, byArray, 0);
        return byArray;
    }

    public byte[] toBytes(long l) {
        if (l < 0L || l > 0xFFFFFFFFL) {
            throw new ExtendedIllegalArgumentException("longValue (" + String.valueOf(l) + ")", 4);
        }
        byte[] byArray = new byte[4];
        BinaryConverter.unsignedIntToByteArray(l, byArray, 0);
        return byArray;
    }

    public int toBytes(Object object, byte[] byArray) {
        long l = (Long)object;
        if (l < 0L || l > 0xFFFFFFFFL) {
            throw new ExtendedIllegalArgumentException("javaValue (" + object.toString() + ")", 4);
        }
        BinaryConverter.unsignedIntToByteArray(l, byArray, 0);
        return 4;
    }

    public int toBytes(long l, byte[] byArray) {
        if (l < 0L || l > 0xFFFFFFFFL) {
            throw new ExtendedIllegalArgumentException("longValue (" + String.valueOf(l) + ")", 4);
        }
        BinaryConverter.unsignedIntToByteArray(l, byArray, 0);
        return 4;
    }

    public int toBytes(Object object, byte[] byArray, int n) {
        long l = (Long)object;
        if (l < 0L || l > 0xFFFFFFFFL) {
            throw new ExtendedIllegalArgumentException("javaValue (" + object.toString() + ")", 4);
        }
        BinaryConverter.unsignedIntToByteArray(l, byArray, n);
        return 4;
    }

    public int toBytes(long l, byte[] byArray, int n) {
        if (l < 0L || l > 0xFFFFFFFFL) {
            throw new ExtendedIllegalArgumentException("longValue (" + String.valueOf(l) + ")", 4);
        }
        BinaryConverter.unsignedIntToByteArray(l, byArray, n);
        return 4;
    }

    public long toLong(byte[] byArray) {
        return BinaryConverter.byteArrayToUnsignedInt(byArray, 0);
    }

    public long toLong(byte[] byArray, int n) {
        return BinaryConverter.byteArrayToUnsignedInt(byArray, n);
    }

    public Object toObject(byte[] byArray) {
        return new Long(BinaryConverter.byteArrayToUnsignedInt(byArray, 0));
    }

    public Object toObject(byte[] byArray, int n) {
        return new Long(BinaryConverter.byteArrayToUnsignedInt(byArray, n));
    }
}

