/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AbstractProxyImpl;
import com.ibm.as400.access.JDBlobProxy;
import com.ibm.as400.access.JDClobProxy;
import com.ibm.as400.access.JDConnectionProxy;
import com.ibm.as400.access.JDInputStreamProxy;
import com.ibm.as400.access.JDReaderProxy;
import com.ibm.as400.access.JDResultSetMetaDataProxy;
import com.ibm.as400.access.JDStatementProxy;
import com.ibm.as400.access.JDTrace;
import com.ibm.as400.access.ProxyClientConnection;
import com.ibm.as400.access.ProxyReturnValue;
import com.ibm.as400.access.SerializableInputStream;
import com.ibm.as400.access.SerializableReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;

class JDResultSetProxy
extends AbstractProxyImpl
implements ResultSet {
    private static final String copyright = "Copyright (C) 1997-2001 International Business Machines Corporation and others.";
    private JDConnectionProxy jdConnection_;
    private JDStatementProxy cachedStatement_;
    private static final String NOT_SERIALIZABLE = "Parameter is not serializable.";
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$util$Calendar;
    static /* synthetic */ Class class$java$util$Map;
    static /* synthetic */ Class class$java$sql$Array;
    static /* synthetic */ Class class$java$io$InputStream;
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$java$sql$Blob;
    static /* synthetic */ Class array$B;
    static /* synthetic */ Class class$java$io$Reader;
    static /* synthetic */ Class class$java$sql$Clob;
    static /* synthetic */ Class class$java$sql$Date;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$sql$Ref;
    static /* synthetic */ Class class$java$sql$Time;
    static /* synthetic */ Class class$java$sql$Timestamp;

    public JDResultSetProxy(JDConnectionProxy jDConnectionProxy) {
        this.jdConnection_ = jDConnectionProxy;
    }

    public JDResultSetProxy(JDConnectionProxy jDConnectionProxy, JDStatementProxy jDStatementProxy) {
        this.jdConnection_ = jDConnectionProxy;
        this.cachedStatement_ = jDStatementProxy;
    }

    private void callMethod(String string) throws SQLException {
        try {
            this.connection_.callMethod(this.pxId_, string);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw JDConnectionProxy.rethrow1(invocationTargetException);
        }
    }

    private void callMethod(String string, Class[] classArray, Object[] objectArray) throws SQLException {
        try {
            this.connection_.callMethod(this.pxId_, string, classArray, objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw JDConnectionProxy.rethrow1(invocationTargetException);
        }
    }

    private boolean callMethodRtnBool(String string) throws SQLException {
        try {
            return this.connection_.callMethodReturnsBoolean(this.pxId_, string);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw JDConnectionProxy.rethrow1(invocationTargetException);
        }
    }

    private JDInputStreamProxy callMethodRtnInpStrm(String string, int n) throws SQLException {
        try {
            JDInputStreamProxy jDInputStreamProxy = new JDInputStreamProxy();
            return (JDInputStreamProxy)this.connection_.callFactoryMethod(this.pxId_, string, new Class[]{Integer.TYPE}, new Object[]{new Integer(n)}, jDInputStreamProxy);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw JDConnectionProxy.rethrow1(invocationTargetException);
        }
    }

    private int callMethodRtnInt(String string) throws SQLException {
        try {
            return this.connection_.callMethodReturnsInt(this.pxId_, string);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw JDConnectionProxy.rethrow1(invocationTargetException);
        }
    }

    private Object callMethodRtnObj(String string) throws SQLException {
        try {
            return this.connection_.callMethodReturnsObject(this.pxId_, string);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw JDConnectionProxy.rethrow1(invocationTargetException);
        }
    }

    private Object callMethodRtnObj(String string, Class[] classArray, Object[] objectArray) throws SQLException {
        try {
            return this.connection_.callMethod(this.pxId_, string, classArray, objectArray).getReturnValue();
        }
        catch (InvocationTargetException invocationTargetException) {
            throw JDConnectionProxy.rethrow1(invocationTargetException);
        }
    }

    private ProxyReturnValue callMethodRtnRaw(String string, Class[] classArray, Object[] objectArray) throws SQLException {
        try {
            return this.connection_.callMethod(this.pxId_, string, classArray, objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw JDConnectionProxy.rethrow1(invocationTargetException);
        }
    }

    public void clearWarnings() throws SQLException {
        this.callMethod("clearWarnings");
    }

    public void close() throws SQLException {
        this.callMethod("close");
    }

    public int findColumn(String string) throws SQLException {
        return this.callMethodRtnRaw("findColumn", new Class[]{class$java$lang$String == null ? (class$java$lang$String = JDResultSetProxy.class$("java.lang.String")) : class$java$lang$String}, new Object[]{string}).getReturnValueInt();
    }

    public int getConcurrency() throws SQLException {
        return this.callMethodRtnInt("getConcurrency");
    }

    public String getCursorName() throws SQLException {
        return (String)this.callMethodRtnObj("getCursorName");
    }

    public int getFetchDirection() throws SQLException {
        return this.callMethodRtnInt("getFetchDirection");
    }

    public int getFetchSize() throws SQLException {
        return this.callMethodRtnInt("getFetchSize");
    }

    public Statement getStatement() throws SQLException {
        if (this.cachedStatement_ == null) {
            try {
                JDStatementProxy jDStatementProxy = new JDStatementProxy(this.jdConnection_);
                this.cachedStatement_ = (JDStatementProxy)this.connection_.callFactoryMethod(this.pxId_, "getStatement", jDStatementProxy);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw JDConnectionProxy.rethrow1(invocationTargetException);
            }
        }
        return this.cachedStatement_;
    }

    public int getType() throws SQLException {
        return this.callMethodRtnInt("getType");
    }

    public SQLWarning getWarnings() throws SQLException {
        return (SQLWarning)this.callMethodRtnObj("getWarnings");
    }

    public void setFetchDirection(int n) throws SQLException {
        this.callMethod("setFetchDirection", new Class[]{Integer.TYPE}, new Object[]{new Integer(n)});
    }

    public void setFetchSize(int n) throws SQLException {
        this.callMethod("setFetchSize", new Class[]{Integer.TYPE}, new Object[]{new Integer(n)});
    }

    public String toString() {
        try {
            return (String)this.connection_.callMethodReturnsObject(this.pxId_, "toString");
        }
        catch (InvocationTargetException invocationTargetException) {
            throw ProxyClientConnection.rethrow(invocationTargetException);
        }
    }

    public boolean absolute(int n) throws SQLException {
        return this.callMethodRtnRaw("absolute", new Class[]{Integer.TYPE}, new Object[]{new Integer(n)}).getReturnValueBoolean();
    }

    public void afterLast() throws SQLException {
        this.callMethod("afterLast");
    }

    public void beforeFirst() throws SQLException {
        this.callMethod("beforeFirst");
    }

    public boolean first() throws SQLException {
        return this.callMethodRtnBool("first");
    }

    public int getRow() throws SQLException {
        return this.callMethodRtnInt("getRow");
    }

    public boolean isAfterLast() throws SQLException {
        return this.callMethodRtnBool("isAfterLast");
    }

    public boolean isBeforeFirst() throws SQLException {
        return this.callMethodRtnBool("isBeforeFirst");
    }

    public boolean isFirst() throws SQLException {
        return this.callMethodRtnBool("isFirst");
    }

    public boolean isLast() throws SQLException {
        return this.callMethodRtnBool("isLast");
    }

    public boolean last() throws SQLException {
        return this.callMethodRtnBool("last");
    }

    public void moveToCurrentRow() throws SQLException {
        this.callMethod("moveToCurrentRow");
    }

    public void moveToInsertRow() throws SQLException {
        this.callMethod("moveToInsertRow");
    }

    public boolean next() throws SQLException {
        return this.callMethodRtnBool("next");
    }

    public boolean previous() throws SQLException {
        return this.callMethodRtnBool("previous");
    }

    public void refreshRow() throws SQLException {
        this.callMethod("refreshRow");
    }

    public boolean relative(int n) throws SQLException {
        return this.callMethodRtnRaw("relative", new Class[]{Integer.TYPE}, new Object[]{new Integer(n)}).getReturnValueBoolean();
    }

    public Array getArray(int n) throws SQLException {
        return (Array)this.callMethodRtnObj("getArray", new Class[]{Integer.TYPE}, new Object[]{new Integer(n)});
    }

    public Array getArray(String string) throws SQLException {
        return this.getArray(this.findColumn(string));
    }

    public InputStream getAsciiStream(int n) throws SQLException {
        return this.callMethodRtnInpStrm("getAsciiStream", n);
    }

    public InputStream getAsciiStream(String string) throws SQLException {
        return this.getAsciiStream(this.findColumn(string));
    }

    public BigDecimal getBigDecimal(int n) throws SQLException {
        return (BigDecimal)this.callMethodRtnObj("getBigDecimal", new Class[]{Integer.TYPE}, new Object[]{new Integer(n)});
    }

    public BigDecimal getBigDecimal(String string) throws SQLException {
        return this.getBigDecimal(this.findColumn(string));
    }

    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        return (BigDecimal)this.callMethodRtnObj("getBigDecimal", new Class[]{Integer.TYPE, Integer.TYPE}, new Object[]{new Integer(n), new Integer(n2)});
    }

    public BigDecimal getBigDecimal(String string, int n) throws SQLException {
        return this.getBigDecimal(this.findColumn(string), n);
    }

    public InputStream getBinaryStream(int n) throws SQLException {
        return this.callMethodRtnInpStrm("getBinaryStream", n);
    }

    public InputStream getBinaryStream(String string) throws SQLException {
        return this.getBinaryStream(this.findColumn(string));
    }

    public Blob getBlob(int n) throws SQLException {
        try {
            JDBlobProxy jDBlobProxy = new JDBlobProxy();
            return (JDBlobProxy)this.connection_.callFactoryMethod(this.pxId_, "getBlob", new Class[]{Integer.TYPE}, new Object[]{new Integer(n)}, jDBlobProxy);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw JDConnectionProxy.rethrow1(invocationTargetException);
        }
    }

    public Blob getBlob(String string) throws SQLException {
        return this.getBlob(this.findColumn(string));
    }

    public boolean getBoolean(int n) throws SQLException {
        return this.callMethodRtnRaw("getBoolean", new Class[]{Integer.TYPE}, new Object[]{new Integer(n)}).getReturnValueBoolean();
    }

    public boolean getBoolean(String string) throws SQLException {
        return this.getBoolean(this.findColumn(string));
    }

    public byte getByte(int n) throws SQLException {
        return this.callMethodRtnRaw("getByte", new Class[]{Integer.TYPE}, new Object[]{new Integer(n)}).getReturnValueByte();
    }

    public byte getByte(String string) throws SQLException {
        return this.getByte(this.findColumn(string));
    }

    public byte[] getBytes(int n) throws SQLException {
        return (byte[])this.callMethodRtnObj("getBytes", new Class[]{Integer.TYPE}, new Object[]{new Integer(n)});
    }

    public byte[] getBytes(String string) throws SQLException {
        return this.getBytes(this.findColumn(string));
    }

    public Reader getCharacterStream(int n) throws SQLException {
        try {
            JDReaderProxy jDReaderProxy = new JDReaderProxy();
            return (JDReaderProxy)this.connection_.callFactoryMethod(this.pxId_, "getCharacterStream", new Class[]{Integer.TYPE}, new Object[]{new Integer(n)}, jDReaderProxy);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw JDConnectionProxy.rethrow1(invocationTargetException);
        }
    }

    public Reader getCharacterStream(String string) throws SQLException {
        return this.getCharacterStream(this.findColumn(string));
    }

    public Clob getClob(int n) throws SQLException {
        try {
            JDClobProxy jDClobProxy = new JDClobProxy();
            return (JDClobProxy)this.connection_.callFactoryMethod(this.pxId_, "getClob", new Class[]{Integer.TYPE}, new Object[]{new Integer(n)}, jDClobProxy);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw JDConnectionProxy.rethrow1(invocationTargetException);
        }
    }

    public Clob getClob(String string) throws SQLException {
        return this.getClob(this.findColumn(string));
    }

    public Date getDate(int n) throws SQLException {
        return (Date)this.callMethodRtnObj("getDate", new Class[]{Integer.TYPE}, new Object[]{new Integer(n)});
    }

    public Date getDate(String string) throws SQLException {
        return (Date)this.callMethodRtnObj("getDate", new Class[]{class$java$lang$String == null ? (class$java$lang$String = JDResultSetProxy.class$("java.lang.String")) : class$java$lang$String}, new Object[]{string});
    }

    public Date getDate(int n, Calendar calendar) throws SQLException {
        return (Date)this.callMethodRtnObj("getDate", new Class[]{Integer.TYPE, class$java$util$Calendar == null ? (class$java$util$Calendar = JDResultSetProxy.class$("java.util.Calendar")) : class$java$util$Calendar}, new Object[]{new Integer(n), calendar});
    }

    public Date getDate(String string, Calendar calendar) throws SQLException {
        return this.getDate(this.findColumn(string), calendar);
    }

    public double getDouble(int n) throws SQLException {
        return this.callMethodRtnRaw("getDouble", new Class[]{Integer.TYPE}, new Object[]{new Integer(n)}).getReturnValueDouble();
    }

    public double getDouble(String string) throws SQLException {
        return this.getDouble(this.findColumn(string));
    }

    public float getFloat(int n) throws SQLException {
        return this.callMethodRtnRaw("getFloat", new Class[]{Integer.TYPE}, new Object[]{new Integer(n)}).getReturnValueFloat();
    }

    public float getFloat(String string) throws SQLException {
        return this.getFloat(this.findColumn(string));
    }

    public int getInt(int n) throws SQLException {
        return this.callMethodRtnRaw("getInt", new Class[]{Integer.TYPE}, new Object[]{new Integer(n)}).getReturnValueInt();
    }

    public int getInt(String string) throws SQLException {
        return this.getInt(this.findColumn(string));
    }

    public long getLong(int n) throws SQLException {
        return this.callMethodRtnRaw("getLong", new Class[]{Integer.TYPE}, new Object[]{new Integer(n)}).getReturnValueLong();
    }

    public long getLong(String string) throws SQLException {
        return this.getLong(this.findColumn(string));
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        try {
            JDResultSetMetaDataProxy jDResultSetMetaDataProxy = new JDResultSetMetaDataProxy(this.jdConnection_);
            return (JDResultSetMetaDataProxy)this.connection_.callFactoryMethod(this.pxId_, "getMetaData", jDResultSetMetaDataProxy);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw JDConnectionProxy.rethrow1(invocationTargetException);
        }
    }

    public Object getObject(int n) throws SQLException {
        String string = this.getMetaData().getColumnTypeName(n);
        AbstractProxyImpl abstractProxyImpl = null;
        try {
            if (string.equalsIgnoreCase("BLOB")) {
                abstractProxyImpl = new JDBlobProxy();
            } else if (string.equalsIgnoreCase("CLOB")) {
                abstractProxyImpl = new JDClobProxy();
            } else {
                return this.callMethodRtnObj("getObject", new Class[]{Integer.TYPE}, new Object[]{new Integer(n)});
            }
            return this.connection_.callFactoryMethod(this.pxId_, "getObject", new Class[]{Integer.TYPE}, new Object[]{new Integer(n)}, abstractProxyImpl);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw JDConnectionProxy.rethrow1(invocationTargetException);
        }
    }

    public Object getObject(String string) throws SQLException {
        return this.getObject(this.findColumn(string));
    }

    public Object getObject(int n, Map map) throws SQLException {
        String string = this.getMetaData().getColumnTypeName(n);
        AbstractProxyImpl abstractProxyImpl = null;
        try {
            if (string.equalsIgnoreCase("BLOB")) {
                abstractProxyImpl = new JDBlobProxy();
            } else if (string.equalsIgnoreCase("CLOB")) {
                abstractProxyImpl = new JDClobProxy();
            } else {
                return this.callMethodRtnObj("getObject", new Class[]{Integer.TYPE, class$java$util$Map == null ? (class$java$util$Map = JDResultSetProxy.class$("java.util.Map")) : class$java$util$Map}, new Object[]{new Integer(n), map});
            }
            return this.connection_.callFactoryMethod(this.pxId_, "getObject", new Class[]{Integer.TYPE, class$java$util$Map == null ? (class$java$util$Map = JDResultSetProxy.class$("java.util.Map")) : class$java$util$Map}, new Object[]{new Integer(n), map}, abstractProxyImpl);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw JDConnectionProxy.rethrow1(invocationTargetException);
        }
    }

    public Object getObject(String string, Map map) throws SQLException {
        return this.getObject(this.findColumn(string), map);
    }

    public Ref getRef(int n) throws SQLException {
        return (Ref)this.callMethodRtnObj("getRef", new Class[]{Integer.TYPE}, new Object[]{new Integer(n)});
    }

    public Ref getRef(String string) throws SQLException {
        return this.getRef(this.findColumn(string));
    }

    public short getShort(int n) throws SQLException {
        return this.callMethodRtnRaw("getShort", new Class[]{Integer.TYPE}, new Object[]{new Integer(n)}).getReturnValueShort();
    }

    public short getShort(String string) throws SQLException {
        return this.getShort(this.findColumn(string));
    }

    public String getString(int n) throws SQLException {
        return (String)this.callMethodRtnObj("getString", new Class[]{Integer.TYPE}, new Object[]{new Integer(n)});
    }

    public String getString(String string) throws SQLException {
        return this.getString(this.findColumn(string));
    }

    public Time getTime(int n) throws SQLException {
        return (Time)this.callMethodRtnObj("getTime", new Class[]{Integer.TYPE}, new Object[]{new Integer(n)});
    }

    public Time getTime(String string) throws SQLException {
        return this.getTime(this.findColumn(string));
    }

    public Time getTime(int n, Calendar calendar) throws SQLException {
        return (Time)this.callMethodRtnObj("getTime", new Class[]{Integer.TYPE, class$java$util$Calendar == null ? (class$java$util$Calendar = JDResultSetProxy.class$("java.util.Calendar")) : class$java$util$Calendar}, new Object[]{new Integer(n), calendar});
    }

    public Time getTime(String string, Calendar calendar) throws SQLException {
        return this.getTime(this.findColumn(string), calendar);
    }

    public Timestamp getTimestamp(int n) throws SQLException {
        return (Timestamp)this.callMethodRtnObj("getTimestamp", new Class[]{Integer.TYPE}, new Object[]{new Integer(n)});
    }

    public Timestamp getTimestamp(String string) throws SQLException {
        return this.getTimestamp(this.findColumn(string));
    }

    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        return (Timestamp)this.callMethodRtnObj("getTimestamp", new Class[]{Integer.TYPE, class$java$util$Calendar == null ? (class$java$util$Calendar = JDResultSetProxy.class$("java.util.Calendar")) : class$java$util$Calendar}, new Object[]{new Integer(n), calendar});
    }

    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        return this.getTimestamp(this.findColumn(string), calendar);
    }

    public InputStream getUnicodeStream(int n) throws SQLException {
        return this.callMethodRtnInpStrm("getUnicodeStream", n);
    }

    public InputStream getUnicodeStream(String string) throws SQLException {
        return this.getUnicodeStream(this.findColumn(string));
    }

    public URL getURL(int n) throws SQLException {
        return (URL)this.callMethodRtnObj("getURL", new Class[]{Integer.TYPE}, new Object[]{new Integer(n)});
    }

    public URL getURL(String string) throws SQLException {
        return (URL)this.callMethodRtnObj("getURL", new Class[]{class$java$lang$String == null ? (class$java$lang$String = JDResultSetProxy.class$("java.lang.String")) : class$java$lang$String}, new Object[]{string});
    }

    public boolean wasNull() throws SQLException {
        return this.callMethodRtnBool("wasNull");
    }

    public void cancelRowUpdates() throws SQLException {
        this.callMethod("cancelRowUpdates");
    }

    public void deleteRow() throws SQLException {
        this.callMethod("deleteRow");
    }

    public void insertRow() throws SQLException {
        this.callMethod("insertRow");
    }

    public boolean rowDeleted() throws SQLException {
        return this.callMethodRtnBool("rowDeleted");
    }

    public boolean rowInserted() throws SQLException {
        return this.callMethodRtnBool("rowInserted");
    }

    public boolean rowUpdated() throws SQLException {
        return this.callMethodRtnBool("rowUpdated");
    }

    public void updateArray(int n, Array array) throws SQLException {
        if (array != null && !(array instanceof Serializable)) {
            if (JDTrace.isTraceOn()) {
                JDTrace.logInformation(this, NOT_SERIALIZABLE);
            }
            throw new SQLException();
        }
        this.callMethod("updateArray", new Class[]{Integer.TYPE, class$java$sql$Array == null ? (class$java$sql$Array = JDResultSetProxy.class$("java.sql.Array")) : class$java$sql$Array}, new Object[]{new Integer(n), array});
    }

    public void updateArray(String string, Array array) throws SQLException {
        if (array != null && !(array instanceof Serializable)) {
            if (JDTrace.isTraceOn()) {
                JDTrace.logInformation(this, NOT_SERIALIZABLE);
            }
            throw new SQLException();
        }
        this.callMethod("updateArray", new Class[]{class$java$lang$String == null ? (class$java$lang$String = JDResultSetProxy.class$("java.lang.String")) : class$java$lang$String, class$java$sql$Array == null ? (class$java$sql$Array = JDResultSetProxy.class$("java.sql.Array")) : class$java$sql$Array}, new Object[]{string, array});
    }

    public void updateAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        InputStream inputStream2;
        if (inputStream == null || inputStream instanceof Serializable) {
            inputStream2 = inputStream;
        } else {
            try {
                inputStream2 = new SerializableInputStream(inputStream);
            }
            catch (IOException iOException) {
                throw new SQLException(iOException.getMessage());
            }
        }
        this.callMethod("updateAsciiStream", new Class[]{Integer.TYPE, class$java$io$InputStream == null ? (class$java$io$InputStream = JDResultSetProxy.class$("java.io.InputStream")) : class$java$io$InputStream, Integer.TYPE}, new Object[]{new Integer(n), inputStream2, new Integer(n2)});
    }

    public void updateAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        this.updateAsciiStream(this.findColumn(string), inputStream, n);
    }

    public void updateBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        this.callMethod("updateBigDecimal", new Class[]{Integer.TYPE, class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = JDResultSetProxy.class$("java.math.BigDecimal")) : class$java$math$BigDecimal}, new Object[]{new Integer(n), bigDecimal});
    }

    public void updateBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        this.updateBigDecimal(this.findColumn(string), bigDecimal);
    }

    public void updateBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        InputStream inputStream2;
        if (inputStream == null || inputStream instanceof Serializable) {
            inputStream2 = inputStream;
        } else {
            try {
                inputStream2 = new SerializableInputStream(inputStream);
            }
            catch (IOException iOException) {
                throw new SQLException(iOException.getMessage());
            }
        }
        this.callMethod("updateBinaryStream", new Class[]{Integer.TYPE, class$java$io$InputStream == null ? (class$java$io$InputStream = JDResultSetProxy.class$("java.io.InputStream")) : class$java$io$InputStream, Integer.TYPE}, new Object[]{new Integer(n), inputStream2, new Integer(n2)});
    }

    public void updateBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        this.updateBinaryStream(this.findColumn(string), inputStream, n);
    }

    public void updateBlob(int n, Blob blob) throws SQLException {
        this.callMethod("updateBlob", new Class[]{Integer.TYPE, class$java$sql$Blob == null ? (class$java$sql$Blob = JDResultSetProxy.class$("java.sql.Blob")) : class$java$sql$Blob}, new Object[]{new Integer(n), blob});
    }

    public void updateBlob(String string, Blob blob) throws SQLException {
        this.callMethod("updateBlob", new Class[]{class$java$lang$String == null ? (class$java$lang$String = JDResultSetProxy.class$("java.lang.String")) : class$java$lang$String, class$java$sql$Blob == null ? (class$java$sql$Blob = JDResultSetProxy.class$("java.sql.Blob")) : class$java$sql$Blob}, new Object[]{string, blob});
    }

    public void updateBoolean(int n, boolean bl) throws SQLException {
        this.callMethod("updateBoolean", new Class[]{Integer.TYPE, Boolean.TYPE}, new Object[]{new Integer(n), new Boolean(bl)});
    }

    public void updateBoolean(String string, boolean bl) throws SQLException {
        this.updateBoolean(this.findColumn(string), bl);
    }

    public void updateByte(int n, byte by) throws SQLException {
        this.callMethod("updateByte", new Class[]{Integer.TYPE, Byte.TYPE}, new Object[]{new Integer(n), new Byte(by)});
    }

    public void updateByte(String string, byte by) throws SQLException {
        this.updateByte(this.findColumn(string), by);
    }

    public void updateBytes(int n, byte[] byArray) throws SQLException {
        this.callMethod("updateBytes", new Class[]{Integer.TYPE, array$B == null ? (array$B = JDResultSetProxy.class$("[B")) : array$B}, new Object[]{new Integer(n), byArray});
    }

    public void updateBytes(String string, byte[] byArray) throws SQLException {
        this.updateBytes(this.findColumn(string), byArray);
    }

    public void updateCharacterStream(int n, Reader reader, int n2) throws SQLException {
        try {
            SerializableReader serializableReader = reader == null ? null : new SerializableReader(reader, Math.max(0, n2));
            this.callMethod("updateCharacterStream", new Class[]{Integer.TYPE, class$java$io$Reader == null ? (class$java$io$Reader = JDResultSetProxy.class$("java.io.Reader")) : class$java$io$Reader, Integer.TYPE}, new Object[]{new Integer(n), serializableReader, new Integer(n2)});
        }
        catch (IOException iOException) {
            throw new SQLException(iOException.getMessage());
        }
    }

    public void updateCharacterStream(String string, Reader reader, int n) throws SQLException {
        this.updateCharacterStream(this.findColumn(string), reader, n);
    }

    public void updateClob(int n, Clob clob) throws SQLException {
        this.callMethod("updateClob", new Class[]{class$java$lang$String == null ? (class$java$lang$String = JDResultSetProxy.class$("java.lang.String")) : class$java$lang$String, class$java$sql$Clob == null ? (class$java$sql$Clob = JDResultSetProxy.class$("java.sql.Clob")) : class$java$sql$Clob}, new Object[]{new Integer(n), clob});
    }

    public void updateClob(String string, Clob clob) throws SQLException {
        this.callMethod("updateClob", new Class[]{class$java$lang$String == null ? (class$java$lang$String = JDResultSetProxy.class$("java.lang.String")) : class$java$lang$String, class$java$sql$Clob == null ? (class$java$sql$Clob = JDResultSetProxy.class$("java.sql.Clob")) : class$java$sql$Clob}, new Object[]{string, clob});
    }

    public void updateDate(int n, Date date) throws SQLException {
        this.callMethod("updateDate", new Class[]{Integer.TYPE, class$java$sql$Date == null ? (class$java$sql$Date = JDResultSetProxy.class$("java.sql.Date")) : class$java$sql$Date}, new Object[]{new Integer(n), date});
    }

    public void updateDate(String string, Date date) throws SQLException {
        this.updateDate(this.findColumn(string), date);
    }

    public void updateDouble(int n, double d) throws SQLException {
        this.callMethod("updateDouble", new Class[]{Integer.TYPE, Double.TYPE}, new Object[]{new Integer(n), new Double(d)});
    }

    public void updateDouble(String string, double d) throws SQLException {
        this.updateDouble(this.findColumn(string), d);
    }

    public void updateFloat(int n, float f) throws SQLException {
        this.callMethod("updateFloat", new Class[]{Integer.TYPE, Float.TYPE}, new Object[]{new Integer(n), new Float(f)});
    }

    public void updateFloat(String string, float f) throws SQLException {
        this.updateFloat(this.findColumn(string), f);
    }

    public void updateInt(int n, int n2) throws SQLException {
        this.callMethod("updateInt", new Class[]{Integer.TYPE, Integer.TYPE}, new Object[]{new Integer(n), new Integer(n2)});
    }

    public void updateInt(String string, int n) throws SQLException {
        this.updateInt(this.findColumn(string), n);
    }

    public void updateLong(int n, long l) throws SQLException {
        this.callMethod("updateLong", new Class[]{Integer.TYPE, Long.TYPE}, new Object[]{new Integer(n), new Long(l)});
    }

    public void updateLong(String string, long l) throws SQLException {
        this.updateLong(this.findColumn(string), l);
    }

    public void updateNull(int n) throws SQLException {
        this.callMethod("updateNull", new Class[]{Integer.TYPE}, new Object[]{new Integer(n)});
    }

    public void updateNull(String string) throws SQLException {
        this.updateNull(this.findColumn(string));
    }

    public void updateObject(int n, Object object) throws SQLException {
        if (object != null && !(object instanceof Serializable)) {
            if (JDTrace.isTraceOn()) {
                JDTrace.logInformation(this, NOT_SERIALIZABLE);
            }
            throw new SQLException();
        }
        this.callMethod("updateObject", new Class[]{Integer.TYPE, class$java$lang$Object == null ? (class$java$lang$Object = JDResultSetProxy.class$("java.lang.Object")) : class$java$lang$Object}, new Object[]{new Integer(n), object});
    }

    public void updateObject(String string, Object object) throws SQLException {
        this.updateObject(this.findColumn(string), object);
    }

    public void updateObject(int n, Object object, int n2) throws SQLException {
        if (object != null && !(object instanceof Serializable)) {
            if (JDTrace.isTraceOn()) {
                JDTrace.logInformation(this, NOT_SERIALIZABLE);
            }
            throw new SQLException();
        }
        this.callMethod("updateObject", new Class[]{Integer.TYPE, class$java$lang$Object == null ? (class$java$lang$Object = JDResultSetProxy.class$("java.lang.Object")) : class$java$lang$Object, Integer.TYPE}, new Object[]{new Integer(n), object, new Integer(n2)});
    }

    public void updateObject(String string, Object object, int n) throws SQLException {
        this.updateObject(this.findColumn(string), object, n);
    }

    public void updateRef(int n, Ref ref) throws SQLException {
        if (ref != null && !(ref instanceof Serializable)) {
            if (JDTrace.isTraceOn()) {
                JDTrace.logInformation(this, NOT_SERIALIZABLE);
            }
            throw new SQLException();
        }
        this.callMethod("updateRef", new Class[]{Integer.TYPE, class$java$sql$Ref == null ? (class$java$sql$Ref = JDResultSetProxy.class$("java.sql.Ref")) : class$java$sql$Ref}, new Object[]{new Integer(n), ref});
    }

    public void updateRef(String string, Ref ref) throws SQLException {
        if (ref != null && !(ref instanceof Serializable)) {
            if (JDTrace.isTraceOn()) {
                JDTrace.logInformation(this, NOT_SERIALIZABLE);
            }
            throw new SQLException();
        }
        this.callMethod("updateRef", new Class[]{class$java$lang$String == null ? (class$java$lang$String = JDResultSetProxy.class$("java.lang.String")) : class$java$lang$String, class$java$sql$Ref == null ? (class$java$sql$Ref = JDResultSetProxy.class$("java.sql.Ref")) : class$java$sql$Ref}, new Object[]{string, ref});
    }

    public void updateRow() throws SQLException {
        this.callMethod("updateRow");
    }

    public void updateShort(int n, short s) throws SQLException {
        this.callMethod("updateShort", new Class[]{Integer.TYPE, Short.TYPE}, new Object[]{new Integer(n), new Short(s)});
    }

    public void updateShort(String string, short s) throws SQLException {
        this.updateShort(this.findColumn(string), s);
    }

    public void updateString(int n, String string) throws SQLException {
        this.callMethod("updateString", new Class[]{Integer.TYPE, class$java$lang$String == null ? (class$java$lang$String = JDResultSetProxy.class$("java.lang.String")) : class$java$lang$String}, new Object[]{new Integer(n), string});
    }

    public void updateString(String string, String string2) throws SQLException {
        this.updateString(this.findColumn(string), string2);
    }

    public void updateTime(int n, Time time) throws SQLException {
        this.callMethod("updateTime", new Class[]{Integer.TYPE, class$java$sql$Time == null ? (class$java$sql$Time = JDResultSetProxy.class$("java.sql.Time")) : class$java$sql$Time}, new Object[]{new Integer(n), time});
    }

    public void updateTime(String string, Time time) throws SQLException {
        this.updateTime(this.findColumn(string), time);
    }

    public void updateTimestamp(int n, Timestamp timestamp) throws SQLException {
        this.callMethod("updateTimestamp", new Class[]{Integer.TYPE, class$java$sql$Timestamp == null ? (class$java$sql$Timestamp = JDResultSetProxy.class$("java.sql.Timestamp")) : class$java$sql$Timestamp}, new Object[]{new Integer(n), timestamp});
    }

    public void updateTimestamp(String string, Timestamp timestamp) throws SQLException {
        this.updateTimestamp(this.findColumn(string), timestamp);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

