/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400PortMapDS;
import com.ibm.as400.access.AS400PortMapReplyDS;
import com.ibm.as400.access.SSLOptions;
import com.ibm.as400.access.ServerStartupException;
import com.ibm.as400.access.SocketContainer;
import com.ibm.as400.access.SocketProperties;
import com.ibm.as400.access.Trace;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;
import java.util.Hashtable;

class PortMapper {
    private static Hashtable systemList = new Hashtable();
    static boolean unixSocketAvailable = true;

    private PortMapper() {
    }

    static void setServicePortsToDefault(String string) {
        int[] nArray = new int[]{8473, 8474, 8475, 8472, 8471, 446, 8470, 8476, 9473, 9474, 9475, 9472, 9471, 448, 9470, 9476};
        systemList.put(string, nArray);
    }

    static void setServicePort(String string, int n, int n2, SSLOptions sSLOptions) {
        int[] nArray;
        if (sSLOptions != null && sSLOptions.proxyEncryptionMode_ != 1) {
            n += 8;
        }
        if ((nArray = (int[])systemList.get(string)) == null) {
            int[] nArray2 = new int[]{-1, -1, -1, -1, -1, 446, -1, -1, -1, -1, -1, -1, -1, 448, -1, -1};
            nArray2[n] = n2;
            systemList.put(string, nArray2);
        } else {
            nArray[n] = n2;
        }
    }

    static int getServicePort(String string, int n, SSLOptions sSLOptions) {
        int[] nArray;
        if (sSLOptions != null && sSLOptions.proxyEncryptionMode_ != 1) {
            n += 8;
        }
        if ((nArray = (int[])systemList.get(string)) == null) {
            if (n == 5) {
                return 446;
            }
            if (n == 13) {
                return 448;
            }
            return -1;
        }
        return nArray[n];
    }

    private static boolean canUseUnixSocket(String string, int n, boolean bl) {
        if (AS400.onAS400 && unixSocketAvailable && !bl && n != 0 && string.equalsIgnoreCase("localhost")) {
            return n != 4 || AS400.nativeVRM.vrm_ >= 328960;
        }
        return false;
    }

    static SocketContainer getServerSocket(String string, int n, SSLOptions sSLOptions, SocketProperties socketProperties, boolean bl) throws IOException {
        Socket socket;
        int n2;
        SocketContainer socketContainer = null;
        String string2 = AS400.getServerName(n);
        if (PortMapper.canUseUnixSocket(string, n, bl)) {
            try {
                if (Trace.traceOn_) {
                    Trace.log(1, "Starting a local socket to " + string2);
                }
                SocketContainer socketContainer2 = socketContainer = AS400.nativeVRM.vrm_ < 328704 ? (SocketContainer)AS400.loadImpl("com.ibm.as400.access.SocketContainerUnix") : (SocketContainer)AS400.loadImpl("com.ibm.as400.access.SocketContainerUnix2");
                if (socketContainer != null) {
                    socketContainer.setProperties(null, string2, null, 0, null);
                    return socketContainer;
                }
            }
            catch (IOException iOException) {
                Trace.log(2, "Error attempting to connect with Unix Socket:", (Throwable)iOException);
                socketContainer = null;
            }
            unixSocketAvailable = false;
        }
        if ((n2 = PortMapper.getServicePort(string, n, sSLOptions)) == -1) {
            if (Trace.traceOn_) {
                Trace.log(1, "Connecting to port mapper...");
            }
            socket = new Socket(string, 449);
            InputStream inputStream = socket.getInputStream();
            OutputStream outputStream = socket.getOutputStream();
            String string3 = sSLOptions != null && sSLOptions.proxyEncryptionMode_ != 1 ? string2 + "-s" : string2;
            AS400PortMapDS aS400PortMapDS = new AS400PortMapDS(string3);
            aS400PortMapDS.write(outputStream);
            AS400PortMapReplyDS aS400PortMapReplyDS = new AS400PortMapReplyDS();
            aS400PortMapReplyDS.read(inputStream);
            socket.close();
            try {
                n2 = aS400PortMapReplyDS.getPort();
            }
            catch (ServerStartupException serverStartupException) {
                Trace.log(2, "Failed to map a port for " + string3, (Throwable)serverStartupException);
                throw serverStartupException;
            }
            if (Trace.traceOn_) {
                Trace.log(1, "Adding entry to Service Port table: system " + string + ", service " + string3 + ", port " + n2);
            }
            PortMapper.setServicePort(string, n, n2, sSLOptions);
        }
        if (Trace.traceOn_) {
            Trace.log(1, "Opening socket to system...");
        }
        socket = new Socket(string, n2);
        PortMapper.setSocketProperties(socket, socketProperties);
        if (sSLOptions != null && sSLOptions.proxyEncryptionMode_ != 1) {
            if (Trace.traceOn_) {
                Trace.log(1, "Starting a secure socket to " + string2);
            }
            try {
                if (sSLOptions.useSslight_) {
                    throw new Exception();
                }
                socketContainer = (SocketContainer)AS400.loadImpl("com.ibm.as400.access.SocketContainerJSSE");
                socketContainer.setProperties(socket, null, string, n2, null);
            }
            catch (Throwable throwable) {
                if (Trace.traceOn_) {
                    Trace.log(2, "Exception using JSSE falling back to sslight:", throwable);
                }
                socketContainer = (SocketContainer)AS400.loadImpl("com.ibm.as400.access.SocketContainerSSL");
                socketContainer.setProperties(socket, null, null, 0, sSLOptions);
            }
        } else {
            if (Trace.traceOn_) {
                Trace.log(1, "Starting an inet socket to " + string2);
            }
            socketContainer = (SocketContainer)AS400.loadImpl("com.ibm.as400.access.SocketContainerInet");
            socketContainer.setProperties(socket, null, null, 0, null);
        }
        return socketContainer;
    }

    static void setSocketProperties(Socket socket, SocketProperties socketProperties) throws SocketException {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting socket options...");
        }
        if (socketProperties.keepAliveSet_) {
            if (Trace.traceOn_) {
                Trace.log(1, "Setting keep alive:", socketProperties.keepAlive_);
            }
            socket.setKeepAlive(socketProperties.keepAlive_);
        }
        if (socketProperties.receiveBufferSizeSet_) {
            if (Trace.traceOn_) {
                Trace.log(1, "Setting receive buffer size:", socketProperties.receiveBufferSize_);
            }
            socket.setReceiveBufferSize(socketProperties.receiveBufferSize_);
        }
        if (socketProperties.sendBufferSizeSet_) {
            if (Trace.traceOn_) {
                Trace.log(1, "Setting send buffer size:", socketProperties.sendBufferSize_);
            }
            socket.setSendBufferSize(socketProperties.sendBufferSize_);
        }
        if (socketProperties.soLingerSet_) {
            if (Trace.traceOn_) {
                Trace.log(1, "Setting so linger:", socketProperties.soLinger_);
            }
            socket.setSoLinger(true, socketProperties.soLinger_);
        }
        if (socketProperties.soTimeoutSet_) {
            if (Trace.traceOn_) {
                Trace.log(1, "Setting so timeout:", socketProperties.soTimeout_);
            }
            socket.setSoTimeout(socketProperties.soTimeout_);
        }
        if (socketProperties.tcpNoDelaySet_) {
            if (Trace.traceOn_) {
                Trace.log(1, "Setting TCP no delay:", socketProperties.tcpNoDelay_);
            }
            socket.setTcpNoDelay(socketProperties.tcpNoDelay_);
        }
        if (Trace.traceOn_) {
            Trace.log(1, "Socket properties:");
            try {
                Trace.log(1, "    Remote address: " + socket.getInetAddress());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                Trace.log(1, "    Remote port:", socket.getPort());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                Trace.log(1, "    Local address: " + socket.getLocalAddress());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                Trace.log(1, "    Local port:", socket.getLocalPort());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                Trace.log(1, "    Keep alive:", socket.getKeepAlive());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                Trace.log(1, "    Receive buffer size:", socket.getReceiveBufferSize());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                Trace.log(1, "    Send buffer size:", socket.getSendBufferSize());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                Trace.log(1, "    So linger:", socket.getSoLinger());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                Trace.log(1, "    So timeout:", socket.getSoTimeout());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                Trace.log(1, "    TCP no delay:", socket.getTcpNoDelay());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

