/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.vaccess;

import com.ibm.as400.access.AS400Message;
import com.ibm.as400.access.CommandCall;
import com.ibm.as400.access.Printer;
import com.ibm.as400.access.Trace;
import com.ibm.as400.vaccess.DialogAction;
import com.ibm.as400.vaccess.ResourceLoader;
import com.ibm.as400.vaccess.VObject;
import com.ibm.as400.vaccess.VUtilities;
import java.awt.GridBagLayout;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;

class PrinterStopAction
extends DialogAction {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    private static final String displayName_ = ResourceLoader.getText("ACTION_STOP");
    private static String prtrToStopText_ = ResourceLoader.getPrintText("PRINTER_TO_STOP") + ":";
    private static String stopPrinterText_ = ResourceLoader.getPrintText("STOP_PRINTING") + ":";
    private static String immediatelyText_ = ResourceLoader.getPrintText("IMMEDIATELY");
    private static String pageEndText_ = ResourceLoader.getPrintText("AT_PAGE_END");
    private static String copyEndText_ = ResourceLoader.getPrintText("AT_COPY_END");
    private static boolean stringsLoaded_ = false;
    private Integer stringsLock_ = new Integer(0);
    private Printer printer_ = null;
    private JRadioButton immedButton_ = null;
    private JRadioButton endPageButton_ = null;
    private JRadioButton endCopyButton_ = null;

    public PrinterStopAction(VObject vObject, Printer printer) {
        super(vObject);
        this.printer_ = printer;
    }

    public JComponent getInputComponent() {
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        jPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        try {
            if (!stringsLoaded_) {
                this.loadMRI();
            }
            VUtilities.constrain(new JLabel(prtrToStopText_), jPanel, gridBagLayout, 0, 0, 1, 1);
            JTextField jTextField = new JTextField(this.printer_.getName().trim());
            jTextField.setEditable(false);
            VUtilities.constrain(jTextField, jPanel, gridBagLayout, 1, 0, 1, 1);
            VUtilities.constrain(new JLabel(" "), jPanel, gridBagLayout, 0, 1, 2, 1);
            VUtilities.constrain(new JLabel(stopPrinterText_), jPanel, gridBagLayout, 0, 2, 1, 1);
            this.immedButton_ = new JRadioButton(immediatelyText_);
            this.immedButton_.setHorizontalAlignment(2);
            this.immedButton_.setSelected(true);
            this.endPageButton_ = new JRadioButton(pageEndText_);
            this.endPageButton_.setHorizontalAlignment(2);
            this.endCopyButton_ = new JRadioButton(copyEndText_);
            this.endCopyButton_.setHorizontalAlignment(2);
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(this.immedButton_);
            buttonGroup.add(this.endPageButton_);
            buttonGroup.add(this.endCopyButton_);
            VUtilities.constrain(this.immedButton_, jPanel, gridBagLayout, 0, 3, 1, 1);
            VUtilities.constrain(this.endPageButton_, jPanel, gridBagLayout, 0, 4, 1, 1);
            VUtilities.constrain(this.endCopyButton_, jPanel, gridBagLayout, 0, 5, 1, 1);
        }
        catch (Exception exception) {
            jPanel = null;
            this.fireError(exception);
        }
        return jPanel;
    }

    public String getText() {
        return displayName_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadMRI() {
        Integer n = this.stringsLock_;
        synchronized (n) {
            prtrToStopText_ = ResourceLoader.getPrintText("PRINTER_TO_STOP") + ":";
            stopPrinterText_ = ResourceLoader.getPrintText("STOP_PRINTING") + ":";
            immediatelyText_ = ResourceLoader.getPrintText("IMMEDIATELY");
            pageEndText_ = ResourceLoader.getPrintText("AT_PAGE_END");
            copyEndText_ = ResourceLoader.getPrintText("AT_COPY_END");
            stringsLoaded_ = true;
        }
    }

    public void perform2() {
        try {
            this.fireStartWorking();
            String string = this.printer_.getStringAttribute(121).trim();
            if (string == null || string == "") {
                if (Trace.isTraceOn()) {
                    Trace.log(2, "ERROR No writer for [" + this.printer_.getName() + "].");
                }
                Exception exception = new Exception(ResourceLoader.getText("EXC_AS400_ERROR"));
                this.fireError(exception);
            } else {
                CommandCall commandCall = new CommandCall(this.printer_.getSystem());
                String string2 = new String("ENDWTR WTR(" + this.printer_.getName() + ") OPTION(");
                try {
                    AS400Message[] aS400MessageArray;
                    if (this.immedButton_.isSelected()) {
                        string2 = string2 + "*IMMED)";
                    } else if (this.endPageButton_.isSelected()) {
                        string2 = string2 + "*PAGEEND)";
                    } else if (this.endCopyButton_.isSelected()) {
                        string2 = string2 + "*CNTRLD)";
                    }
                    if (!commandCall.run(string2)) {
                        if (Trace.isTraceOn()) {
                            Trace.log(2, "ERROR ENDWTR cmd for [" + this.printer_.getName() + "].");
                        }
                        aS400MessageArray = new Exception(ResourceLoader.getText("EXC_AS400_ERROR"));
                        this.fireError((Exception)aS400MessageArray);
                    } else {
                        if (Trace.isTraceOn()) {
                            Trace.log(3, "Stopped printer [" + this.printer_.getName() + "].");
                        }
                        this.fireObjectChanged();
                    }
                    if (Trace.isTraceOn()) {
                        aS400MessageArray = commandCall.getMessageList();
                        for (int i = 0; i < aS400MessageArray.length; ++i) {
                            Trace.log(3, aS400MessageArray[i].getText());
                        }
                    }
                }
                catch (Exception exception) {
                    if (Trace.isTraceOn()) {
                        Trace.log(2, "ERROR CommandCall exception for [" + this.printer_.getName() + "].");
                    }
                    this.fireError(exception);
                }
            }
            this.fireStopWorking();
        }
        catch (Exception exception) {
            if (Trace.isTraceOn()) {
                Trace.log(2, "ERROR Stopping printer [" + this.printer_.getName() + "].");
            }
            this.fireError(exception);
        }
    }
}

