/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jxls.reader;

import java.util.ArrayList;
import java.util.List;
import net.sf.jxls.reader.OffsetCellCheck;
import net.sf.jxls.reader.OffsetRowCheck;
import net.sf.jxls.reader.XLSRowCursor;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;

public class OffsetRowCheckImpl
implements OffsetRowCheck {
    List cellChecks = new ArrayList();
    int offset;

    public OffsetRowCheckImpl() {
    }

    public OffsetRowCheckImpl(int offset) {
        this.offset = offset;
    }

    public OffsetRowCheckImpl(List cellChecks) {
        this.cellChecks = cellChecks;
    }

    @Override
    public int getOffset() {
        return this.offset;
    }

    @Override
    public void setOffset(int offset) {
        this.offset = offset;
    }

    public List getCellChecks() {
        return this.cellChecks;
    }

    public void setCellChecks(List cellChecks) {
        this.cellChecks = cellChecks;
    }

    @Override
    public boolean isCheckSuccessful(Row row) {
        if (this.cellChecks.isEmpty()) {
            return this.isRowEmpty(row);
        }
        for (int i = 0; i < this.cellChecks.size(); ++i) {
            OffsetCellCheck offsetCellCheck = (OffsetCellCheck)this.cellChecks.get(i);
            if (offsetCellCheck.isCheckSuccessful(row)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isCheckSuccessful(XLSRowCursor cursor) {
        if (!cursor.hasNext()) {
            return this.isCellChecksEmpty();
        }
        Row row = cursor.getSheet().getRow(this.offset + cursor.getCurrentRowNum());
        if (row == null) {
            return this.cellChecks.isEmpty();
        }
        return this.isCheckSuccessful(row);
    }

    private boolean isCellChecksEmpty() {
        if (this.cellChecks.isEmpty()) {
            return true;
        }
        for (int i = 0; i < this.cellChecks.size(); ++i) {
            OffsetCellCheck offsetCellCheck = (OffsetCellCheck)this.cellChecks.get(i);
            if (this.isCellCheckEmpty(offsetCellCheck)) continue;
            return false;
        }
        return true;
    }

    private boolean isCellCheckEmpty(OffsetCellCheck cellCheck) {
        if (cellCheck.getValue() == null) {
            return true;
        }
        return cellCheck.getValue().toString().trim().equals("");
    }

    @Override
    public void addCellCheck(OffsetCellCheck cellCheck) {
        this.cellChecks.add(cellCheck);
    }

    private boolean isRowEmpty(Row row) {
        if (row == null) {
            return true;
        }
        for (short i = row.getFirstCellNum(); i <= row.getLastCellNum(); i = (short)(i + 1)) {
            Cell cell = row.getCell((int)i);
            if (this.isCellEmpty(cell)) continue;
            return false;
        }
        return true;
    }

    private boolean isCellEmpty(Cell cell) {
        if (cell == null) {
            return true;
        }
        switch (cell.getCellType()) {
            case BLANK: {
                return true;
            }
            case STRING: {
                String cellValue = cell.getRichStringCellValue().getString();
                return cellValue == null || cellValue.length() == 0 || cellValue.trim().length() == 0;
            }
        }
        return false;
    }
}

