/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jxls.reader;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import net.sf.jxls.reader.BeanCellMapping;
import net.sf.jxls.reader.OffsetCellCheckImpl;
import net.sf.jxls.reader.OffsetRowCheck;
import net.sf.jxls.reader.OffsetRowCheckImpl;
import net.sf.jxls.reader.SectionCheck;
import net.sf.jxls.reader.SimpleBlockReader;
import net.sf.jxls.reader.SimpleBlockReaderImpl;
import net.sf.jxls.reader.SimpleSectionCheck;
import net.sf.jxls.reader.XLSForEachBlockReaderImpl;
import net.sf.jxls.reader.XLSLoopBlockReader;
import net.sf.jxls.reader.XLSReader;
import net.sf.jxls.reader.XLSReaderImpl;
import net.sf.jxls.reader.XLSSheetReader;
import net.sf.jxls.reader.XLSSheetReaderImpl;
import org.apache.commons.digester.Digester;
import org.xml.sax.SAXException;

public class ReaderBuilder {
    XLSReader reader = new XLSReaderImpl();
    XLSSheetReader currentSheetReader;
    SimpleBlockReader currentSimpleBlockReader;
    XLSLoopBlockReader currentLoopBlockReader;
    boolean lastSheetReader = false;
    SectionCheck currentSectionCheck;
    OffsetRowCheck currentRowCheck;

    public static XLSReader buildFromXML(InputStream xmlStream) throws IOException, SAXException {
        Digester digester = new Digester();
        digester.setValidating(false);
        digester.addObjectCreate("workbook", "net.sf.jxls.reader.XLSReaderImpl");
        digester.addObjectCreate("workbook/worksheet", "net.sf.jxls.reader.XLSSheetReaderImpl");
        digester.addSetProperties("workbook/worksheet", "name", "sheetName");
        digester.addSetProperties("workbook/worksheet", "idx", "sheetIdx");
        digester.addSetNext("workbook/worksheet", "addSheetReader");
        digester.addObjectCreate("*/loop", "net.sf.jxls.reader.XLSForEachBlockReaderImpl");
        digester.addSetProperties("*/loop");
        digester.addSetNext("*/loop", "addBlockReader");
        digester.addObjectCreate("*/section", "net.sf.jxls.reader.SimpleBlockReaderImpl");
        digester.addSetProperties("*/section");
        digester.addSetNext("*/section", "addBlockReader");
        digester.addObjectCreate("*/mapping", "net.sf.jxls.reader.BeanCellMapping");
        digester.addSetProperties("*/mapping");
        digester.addCallMethod("*/mapping", "setFullPropertyName", 1);
        digester.addCallParam("*/mapping", 0);
        digester.addSetNext("*/mapping", "addMapping");
        digester.addObjectCreate("*/loop/loopbreakcondition", "net.sf.jxls.reader.SimpleSectionCheck");
        digester.addSetNext("*/loop/loopbreakcondition", "setLoopBreakCondition");
        digester.addObjectCreate("*/loopbreakcondition/rowcheck", "net.sf.jxls.reader.OffsetRowCheckImpl");
        digester.addSetProperties("*/loopbreakcondition/rowcheck");
        digester.addSetNext("*/loopbreakcondition/rowcheck", "addRowCheck");
        digester.addObjectCreate("*/rowcheck/cellcheck", "net.sf.jxls.reader.OffsetCellCheckImpl");
        digester.addSetProperties("*/rowcheck/cellcheck");
        digester.addCallMethod("*/rowcheck/cellcheck", "setValue", 1);
        digester.addCallParam("*/rowcheck/cellcheck", 0);
        digester.addSetNext("*/rowcheck/cellcheck", "addCellCheck");
        return (XLSReader)digester.parse(xmlStream);
    }

    public static XLSReader buildFromXML(File xmlFile) throws IOException, SAXException {
        BufferedInputStream xmlStream = new BufferedInputStream(new FileInputStream(xmlFile));
        XLSReader reader = ReaderBuilder.buildFromXML(xmlStream);
        ((InputStream)xmlStream).close();
        return reader;
    }

    public ReaderBuilder addSheetReader(String sheetName) {
        XLSSheetReaderImpl sheetReader = new XLSSheetReaderImpl();
        this.reader.addSheetReader(sheetName, (XLSSheetReader)sheetReader);
        this.currentSheetReader = sheetReader;
        this.lastSheetReader = true;
        return this;
    }

    public XLSReader getReader() {
        return this.reader;
    }

    public ReaderBuilder addSimpleBlockReader(int startRow, int endRow) {
        SimpleBlockReaderImpl blockReader = new SimpleBlockReaderImpl(startRow, endRow);
        if (this.lastSheetReader) {
            this.currentSheetReader.addBlockReader(blockReader);
        } else {
            this.currentLoopBlockReader.addBlockReader(blockReader);
        }
        this.currentSimpleBlockReader = blockReader;
        return this;
    }

    public ReaderBuilder addMapping(String cellName, String propertyName) {
        BeanCellMapping mapping = new BeanCellMapping(cellName, propertyName);
        this.currentSimpleBlockReader.addMapping(mapping);
        return this;
    }

    public ReaderBuilder addLoopBlockReader(int startRow, int endRow, String items, String varName, Class varType) {
        XLSForEachBlockReaderImpl loopReader = new XLSForEachBlockReaderImpl(startRow, endRow, items, varName, varType);
        if (this.lastSheetReader) {
            this.currentSheetReader.addBlockReader(loopReader);
        } else {
            this.currentLoopBlockReader.addBlockReader(loopReader);
        }
        this.currentLoopBlockReader = loopReader;
        return this;
    }

    public ReaderBuilder addLoopBreakCondition() {
        SimpleSectionCheck condition = new SimpleSectionCheck();
        this.currentLoopBlockReader.setLoopBreakCondition(condition);
        this.currentSectionCheck = condition;
        return this;
    }

    public ReaderBuilder addOffsetRowCheck(int offset) {
        OffsetRowCheckImpl rowCheck = new OffsetRowCheckImpl(offset);
        this.currentSectionCheck.addRowCheck(rowCheck);
        this.currentRowCheck = rowCheck;
        return this;
    }

    public ReaderBuilder addOffsetCellCheck(short offset, String value) {
        OffsetCellCheckImpl cellCheck = new OffsetCellCheckImpl(offset, value);
        this.currentRowCheck.addCellCheck(cellCheck);
        return this;
    }

    public ReaderBuilder addSimpleBlockReaderToParent() {
        return this;
    }

    public ReaderBuilder addLoopBlockReaderToParent() {
        return this;
    }
}

