/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.collection.base;

import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class CollectionList<E>
extends ArrayList<E> {
    private static final long serialVersionUID = -8534525840753920810L;
    private Collection<E> delegate;

    public CollectionList(Collection<E> delegate) {
        super(delegate);
        this.delegate = delegate;
    }

    public Collection<E> getDelegate() {
        return this.delegate;
    }

    @Override
    public E set(int index, E element) {
        E old = super.set(index, element);
        this.delegate.remove(old);
        this.delegate.add(element);
        return old;
    }

    @Override
    public boolean add(E element) {
        boolean added = this.delegate.add(element);
        if (added) {
            super.add(element);
        }
        return added;
    }

    @Override
    public void add(int index, E element) {
        this.delegate.add(element);
        super.add(index, element);
    }

    @Override
    public E remove(int index) {
        Object element = super.remove(index);
        this.delegate.remove(element);
        return element;
    }

    @Override
    public boolean remove(Object o) {
        this.delegate.remove(o);
        return super.remove(o);
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        this.delegate.addAll(collection);
        return super.addAll(collection);
    }

    @Override
    public Iterator<E> iterator() {
        return new ListIterator();
    }

    static /* synthetic */ int access$100(CollectionList x0) {
        return x0.modCount;
    }

    private class ListIterator
    implements Iterator<E> {
        private int cursor;
        private int lastRet = -1;
        private int expectedModCount = CollectionList.access$100(CollectionList.this);

        private ListIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.cursor != CollectionList.this.size();
        }

        @Override
        public E next() {
            this.checkForComodification();
            try {
                Object next = CollectionList.this.get(this.cursor);
                this.lastRet = this.cursor++;
                return next;
            }
            catch (IndexOutOfBoundsException e) {
                this.checkForComodification();
                throw new NoSuchElementException();
            }
        }

        @Override
        public void remove() {
            if (this.lastRet == -1) {
                throw new IllegalStateException();
            }
            this.checkForComodification();
            try {
                Object element = CollectionList.this.remove(this.lastRet);
                CollectionList.this.delegate.remove(element);
                if (this.lastRet < this.cursor) {
                    --this.cursor;
                }
                this.lastRet = -1;
                this.expectedModCount = CollectionList.this.modCount;
            }
            catch (IndexOutOfBoundsException e) {
                throw new ConcurrentModificationException();
            }
        }

        final void checkForComodification() {
            if (CollectionList.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
        }
    }
}

