/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.component.base;

import java.util.concurrent.atomic.AtomicInteger;

public class InitializationState {
    private static final int STATE_UNINITIALIZED = 0;
    private static final int STATE_INITIALIZING = 1;
    private static final int STATE_INITIALIZED = 2;
    private AtomicInteger state = new AtomicInteger(0);

    public boolean setInitializing() {
        return this.state.compareAndSet(0, 1);
    }

    public void setInitialized() {
        boolean okay = this.state.compareAndSet(1, 2);
        if (!okay) {
            if (this.isInitialized()) {
                throw new IllegalStateException("Already initialized.");
            }
            throw new IllegalStateException("You need to call setInitializing() before!");
        }
    }

    public boolean isInitialized() {
        return this.state.get() == 2;
    }

    public boolean isInitializing() {
        return this.state.get() == 1;
    }

    public void requireInitilized() throws IllegalStateException {
        if (!this.isInitialized()) {
            throw new IllegalStateException("Not initialized.");
        }
    }

    public void requireNotInitilized() throws IllegalStateException {
        if (this.isInitialized()) {
            throw new IllegalStateException("Already initialized.");
        }
    }
}

