/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.lang.api;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Calendar;
import java.util.Date;
import javax.xml.datatype.XMLGregorianCalendar;
import net.sf.mmm.util.lang.api.CompareOperator;

final class ComparatorHelper {
    private ComparatorHelper() {
    }

    static Object convert(Object object, Class<?> otherType) {
        if (otherType == Date.class) {
            if (object instanceof Calendar) {
                return ((Calendar)object).getTime();
            }
            if (object instanceof XMLGregorianCalendar) {
                return ((XMLGregorianCalendar)object).toGregorianCalendar().getTime();
            }
        } else if (otherType == BigDecimal.class) {
            if (object instanceof BigInteger) {
                return new BigDecimal((BigInteger)object);
            }
            if (object instanceof Number) {
                return BigDecimal.valueOf(((Number)object).doubleValue());
            }
        } else if (otherType == BigInteger.class && !(object instanceof BigDecimal) && object instanceof Number) {
            return BigInteger.valueOf(((Number)object).longValue());
        }
        return object;
    }

    static boolean evalComparable(CompareOperator comparator, Comparable arg1, Comparable arg2) {
        int delta;
        Class<?> type2;
        Class<?> type1 = arg1.getClass();
        if (type1.equals(type2 = arg2.getClass()) || type1.isAssignableFrom(type2)) {
            delta = ComparatorHelper.signum(arg1.compareTo(arg2));
        } else if (type2.isAssignableFrom(type1)) {
            delta = -ComparatorHelper.signum(arg2.compareTo(arg1));
        } else {
            return arg1.equals(arg2) == comparator.isTrueIfEquals();
        }
        return comparator.eval(delta);
    }

    private static int signum(int delta) {
        if (delta < 0) {
            return -1;
        }
        if (delta > 0) {
            return 1;
        }
        return 0;
    }
}

