/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.lang.api;

import net.sf.mmm.util.lang.api.ComparatorHelper;
import net.sf.mmm.util.lang.api.attribute.AttributeReadValue;

public enum CompareOperator implements AttributeReadValue<String>
{
    GREATER_THAN(">", "greater than"){

        @Override
        public boolean eval(int delta) {
            return delta > 0;
        }

        @Override
        public CompareOperator negate() {
            return LESS_OR_EQUAL;
        }
    }
    ,
    GREATER_OR_EQUAL(">=", "greater or equal to"){

        @Override
        public boolean eval(int delta) {
            return delta >= 0;
        }

        @Override
        public CompareOperator negate() {
            return LESS_THAN;
        }
    }
    ,
    LESS_THAN("<", "less than"){

        @Override
        public boolean eval(int delta) {
            if (delta == Integer.MIN_VALUE) {
                return false;
            }
            return delta < 0;
        }

        @Override
        public CompareOperator negate() {
            return GREATER_OR_EQUAL;
        }
    }
    ,
    LESS_OR_EQUAL("<=", "less or equal to"){

        @Override
        public boolean eval(int delta) {
            if (delta == Integer.MIN_VALUE) {
                return false;
            }
            return delta <= 0;
        }

        @Override
        public CompareOperator negate() {
            return GREATER_THAN;
        }
    }
    ,
    EQUAL("==", "equal to"){

        @Override
        public boolean eval(int delta) {
            return delta == 0;
        }

        @Override
        public CompareOperator negate() {
            return NOT_EQUAL;
        }
    }
    ,
    NOT_EQUAL("!=", "not equal to"){

        @Override
        public boolean eval(int delta) {
            return delta != 0;
        }

        @Override
        public CompareOperator negate() {
            return EQUAL;
        }
    };

    private final String value;
    private final String title;

    private CompareOperator(String value, String title) {
        this.value = value;
        this.title = title;
    }

    boolean isTrueIfEquals() {
        return this == EQUAL || this == GREATER_OR_EQUAL || this == LESS_OR_EQUAL;
    }

    boolean isTrueIfLess() {
        return this == LESS_THAN || this == LESS_OR_EQUAL || this == NOT_EQUAL;
    }

    boolean isTrueIfGreater() {
        return this == GREATER_THAN || this == GREATER_OR_EQUAL || this == NOT_EQUAL;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    public final boolean eval(double arg1, double arg2) {
        double delta = arg1 - arg2;
        if (delta < 0.0) {
            return this.eval(-1);
        }
        if (delta > 0.0) {
            return this.eval(1);
        }
        return this.eval(0);
    }

    public abstract boolean eval(int var1);

    public abstract CompareOperator negate();

    private Object convert(Object object, Class<?> otherType) {
        return ComparatorHelper.convert(object, otherType);
    }

    private boolean evalComparable(Comparable arg1, Comparable arg2) {
        return ComparatorHelper.evalComparable(this, arg1, arg2);
    }

    public boolean eval(Object arg1, Object arg2) {
        Class<?> type2;
        if (arg1 == arg2) {
            return this.isTrueIfEquals();
        }
        if (arg1 == null || arg2 == null) {
            return !this.isTrueIfEquals();
        }
        Object v1 = arg1;
        Object v2 = arg2;
        Class<?> type1 = v1.getClass();
        if (!type1.equals(type2 = v2.getClass())) {
            v1 = this.convert(v1, type2);
            v2 = this.convert(v2, type1);
            if (v1 == arg1 && v2 == arg2 && v1 instanceof Number && v2 instanceof Number) {
                return this.eval(((Number)v1).doubleValue(), ((Number)v2).doubleValue());
            }
        }
        if (v1 instanceof Comparable && v2 instanceof Comparable) {
            return this.evalComparable((Comparable)v1, (Comparable)v2);
        }
        if (v1.equals(v2)) {
            return this.isTrueIfEquals();
        }
        return !this.isTrueIfEquals();
    }

    public String toString() {
        return this.title;
    }

    public static CompareOperator fromValue(String value) {
        for (CompareOperator comparator : CompareOperator.values()) {
            if (!comparator.value.equals(value)) continue;
            return comparator;
        }
        return null;
    }
}

