/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.lang.api;

import java.util.Locale;

public final class LocaleHelper {
    public static final char SEPARATOR_DEFAULT = '_';
    public static final char SEPARATOR_FOR_LANGUAGE_TAG = '-';

    private LocaleHelper() {
    }

    public static String[] getLocaleInfixes(Locale locale) {
        int length = 1;
        StringBuilder infix = new StringBuilder();
        String infixLang = null;
        String language = locale.getLanguage();
        infix.append('_');
        if (language != null && language.length() == 2) {
            infix.append(language);
            infixLang = infix.toString();
            ++length;
        }
        String infixCountry = null;
        String country = locale.getCountry();
        infix.append('_');
        if (country != null && country.length() == 2) {
            infix.append(country);
            infixCountry = infix.toString();
            ++length;
        }
        String infixVariant = null;
        String variant = locale.getVariant();
        infix.append('_');
        if (variant != null && variant.length() > 0) {
            infix.append(variant);
            infixVariant = infix.toString();
            ++length;
        }
        String[] infixes = new String[length];
        int i = 0;
        if (infixVariant != null) {
            infixes[i] = infixVariant;
            ++i;
        }
        if (infixCountry != null) {
            infixes[i] = infixCountry;
            ++i;
        }
        if (infixLang != null) {
            infixes[i] = infixLang;
            ++i;
        }
        infixes[i] = "";
        return infixes;
    }

    public static Locale getLocale(String locale) {
        String languageTag = locale.replace('_', '-');
        if (!languageTag.isEmpty() && languageTag.charAt(0) == '-') {
            languageTag = languageTag.substring(1);
        }
        return Locale.forLanguageTag(languageTag);
    }
}

