/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.editor;

import proguard.classfile.Clazz;
import proguard.classfile.LibraryClass;
import proguard.classfile.LibraryMember;
import proguard.classfile.LibraryMethod;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramMember;
import proguard.classfile.ProgramMethod;
import proguard.classfile.constant.ClassConstant;
import proguard.classfile.constant.RefConstant;
import proguard.classfile.constant.StringConstant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.util.AccessUtil;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.MemberAccessFilter;
import proguard.classfile.visitor.MemberVisitor;
import proguard.classfile.visitor.NamedMethodVisitor;
import proguard.classfile.visitor.ReferencedClassVisitor;

public class AccessFixer
extends ReferencedClassVisitor
implements ClassVisitor {
    private final ConstantVisitor referencedClassStorer = new MyReferencedClassStorer();

    public AccessFixer() {
        super(new MyAccessFixer());
    }

    public void visitProgramClass(ProgramClass programClass) {
        ((MyAccessFixer)this.classVisitor).referencingClass = programClass;
        super.visitProgramClass(programClass);
    }

    public void visitLibraryClass(LibraryClass libraryClass) {
        ((MyAccessFixer)this.classVisitor).referencingClass = libraryClass;
        super.visitLibraryClass(libraryClass);
    }

    public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
        super.visitProgramMember(programClass, programMethod);
        if ((programMethod.getAccessFlags() & 0xA) == 0 && !ClassUtil.isInitializer(programMethod.getName(programClass))) {
            programClass.hierarchyAccept(false, true, false, false, new NamedMethodVisitor(programMethod.getName(programClass), programMethod.getDescriptor(programClass), new MemberAccessFilter(0, 10, (MemberVisitor)((Object)this.classVisitor))));
        }
    }

    public void visitLibraryMethod(LibraryClass libraryClass, LibraryMethod libraryMethod) {
        super.visitLibraryMember(libraryClass, libraryMethod);
        if ((libraryMethod.getAccessFlags() & 0xA) == 0 && !ClassUtil.isInitializer(libraryMethod.getName(libraryClass))) {
            libraryClass.hierarchyAccept(false, true, false, false, new NamedMethodVisitor(libraryMethod.getName(libraryClass), libraryMethod.getDescriptor(libraryClass), new MemberAccessFilter(0, 10, (MemberVisitor)((Object)this.classVisitor))));
        }
    }

    public void visitStringConstant(Clazz clazz, StringConstant stringConstant) {
        super.visitStringConstant(clazz, stringConstant);
        stringConstant.referencedMemberAccept((MemberVisitor)((Object)this.classVisitor));
    }

    public void visitAnyRefConstant(Clazz clazz, RefConstant refConstant) {
        if (ClassUtil.isInternalArrayType(refConstant.getClassName(clazz))) {
            ((MyAccessFixer)this.classVisitor).referencedClass = refConstant.referencedClass;
        } else {
            clazz.constantPoolEntryAccept(refConstant.u2classIndex, this.referencedClassStorer);
        }
        super.visitAnyRefConstant(clazz, refConstant);
        refConstant.referencedMemberAccept((MemberVisitor)((Object)this.classVisitor));
    }

    private static class MyAccessFixer
    extends SimplifiedVisitor
    implements ClassVisitor,
    MemberVisitor {
        private Clazz referencingClass;
        private Clazz referencedClass;

        private MyAccessFixer() {
        }

        public void visitLibraryClass(LibraryClass libraryClass) {
        }

        public void visitProgramClass(ProgramClass programClass) {
            int requiredAccessLevel;
            int currentAccessFlags = programClass.getAccessFlags();
            int currentAccessLevel = AccessUtil.accessLevel(currentAccessFlags);
            int n = requiredAccessLevel = this.inSamePackage(programClass, this.referencingClass) ? 1 : 3;
            if (currentAccessLevel < requiredAccessLevel) {
                programClass.u2accessFlags = AccessUtil.replaceAccessFlags(currentAccessFlags, AccessUtil.accessFlags(requiredAccessLevel));
            }
        }

        public void visitLibraryMember(LibraryClass libraryClass, LibraryMember libraryMember) {
        }

        public void visitProgramMember(ProgramClass programClass, ProgramMember programMember) {
            int requiredAccessLevel;
            int currentAccessFlags = programMember.getAccessFlags();
            int currentAccessLevel = AccessUtil.accessLevel(currentAccessFlags);
            int n = programClass.equals(this.referencingClass) ? 0 : (this.inSamePackage(programClass, this.referencingClass) ? 1 : (requiredAccessLevel = this.referencedClass != null && this.referencingClass.extends_(this.referencedClass) && this.referencingClass.extends_(programClass) ? 2 : 3));
            if (currentAccessLevel < requiredAccessLevel) {
                programMember.u2accessFlags = AccessUtil.replaceAccessFlags(currentAccessFlags, AccessUtil.accessFlags(requiredAccessLevel));
            }
        }

        private boolean inSamePackage(Clazz class1, Clazz class2) {
            return ClassUtil.internalPackageName(class1.getName()).equals(ClassUtil.internalPackageName(class2.getName()));
        }
    }

    private class MyReferencedClassStorer
    extends SimplifiedVisitor
    implements ConstantVisitor {
        private MyReferencedClassStorer() {
        }

        public void visitClassConstant(Clazz clazz, ClassConstant classConstant) {
            ((MyAccessFixer)AccessFixer.this.classVisitor).referencedClass = classConstant.referencedClass;
        }
    }
}

